/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.contract.codec;

import com.hedera.hapi.node.state.contract.Bytecode;
import com.hedera.hapi.node.state.contract.schema.BytecodeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class BytecodeProtoCodec
implements Codec<Bytecode> {
    @NonNull
    public Bytecode parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Bytecode parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Bytecode data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)BytecodeSchema.CODE, (RandomAccessData)data.code());
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Bytecode data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BytecodeSchema.CODE, (RandomAccessData)data.code());
    }

    public boolean fastEquals(@NonNull Bytecode item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    @NonNull
    private Bytecode parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            Bytes temp_code = Bytes.EMPTY;
            block7: while (input.hasRemaining()) {
                int tag;
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                int field = tag >>> 3;
                FieldDefinition f = BytecodeSchema.getField(field);
                switch (tag) {
                    case 10: {
                        Bytes value;
                        temp_code = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new Bytecode(temp_code);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

