/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.primitives.codec;

import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.primitives.schema.ProtoBytesSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ProtoBytesProtoCodec
implements Codec<ProtoBytes> {
    @NonNull
    public ProtoBytes parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ProtoBytes parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ProtoBytes data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ProtoBytesSchema.VALUE, (RandomAccessData)data.value());
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ProtoBytes data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ProtoBytesSchema.VALUE, (RandomAccessData)data.value());
    }

    public boolean fastEquals(@NonNull ProtoBytes item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    @NonNull
    private ProtoBytes parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            Bytes temp_value = Bytes.EMPTY;
            block7: while (input.hasRemaining()) {
                int tag;
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                int field = tag >>> 3;
                FieldDefinition f = ProtoBytesSchema.getField(field);
                switch (tag) {
                    case 10: {
                        Bytes value;
                        temp_value = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new ProtoBytes(temp_value);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

