/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.recordcache;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.recordcache.codec.TransactionRecordEntryJsonCodec;
import com.hedera.hapi.node.state.recordcache.codec.TransactionRecordEntryProtoCodec;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TransactionRecordEntry(long nodeId, @Nullable AccountID payerAccountId, @Nullable TransactionRecord transactionRecord) {
    public static final Codec<TransactionRecordEntry> PROTOBUF = new TransactionRecordEntryProtoCodec();
    public static final JsonCodec<TransactionRecordEntry> JSON = new TransactionRecordEntryJsonCodec();
    public static final TransactionRecordEntry DEFAULT = TransactionRecordEntry.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.nodeId != TransactionRecordEntry.DEFAULT.nodeId) {
            result = 31 * result + Long.hashCode(this.nodeId);
        }
        if (this.payerAccountId != null && !this.payerAccountId.equals(TransactionRecordEntry.DEFAULT.payerAccountId)) {
            result = 31 * result + this.payerAccountId.hashCode();
        }
        if (this.transactionRecord != null && !this.transactionRecord.equals(TransactionRecordEntry.DEFAULT.transactionRecord)) {
            result = 31 * result + this.transactionRecord.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransactionRecordEntry thatObj = (TransactionRecordEntry)that;
        if (this.nodeId != thatObj.nodeId) {
            return false;
        }
        if (this.payerAccountId == null && thatObj.payerAccountId != null) {
            return false;
        }
        if (this.payerAccountId != null && !this.payerAccountId.equals(thatObj.payerAccountId)) {
            return false;
        }
        if (this.transactionRecord == null && thatObj.transactionRecord != null) {
            return false;
        }
        return this.transactionRecord == null || this.transactionRecord.equals(thatObj.transactionRecord);
    }

    public boolean hasPayerAccountId() {
        return this.payerAccountId != null;
    }

    public AccountID payerAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasPayerAccountId() ? this.payerAccountId : defaultValue;
    }

    @NonNull
    public AccountID payerAccountIdOrThrow() {
        return Objects.requireNonNull(this.payerAccountId, "Field payerAccountId is null");
    }

    public void ifPayerAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasPayerAccountId()) {
            ifPresent.accept(this.payerAccountId);
        }
    }

    public boolean hasTransactionRecord() {
        return this.transactionRecord != null;
    }

    public TransactionRecord transactionRecordOrElse(@NonNull TransactionRecord defaultValue) {
        return this.hasTransactionRecord() ? this.transactionRecord : defaultValue;
    }

    @NonNull
    public TransactionRecord transactionRecordOrThrow() {
        return Objects.requireNonNull(this.transactionRecord, "Field transactionRecord is null");
    }

    public void ifTransactionRecord(@NonNull Consumer<TransactionRecord> ifPresent) {
        if (this.hasTransactionRecord()) {
            ifPresent.accept(this.transactionRecord);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.nodeId, this.payerAccountId, this.transactionRecord);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long nodeId = 0L;
        @Nullable
        private AccountID payerAccountId = null;
        @Nullable
        private TransactionRecord transactionRecord = null;

        public Builder() {
        }

        public Builder(long nodeId, AccountID payerAccountId, TransactionRecord transactionRecord) {
            this.nodeId = nodeId;
            this.payerAccountId = payerAccountId;
            this.transactionRecord = transactionRecord;
        }

        public TransactionRecordEntry build() {
            return new TransactionRecordEntry(this.nodeId, this.payerAccountId, this.transactionRecord);
        }

        public Builder nodeId(long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder payerAccountId(@Nullable AccountID payerAccountId) {
            this.payerAccountId = payerAccountId;
            return this;
        }

        public Builder payerAccountId(AccountID.Builder builder) {
            this.payerAccountId = builder.build();
            return this;
        }

        public Builder transactionRecord(@Nullable TransactionRecord transactionRecord) {
            this.transactionRecord = transactionRecord;
            return this;
        }

        public Builder transactionRecord(TransactionRecord.Builder builder) {
            this.transactionRecord = builder.build();
            return this;
        }
    }
}

