/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.throttles;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.throttles.codec.ThrottleUsageSnapshotJsonCodec;
import com.hedera.hapi.node.state.throttles.codec.ThrottleUsageSnapshotProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ThrottleUsageSnapshot(long used, @Nullable Timestamp lastDecisionTime) {
    public static final Codec<ThrottleUsageSnapshot> PROTOBUF = new ThrottleUsageSnapshotProtoCodec();
    public static final JsonCodec<ThrottleUsageSnapshot> JSON = new ThrottleUsageSnapshotJsonCodec();
    public static final ThrottleUsageSnapshot DEFAULT = ThrottleUsageSnapshot.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.used != ThrottleUsageSnapshot.DEFAULT.used) {
            result = 31 * result + Long.hashCode(this.used);
        }
        if (this.lastDecisionTime != null && !this.lastDecisionTime.equals(ThrottleUsageSnapshot.DEFAULT.lastDecisionTime)) {
            result = 31 * result + this.lastDecisionTime.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ThrottleUsageSnapshot thatObj = (ThrottleUsageSnapshot)that;
        if (this.used != thatObj.used) {
            return false;
        }
        if (this.lastDecisionTime == null && thatObj.lastDecisionTime != null) {
            return false;
        }
        return this.lastDecisionTime == null || this.lastDecisionTime.equals(thatObj.lastDecisionTime);
    }

    public boolean hasLastDecisionTime() {
        return this.lastDecisionTime != null;
    }

    public Timestamp lastDecisionTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasLastDecisionTime() ? this.lastDecisionTime : defaultValue;
    }

    @NonNull
    public Timestamp lastDecisionTimeOrThrow() {
        return Objects.requireNonNull(this.lastDecisionTime, "Field lastDecisionTime is null");
    }

    public void ifLastDecisionTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasLastDecisionTime()) {
            ifPresent.accept(this.lastDecisionTime);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.used, this.lastDecisionTime);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long used = 0L;
        @Nullable
        private Timestamp lastDecisionTime = null;

        public Builder() {
        }

        public Builder(long used, Timestamp lastDecisionTime) {
            this.used = used;
            this.lastDecisionTime = lastDecisionTime;
        }

        public ThrottleUsageSnapshot build() {
            return new ThrottleUsageSnapshot(this.used, this.lastDecisionTime);
        }

        public Builder used(long used) {
            this.used = used;
            return this;
        }

        public Builder lastDecisionTime(@Nullable Timestamp lastDecisionTime) {
            this.lastDecisionTime = lastDecisionTime;
            return this;
        }

        public Builder lastDecisionTime(Timestamp.Builder builder) {
            this.lastDecisionTime = builder.build();
            return this;
        }
    }
}

