/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.AccountApprovalForAllAllowance;
import com.hedera.hapi.node.state.token.AccountCryptoAllowance;
import com.hedera.hapi.node.state.token.AccountFungibleTokenAllowance;
import com.hedera.hapi.node.state.token.codec.AccountJsonCodec;
import com.hedera.hapi.node.state.token.codec.AccountProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record Account(@Nullable AccountID accountId, @NonNull Bytes alias, @Nullable Key key, long expirationSecond, long tinybarBalance, String memo, boolean deleted, long stakedToMe, long stakePeriodStart, OneOf<StakedIdOneOfType> stakedId, boolean declineReward, boolean receiverSigRequired, @Nullable TokenID headTokenId, @Nullable NftID headNftId, long headNftSerialNumber, long numberOwnedNfts, int maxAutoAssociations, int usedAutoAssociations, int numberAssociations, boolean smartContract, int numberPositiveBalances, long ethereumNonce, long stakeAtStartOfLastRewardedPeriod, @Nullable AccountID autoRenewAccountId, long autoRenewSeconds, int contractKvPairsNumber, @Nullable List<AccountCryptoAllowance> cryptoAllowances, @Nullable List<AccountApprovalForAllAllowance> approveForAllNftAllowances, @Nullable List<AccountFungibleTokenAllowance> tokenAllowances, int numberTreasuryTitles, boolean expiredAndPendingRemoval, @NonNull Bytes firstContractStorageKey) {
    public static final Codec<Account> PROTOBUF = new AccountProtoCodec();
    public static final JsonCodec<Account> JSON = new AccountJsonCodec();
    public static final Account DEFAULT = Account.newBuilder().build();

    public Account {
        if (stakedId == null) {
            throw new NullPointerException("Parameter 'stakedId' must be supplied and can not be null");
        }
    }

    @Override
    public int hashCode() {
        List<AccountFungibleTokenAllowance> list;
        List<AccountApprovalForAllAllowance> list$approveForAllNftAllowances;
        List<AccountCryptoAllowance> list$cryptoAllowances;
        int result = 1;
        if (this.accountId != null && !this.accountId.equals(Account.DEFAULT.accountId)) {
            result = 31 * result + this.accountId.hashCode();
        }
        if (this.alias != null && !this.alias.equals((Object)Account.DEFAULT.alias)) {
            result = 31 * result + this.alias.hashCode();
        }
        if (this.key != null && !this.key.equals(Account.DEFAULT.key)) {
            result = 31 * result + this.key.hashCode();
        }
        if (this.expirationSecond != Account.DEFAULT.expirationSecond) {
            result = 31 * result + Long.hashCode(this.expirationSecond);
        }
        if (this.tinybarBalance != Account.DEFAULT.tinybarBalance) {
            result = 31 * result + Long.hashCode(this.tinybarBalance);
        }
        if (this.memo != null && !this.memo.equals(Account.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.deleted != Account.DEFAULT.deleted) {
            result = 31 * result + Boolean.hashCode(this.deleted);
        }
        if (this.stakedToMe != Account.DEFAULT.stakedToMe) {
            result = 31 * result + Long.hashCode(this.stakedToMe);
        }
        if (this.stakePeriodStart != Account.DEFAULT.stakePeriodStart) {
            result = 31 * result + Long.hashCode(this.stakePeriodStart);
        }
        if (this.stakedId != null && !this.stakedId.equals(Account.DEFAULT.stakedId)) {
            result = 31 * result + this.stakedId.hashCode();
        }
        if (this.declineReward != Account.DEFAULT.declineReward) {
            result = 31 * result + Boolean.hashCode(this.declineReward);
        }
        if (this.receiverSigRequired != Account.DEFAULT.receiverSigRequired) {
            result = 31 * result + Boolean.hashCode(this.receiverSigRequired);
        }
        if (this.headTokenId != null && !this.headTokenId.equals(Account.DEFAULT.headTokenId)) {
            result = 31 * result + this.headTokenId.hashCode();
        }
        if (this.headNftId != null && !this.headNftId.equals(Account.DEFAULT.headNftId)) {
            result = 31 * result + this.headNftId.hashCode();
        }
        if (this.headNftSerialNumber != Account.DEFAULT.headNftSerialNumber) {
            result = 31 * result + Long.hashCode(this.headNftSerialNumber);
        }
        if (this.numberOwnedNfts != Account.DEFAULT.numberOwnedNfts) {
            result = 31 * result + Long.hashCode(this.numberOwnedNfts);
        }
        if (this.maxAutoAssociations != Account.DEFAULT.maxAutoAssociations) {
            result = 31 * result + Integer.hashCode(this.maxAutoAssociations);
        }
        if (this.usedAutoAssociations != Account.DEFAULT.usedAutoAssociations) {
            result = 31 * result + Integer.hashCode(this.usedAutoAssociations);
        }
        if (this.numberAssociations != Account.DEFAULT.numberAssociations) {
            result = 31 * result + Integer.hashCode(this.numberAssociations);
        }
        if (this.smartContract != Account.DEFAULT.smartContract) {
            result = 31 * result + Boolean.hashCode(this.smartContract);
        }
        if (this.numberPositiveBalances != Account.DEFAULT.numberPositiveBalances) {
            result = 31 * result + Integer.hashCode(this.numberPositiveBalances);
        }
        if (this.ethereumNonce != Account.DEFAULT.ethereumNonce) {
            result = 31 * result + Long.hashCode(this.ethereumNonce);
        }
        if (this.stakeAtStartOfLastRewardedPeriod != Account.DEFAULT.stakeAtStartOfLastRewardedPeriod) {
            result = 31 * result + Long.hashCode(this.stakeAtStartOfLastRewardedPeriod);
        }
        if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(Account.DEFAULT.autoRenewAccountId)) {
            result = 31 * result + this.autoRenewAccountId.hashCode();
        }
        if (this.autoRenewSeconds != Account.DEFAULT.autoRenewSeconds) {
            result = 31 * result + Long.hashCode(this.autoRenewSeconds);
        }
        if (this.contractKvPairsNumber != Account.DEFAULT.contractKvPairsNumber) {
            result = 31 * result + Integer.hashCode(this.contractKvPairsNumber);
        }
        if ((list$cryptoAllowances = this.cryptoAllowances) != null) {
            for (AccountCryptoAllowance accountCryptoAllowance : list$cryptoAllowances) {
                if (accountCryptoAllowance != null) {
                    result = 31 * result + ((Object)accountCryptoAllowance).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if ((list$approveForAllNftAllowances = this.approveForAllNftAllowances) != null) {
            for (AccountApprovalForAllAllowance accountApprovalForAllAllowance : list$approveForAllNftAllowances) {
                if (accountApprovalForAllAllowance != null) {
                    result = 31 * result + ((Object)accountApprovalForAllAllowance).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if ((list = this.tokenAllowances) != null) {
            for (AccountFungibleTokenAllowance o : list) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.numberTreasuryTitles != Account.DEFAULT.numberTreasuryTitles) {
            result = 31 * result + Integer.hashCode(this.numberTreasuryTitles);
        }
        if (this.expiredAndPendingRemoval != Account.DEFAULT.expiredAndPendingRemoval) {
            result = 31 * result + Boolean.hashCode(this.expiredAndPendingRemoval);
        }
        if (this.firstContractStorageKey != null && !this.firstContractStorageKey.equals((Object)Account.DEFAULT.firstContractStorageKey)) {
            result = 31 * result + this.firstContractStorageKey.hashCode();
        }
        long l = result;
        l += l << 30;
        l ^= l >>> 27;
        l += l << 16;
        l ^= l >>> 20;
        l += l << 5;
        l ^= l >>> 18;
        l += l << 10;
        l ^= l >>> 24;
        l += l << 30;
        return (int)l;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Account thatObj = (Account)that;
        if (this.accountId == null && thatObj.accountId != null) {
            return false;
        }
        if (this.accountId != null && !this.accountId.equals(thatObj.accountId)) {
            return false;
        }
        if (this.alias == null && thatObj.alias != null) {
            return false;
        }
        if (this.alias != null && !this.alias.equals((Object)thatObj.alias)) {
            return false;
        }
        if (this.key == null && thatObj.key != null) {
            return false;
        }
        if (this.key != null && !this.key.equals(thatObj.key)) {
            return false;
        }
        if (this.expirationSecond != thatObj.expirationSecond) {
            return false;
        }
        if (this.tinybarBalance != thatObj.tinybarBalance) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.stakedToMe != thatObj.stakedToMe) {
            return false;
        }
        if (this.stakePeriodStart != thatObj.stakePeriodStart) {
            return false;
        }
        if (this.stakedId == null && thatObj.stakedId != null) {
            return false;
        }
        if (this.stakedId != null && !this.stakedId.equals(thatObj.stakedId)) {
            return false;
        }
        if (this.declineReward != thatObj.declineReward) {
            return false;
        }
        if (this.receiverSigRequired != thatObj.receiverSigRequired) {
            return false;
        }
        if (this.headTokenId == null && thatObj.headTokenId != null) {
            return false;
        }
        if (this.headTokenId != null && !this.headTokenId.equals(thatObj.headTokenId)) {
            return false;
        }
        if (this.headNftId == null && thatObj.headNftId != null) {
            return false;
        }
        if (this.headNftId != null && !this.headNftId.equals(thatObj.headNftId)) {
            return false;
        }
        if (this.headNftSerialNumber != thatObj.headNftSerialNumber) {
            return false;
        }
        if (this.numberOwnedNfts != thatObj.numberOwnedNfts) {
            return false;
        }
        if (this.maxAutoAssociations != thatObj.maxAutoAssociations) {
            return false;
        }
        if (this.usedAutoAssociations != thatObj.usedAutoAssociations) {
            return false;
        }
        if (this.numberAssociations != thatObj.numberAssociations) {
            return false;
        }
        if (this.smartContract != thatObj.smartContract) {
            return false;
        }
        if (this.numberPositiveBalances != thatObj.numberPositiveBalances) {
            return false;
        }
        if (this.ethereumNonce != thatObj.ethereumNonce) {
            return false;
        }
        if (this.stakeAtStartOfLastRewardedPeriod != thatObj.stakeAtStartOfLastRewardedPeriod) {
            return false;
        }
        if (this.autoRenewAccountId == null && thatObj.autoRenewAccountId != null) {
            return false;
        }
        if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(thatObj.autoRenewAccountId)) {
            return false;
        }
        if (this.autoRenewSeconds != thatObj.autoRenewSeconds) {
            return false;
        }
        if (this.contractKvPairsNumber != thatObj.contractKvPairsNumber) {
            return false;
        }
        if (this.cryptoAllowances == null && thatObj.cryptoAllowances != null) {
            return false;
        }
        if (this.cryptoAllowances != null && !this.cryptoAllowances.equals(thatObj.cryptoAllowances)) {
            return false;
        }
        if (this.approveForAllNftAllowances == null && thatObj.approveForAllNftAllowances != null) {
            return false;
        }
        if (this.approveForAllNftAllowances != null && !this.approveForAllNftAllowances.equals(thatObj.approveForAllNftAllowances)) {
            return false;
        }
        if (this.tokenAllowances == null && thatObj.tokenAllowances != null) {
            return false;
        }
        if (this.tokenAllowances != null && !this.tokenAllowances.equals(thatObj.tokenAllowances)) {
            return false;
        }
        if (this.numberTreasuryTitles != thatObj.numberTreasuryTitles) {
            return false;
        }
        if (this.expiredAndPendingRemoval != thatObj.expiredAndPendingRemoval) {
            return false;
        }
        if (this.firstContractStorageKey == null && thatObj.firstContractStorageKey != null) {
            return false;
        }
        return this.firstContractStorageKey == null || this.firstContractStorageKey.equals((Object)thatObj.firstContractStorageKey);
    }

    public boolean hasAccountId() {
        return this.accountId != null;
    }

    public AccountID accountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountId() ? this.accountId : defaultValue;
    }

    @NonNull
    public AccountID accountIdOrThrow() {
        return Objects.requireNonNull(this.accountId, "Field accountId is null");
    }

    public void ifAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountId()) {
            ifPresent.accept(this.accountId);
        }
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public Key keyOrElse(@NonNull Key defaultValue) {
        return this.hasKey() ? this.key : defaultValue;
    }

    @NonNull
    public Key keyOrThrow() {
        return Objects.requireNonNull(this.key, "Field key is null");
    }

    public void ifKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasKey()) {
            ifPresent.accept(this.key);
        }
    }

    public boolean hasHeadTokenId() {
        return this.headTokenId != null;
    }

    public TokenID headTokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasHeadTokenId() ? this.headTokenId : defaultValue;
    }

    @NonNull
    public TokenID headTokenIdOrThrow() {
        return Objects.requireNonNull(this.headTokenId, "Field headTokenId is null");
    }

    public void ifHeadTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasHeadTokenId()) {
            ifPresent.accept(this.headTokenId);
        }
    }

    public boolean hasHeadNftId() {
        return this.headNftId != null;
    }

    public NftID headNftIdOrElse(@NonNull NftID defaultValue) {
        return this.hasHeadNftId() ? this.headNftId : defaultValue;
    }

    @NonNull
    public NftID headNftIdOrThrow() {
        return Objects.requireNonNull(this.headNftId, "Field headNftId is null");
    }

    public void ifHeadNftId(@NonNull Consumer<NftID> ifPresent) {
        if (this.hasHeadNftId()) {
            ifPresent.accept(this.headNftId);
        }
    }

    public boolean hasAutoRenewAccountId() {
        return this.autoRenewAccountId != null;
    }

    public AccountID autoRenewAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccountId() ? this.autoRenewAccountId : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountIdOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccountId, "Field autoRenewAccountId is null");
    }

    public void ifAutoRenewAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccountId()) {
            ifPresent.accept(this.autoRenewAccountId);
        }
    }

    public boolean hasCryptoAllowances() {
        return this.cryptoAllowances != null;
    }

    public List<AccountCryptoAllowance> cryptoAllowancesOrElse(@NonNull List<AccountCryptoAllowance> defaultValue) {
        return this.hasCryptoAllowances() ? this.cryptoAllowances : defaultValue;
    }

    @NonNull
    public List<AccountCryptoAllowance> cryptoAllowancesOrThrow() {
        return Objects.requireNonNull(this.cryptoAllowances, "Field cryptoAllowances is null");
    }

    public void ifCryptoAllowances(@NonNull Consumer<List<AccountCryptoAllowance>> ifPresent) {
        if (this.hasCryptoAllowances()) {
            ifPresent.accept(this.cryptoAllowances);
        }
    }

    public boolean hasApproveForAllNftAllowances() {
        return this.approveForAllNftAllowances != null;
    }

    public List<AccountApprovalForAllAllowance> approveForAllNftAllowancesOrElse(@NonNull List<AccountApprovalForAllAllowance> defaultValue) {
        return this.hasApproveForAllNftAllowances() ? this.approveForAllNftAllowances : defaultValue;
    }

    @NonNull
    public List<AccountApprovalForAllAllowance> approveForAllNftAllowancesOrThrow() {
        return Objects.requireNonNull(this.approveForAllNftAllowances, "Field approveForAllNftAllowances is null");
    }

    public void ifApproveForAllNftAllowances(@NonNull Consumer<List<AccountApprovalForAllAllowance>> ifPresent) {
        if (this.hasApproveForAllNftAllowances()) {
            ifPresent.accept(this.approveForAllNftAllowances);
        }
    }

    public boolean hasTokenAllowances() {
        return this.tokenAllowances != null;
    }

    public List<AccountFungibleTokenAllowance> tokenAllowancesOrElse(@NonNull List<AccountFungibleTokenAllowance> defaultValue) {
        return this.hasTokenAllowances() ? this.tokenAllowances : defaultValue;
    }

    @NonNull
    public List<AccountFungibleTokenAllowance> tokenAllowancesOrThrow() {
        return Objects.requireNonNull(this.tokenAllowances, "Field tokenAllowances is null");
    }

    public void ifTokenAllowances(@NonNull Consumer<List<AccountFungibleTokenAllowance>> ifPresent) {
        if (this.hasTokenAllowances()) {
            ifPresent.accept(this.tokenAllowances);
        }
    }

    @Nullable
    public AccountID stakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID ? (AccountID)this.stakedId.value() : null;
    }

    public boolean hasStakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID;
    }

    public AccountID stakedAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasStakedAccountId() ? this.stakedAccountId() : defaultValue;
    }

    @NonNull
    public AccountID stakedAccountIdOrThrow() {
        return Objects.requireNonNull(this.stakedAccountId(), "Field stakedAccountId is null");
    }

    @Nullable
    public Long stakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID ? (Long)this.stakedId.value() : null;
    }

    public boolean hasStakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID;
    }

    public Long stakedNodeIdOrElse(@NonNull Long defaultValue) {
        return this.hasStakedNodeId() ? this.stakedNodeId() : defaultValue;
    }

    @NonNull
    public Long stakedNodeIdOrThrow() {
        return Objects.requireNonNull(this.stakedNodeId(), "Field stakedNodeId is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.accountId, this.alias, this.key, this.expirationSecond, this.tinybarBalance, this.memo, this.deleted, this.stakedToMe, this.stakePeriodStart, this.stakedId, this.declineReward, this.receiverSigRequired, this.headTokenId, this.headNftId, this.headNftSerialNumber, this.numberOwnedNfts, this.maxAutoAssociations, this.usedAutoAssociations, this.numberAssociations, this.smartContract, this.numberPositiveBalances, this.ethereumNonce, this.stakeAtStartOfLastRewardedPeriod, this.autoRenewAccountId, this.autoRenewSeconds, this.contractKvPairsNumber, this.cryptoAllowances, this.approveForAllNftAllowances, this.tokenAllowances, this.numberTreasuryTitles, this.expiredAndPendingRemoval, this.firstContractStorageKey);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum StakedIdOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        STAKED_ACCOUNT_ID(10, "staked_account_id"),
        STAKED_NODE_ID(11, "staked_node_id");

        private final int protoOrdinal;
        private final String protoName;

        private StakedIdOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static StakedIdOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 10 -> STAKED_ACCOUNT_ID;
                case 11 -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static StakedIdOneOfType fromString(String name) {
            return switch (name) {
                case "staked_account_id", "STAKED_ACCOUNT_ID" -> STAKED_ACCOUNT_ID;
                case "staked_node_id", "STAKED_NODE_ID" -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        @Nullable
        private AccountID accountId = null;
        @NonNull
        private Bytes alias = Bytes.EMPTY;
        @Nullable
        private Key key = null;
        private long expirationSecond = 0L;
        private long tinybarBalance = 0L;
        private String memo = "";
        private boolean deleted = false;
        private long stakedToMe = 0L;
        private long stakePeriodStart = 0L;
        private OneOf<StakedIdOneOfType> stakedId = AccountProtoCodec.STAKED_ID_UNSET;
        private boolean declineReward = false;
        private boolean receiverSigRequired = false;
        @Nullable
        private TokenID headTokenId = null;
        @Nullable
        private NftID headNftId = null;
        private long headNftSerialNumber = 0L;
        private long numberOwnedNfts = 0L;
        private int maxAutoAssociations = 0;
        private int usedAutoAssociations = 0;
        private int numberAssociations = 0;
        private boolean smartContract = false;
        private int numberPositiveBalances = 0;
        private long ethereumNonce = 0L;
        private long stakeAtStartOfLastRewardedPeriod = 0L;
        @Nullable
        private AccountID autoRenewAccountId = null;
        private long autoRenewSeconds = 0L;
        private int contractKvPairsNumber = 0;
        @Nullable
        private List<AccountCryptoAllowance> cryptoAllowances = Collections.emptyList();
        @Nullable
        private List<AccountApprovalForAllAllowance> approveForAllNftAllowances = Collections.emptyList();
        @Nullable
        private List<AccountFungibleTokenAllowance> tokenAllowances = Collections.emptyList();
        private int numberTreasuryTitles = 0;
        private boolean expiredAndPendingRemoval = false;
        @NonNull
        private Bytes firstContractStorageKey = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(AccountID accountId, Bytes alias, Key key, long expirationSecond, long tinybarBalance, String memo, boolean deleted, long stakedToMe, long stakePeriodStart, OneOf<StakedIdOneOfType> stakedId, boolean declineReward, boolean receiverSigRequired, TokenID headTokenId, NftID headNftId, long headNftSerialNumber, long numberOwnedNfts, int maxAutoAssociations, int usedAutoAssociations, int numberAssociations, boolean smartContract, int numberPositiveBalances, long ethereumNonce, long stakeAtStartOfLastRewardedPeriod, AccountID autoRenewAccountId, long autoRenewSeconds, int contractKvPairsNumber, List<AccountCryptoAllowance> cryptoAllowances, List<AccountApprovalForAllAllowance> approveForAllNftAllowances, List<AccountFungibleTokenAllowance> tokenAllowances, int numberTreasuryTitles, boolean expiredAndPendingRemoval, Bytes firstContractStorageKey) {
            this.accountId = accountId;
            this.alias = alias;
            this.key = key;
            this.expirationSecond = expirationSecond;
            this.tinybarBalance = tinybarBalance;
            this.memo = memo;
            this.deleted = deleted;
            this.stakedToMe = stakedToMe;
            this.stakePeriodStart = stakePeriodStart;
            this.stakedId = stakedId;
            this.declineReward = declineReward;
            this.receiverSigRequired = receiverSigRequired;
            this.headTokenId = headTokenId;
            this.headNftId = headNftId;
            this.headNftSerialNumber = headNftSerialNumber;
            this.numberOwnedNfts = numberOwnedNfts;
            this.maxAutoAssociations = maxAutoAssociations;
            this.usedAutoAssociations = usedAutoAssociations;
            this.numberAssociations = numberAssociations;
            this.smartContract = smartContract;
            this.numberPositiveBalances = numberPositiveBalances;
            this.ethereumNonce = ethereumNonce;
            this.stakeAtStartOfLastRewardedPeriod = stakeAtStartOfLastRewardedPeriod;
            this.autoRenewAccountId = autoRenewAccountId;
            this.autoRenewSeconds = autoRenewSeconds;
            this.contractKvPairsNumber = contractKvPairsNumber;
            this.cryptoAllowances = cryptoAllowances;
            this.approveForAllNftAllowances = approveForAllNftAllowances;
            this.tokenAllowances = tokenAllowances;
            this.numberTreasuryTitles = numberTreasuryTitles;
            this.expiredAndPendingRemoval = expiredAndPendingRemoval;
            this.firstContractStorageKey = firstContractStorageKey;
        }

        public Account build() {
            return new Account(this.accountId, this.alias, this.key, this.expirationSecond, this.tinybarBalance, this.memo, this.deleted, this.stakedToMe, this.stakePeriodStart, this.stakedId, this.declineReward, this.receiverSigRequired, this.headTokenId, this.headNftId, this.headNftSerialNumber, this.numberOwnedNfts, this.maxAutoAssociations, this.usedAutoAssociations, this.numberAssociations, this.smartContract, this.numberPositiveBalances, this.ethereumNonce, this.stakeAtStartOfLastRewardedPeriod, this.autoRenewAccountId, this.autoRenewSeconds, this.contractKvPairsNumber, this.cryptoAllowances, this.approveForAllNftAllowances, this.tokenAllowances, this.numberTreasuryTitles, this.expiredAndPendingRemoval, this.firstContractStorageKey);
        }

        public Builder accountId(@Nullable AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountId(AccountID.Builder builder) {
            this.accountId = builder.build();
            return this;
        }

        public Builder alias(@NonNull Bytes alias) {
            this.alias = alias != null ? alias : Bytes.EMPTY;
            return this;
        }

        public Builder key(@Nullable Key key) {
            this.key = key;
            return this;
        }

        public Builder key(Key.Builder builder) {
            this.key = builder.build();
            return this;
        }

        public Builder expirationSecond(long expirationSecond) {
            this.expirationSecond = expirationSecond;
            return this;
        }

        public Builder tinybarBalance(long tinybarBalance) {
            this.tinybarBalance = tinybarBalance;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder stakedToMe(long stakedToMe) {
            this.stakedToMe = stakedToMe;
            return this;
        }

        public Builder stakePeriodStart(long stakePeriodStart) {
            this.stakePeriodStart = stakePeriodStart;
            return this;
        }

        public Builder stakedAccountId(@Nullable AccountID stakedAccountId) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)stakedAccountId);
            return this;
        }

        public Builder stakedAccountId(AccountID.Builder builder) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)builder.build());
            return this;
        }

        public Builder stakedNodeId(long stakedNodeId) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_NODE_ID, (Object)stakedNodeId);
            return this;
        }

        public Builder declineReward(boolean declineReward) {
            this.declineReward = declineReward;
            return this;
        }

        public Builder receiverSigRequired(boolean receiverSigRequired) {
            this.receiverSigRequired = receiverSigRequired;
            return this;
        }

        public Builder headTokenId(@Nullable TokenID headTokenId) {
            this.headTokenId = headTokenId;
            return this;
        }

        public Builder headTokenId(TokenID.Builder builder) {
            this.headTokenId = builder.build();
            return this;
        }

        public Builder headNftId(@Nullable NftID headNftId) {
            this.headNftId = headNftId;
            return this;
        }

        public Builder headNftId(NftID.Builder builder) {
            this.headNftId = builder.build();
            return this;
        }

        public Builder headNftSerialNumber(long headNftSerialNumber) {
            this.headNftSerialNumber = headNftSerialNumber;
            return this;
        }

        public Builder numberOwnedNfts(long numberOwnedNfts) {
            this.numberOwnedNfts = numberOwnedNfts;
            return this;
        }

        public Builder maxAutoAssociations(int maxAutoAssociations) {
            this.maxAutoAssociations = maxAutoAssociations;
            return this;
        }

        public Builder usedAutoAssociations(int usedAutoAssociations) {
            this.usedAutoAssociations = usedAutoAssociations;
            return this;
        }

        public Builder numberAssociations(int numberAssociations) {
            this.numberAssociations = numberAssociations;
            return this;
        }

        public Builder smartContract(boolean smartContract) {
            this.smartContract = smartContract;
            return this;
        }

        public Builder numberPositiveBalances(int numberPositiveBalances) {
            this.numberPositiveBalances = numberPositiveBalances;
            return this;
        }

        public Builder ethereumNonce(long ethereumNonce) {
            this.ethereumNonce = ethereumNonce;
            return this;
        }

        public Builder stakeAtStartOfLastRewardedPeriod(long stakeAtStartOfLastRewardedPeriod) {
            this.stakeAtStartOfLastRewardedPeriod = stakeAtStartOfLastRewardedPeriod;
            return this;
        }

        public Builder autoRenewAccountId(@Nullable AccountID autoRenewAccountId) {
            this.autoRenewAccountId = autoRenewAccountId;
            return this;
        }

        public Builder autoRenewAccountId(AccountID.Builder builder) {
            this.autoRenewAccountId = builder.build();
            return this;
        }

        public Builder autoRenewSeconds(long autoRenewSeconds) {
            this.autoRenewSeconds = autoRenewSeconds;
            return this;
        }

        public Builder contractKvPairsNumber(int contractKvPairsNumber) {
            this.contractKvPairsNumber = contractKvPairsNumber;
            return this;
        }

        public Builder cryptoAllowances(@Nullable List<AccountCryptoAllowance> cryptoAllowances) {
            this.cryptoAllowances = cryptoAllowances;
            return this;
        }

        public Builder cryptoAllowances(AccountCryptoAllowance ... values) {
            this.cryptoAllowances = List.of(values);
            return this;
        }

        public Builder approveForAllNftAllowances(@Nullable List<AccountApprovalForAllAllowance> approveForAllNftAllowances) {
            this.approveForAllNftAllowances = approveForAllNftAllowances;
            return this;
        }

        public Builder approveForAllNftAllowances(AccountApprovalForAllAllowance ... values) {
            this.approveForAllNftAllowances = List.of(values);
            return this;
        }

        public Builder tokenAllowances(@Nullable List<AccountFungibleTokenAllowance> tokenAllowances) {
            this.tokenAllowances = tokenAllowances;
            return this;
        }

        public Builder tokenAllowances(AccountFungibleTokenAllowance ... values) {
            this.tokenAllowances = List.of(values);
            return this;
        }

        public Builder numberTreasuryTitles(int numberTreasuryTitles) {
            this.numberTreasuryTitles = numberTreasuryTitles;
            return this;
        }

        public Builder expiredAndPendingRemoval(boolean expiredAndPendingRemoval) {
            this.expiredAndPendingRemoval = expiredAndPendingRemoval;
            return this;
        }

        public Builder firstContractStorageKey(@NonNull Bytes firstContractStorageKey) {
            this.firstContractStorageKey = firstContractStorageKey != null ? firstContractStorageKey : Bytes.EMPTY;
            return this;
        }
    }
}

