/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.token.codec.AccountCryptoAllowanceJsonCodec;
import com.hedera.hapi.node.state.token.codec.AccountCryptoAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record AccountCryptoAllowance(@Nullable AccountID spenderId, long amount) {
    public static final Codec<AccountCryptoAllowance> PROTOBUF = new AccountCryptoAllowanceProtoCodec();
    public static final JsonCodec<AccountCryptoAllowance> JSON = new AccountCryptoAllowanceJsonCodec();
    public static final AccountCryptoAllowance DEFAULT = AccountCryptoAllowance.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.spenderId != null && !this.spenderId.equals(AccountCryptoAllowance.DEFAULT.spenderId)) {
            result = 31 * result + this.spenderId.hashCode();
        }
        if (this.amount != AccountCryptoAllowance.DEFAULT.amount) {
            result = 31 * result + Long.hashCode(this.amount);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AccountCryptoAllowance thatObj = (AccountCryptoAllowance)that;
        if (this.spenderId == null && thatObj.spenderId != null) {
            return false;
        }
        if (this.spenderId != null && !this.spenderId.equals(thatObj.spenderId)) {
            return false;
        }
        return this.amount == thatObj.amount;
    }

    public boolean hasSpenderId() {
        return this.spenderId != null;
    }

    public AccountID spenderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpenderId() ? this.spenderId : defaultValue;
    }

    @NonNull
    public AccountID spenderIdOrThrow() {
        return Objects.requireNonNull(this.spenderId, "Field spenderId is null");
    }

    public void ifSpenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpenderId()) {
            ifPresent.accept(this.spenderId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.spenderId, this.amount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private AccountID spenderId = null;
        private long amount = 0L;

        public Builder() {
        }

        public Builder(AccountID spenderId, long amount) {
            this.spenderId = spenderId;
            this.amount = amount;
        }

        public AccountCryptoAllowance build() {
            return new AccountCryptoAllowance(this.spenderId, this.amount);
        }

        public Builder spenderId(@Nullable AccountID spenderId) {
            this.spenderId = spenderId;
            return this;
        }

        public Builder spenderId(AccountID.Builder builder) {
            this.spenderId = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }
    }
}

