/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token.codec;

import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.hapi.node.state.token.schema.StakingNodeInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.List;

public final class StakingNodeInfoProtoCodec
implements Codec<StakingNodeInfo> {
    @NonNull
    public StakingNodeInfo parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public StakingNodeInfo parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull StakingNodeInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.NODE_NUMBER, (long)data.nodeNumber());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.MIN_STAKE, (long)data.minStake());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.MAX_STAKE, (long)data.maxStake());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.STAKE_TO_REWARD, (long)data.stakeToReward());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.STAKE_TO_NOT_REWARD, (long)data.stakeToNotReward());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.STAKE_REWARD_START, (long)data.stakeRewardStart());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.UNCLAIMED_STAKE_REWARD_START, (long)data.unclaimedStakeRewardStart());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.STAKE, (long)data.stake());
        ProtoWriterTools.writeLongList((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.REWARD_SUM_HISTORY, data.rewardSumHistory());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.WEIGHT, (int)data.weight());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.PENDING_REWARDS, (long)data.pendingRewards());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)StakingNodeInfoSchema.DELETED, (boolean)data.deleted());
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(StakingNodeInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingNodeInfoSchema.NODE_NUMBER, (long)data.nodeNumber());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingNodeInfoSchema.MIN_STAKE, (long)data.minStake());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingNodeInfoSchema.MAX_STAKE, (long)data.maxStake());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingNodeInfoSchema.STAKE_TO_REWARD, (long)data.stakeToReward());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingNodeInfoSchema.STAKE_TO_NOT_REWARD, (long)data.stakeToNotReward());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingNodeInfoSchema.STAKE_REWARD_START, (long)data.stakeRewardStart());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingNodeInfoSchema.UNCLAIMED_STAKE_REWARD_START, (long)data.unclaimedStakeRewardStart());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingNodeInfoSchema.STAKE, (long)data.stake());
        size += ProtoWriterTools.sizeOfLongList((FieldDefinition)StakingNodeInfoSchema.REWARD_SUM_HISTORY, data.rewardSumHistory());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)StakingNodeInfoSchema.WEIGHT, (int)data.weight());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)StakingNodeInfoSchema.PENDING_REWARDS, (long)data.pendingRewards());
        return size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)StakingNodeInfoSchema.DELETED, (boolean)data.deleted());
    }

    public boolean fastEquals(@NonNull StakingNodeInfo item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    @NonNull
    private StakingNodeInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            long temp_node_number = 0L;
            long temp_min_stake = 0L;
            long temp_max_stake = 0L;
            long temp_stake_to_reward = 0L;
            long temp_stake_to_not_reward = 0L;
            long temp_stake_reward_start = 0L;
            long temp_unclaimed_stake_reward_start = 0L;
            long temp_stake = 0L;
            List temp_reward_sum_history = Collections.emptyList();
            int temp_weight = 0;
            long temp_pending_rewards = 0L;
            boolean temp_deleted = false;
            block19: while (input.hasRemaining()) {
                int tag;
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                int field = tag >>> 3;
                FieldDefinition f = StakingNodeInfoSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_node_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        break;
                    }
                    case 16: {
                        long value;
                        temp_min_stake = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        break;
                    }
                    case 24: {
                        long value;
                        temp_max_stake = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        break;
                    }
                    case 32: {
                        long value;
                        temp_stake_to_reward = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        break;
                    }
                    case 40: {
                        long value;
                        temp_stake_to_not_reward = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        break;
                    }
                    case 48: {
                        long value;
                        temp_stake_reward_start = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        break;
                    }
                    case 56: {
                        long value;
                        temp_unclaimed_stake_reward_start = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        break;
                    }
                    case 64: {
                        long value;
                        temp_stake = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        break;
                    }
                    case 72: {
                        long value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        temp_reward_sum_history = ProtoParserTools.addToList(temp_reward_sum_history, (Object)value);
                        break;
                    }
                    case 74: {
                        long length = input.readVarInt(false);
                        if (input.remaining() < length) {
                            throw new BufferUnderflowException();
                        }
                        long beforeLimit = input.limit();
                        long beforePosition = input.position();
                        input.limit(input.position() + length);
                        while (input.hasRemaining()) {
                            temp_reward_sum_history = ProtoParserTools.addToList((List)temp_reward_sum_history, (Object)ProtoParserTools.readInt64((ReadableSequentialData)input));
                        }
                        input.limit(beforeLimit);
                        if (input.position() == beforePosition + length) continue block19;
                        throw new BufferUnderflowException();
                    }
                    case 80: {
                        int value;
                        temp_weight = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        break;
                    }
                    case 88: {
                        long value;
                        temp_pending_rewards = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        break;
                    }
                    case 96: {
                        boolean value;
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        break;
                    }
                    default: {
                        int wireType = tag & 7;
                        if (field == 0) {
                            throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                        }
                        if (wireType > 5) {
                            throw new IOException("Cannot understand wire_type of " + wireType);
                        }
                        if (f == null) {
                            if (strictMode) {
                                throw new UnknownFieldException(field);
                            }
                            ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                            break;
                        }
                        throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                    }
                }
            }
            return new StakingNodeInfo(temp_node_number, temp_min_stake, temp_max_stake, temp_stake_to_reward, temp_stake_to_not_reward, temp_stake_reward_start, temp_unclaimed_stake_reward_start, temp_stake, temp_reward_sum_history, temp_weight, temp_pending_rewards, temp_deleted);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

