/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.token.codec.CryptoDeleteLiveHashTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.CryptoDeleteLiveHashTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record CryptoDeleteLiveHashTransactionBody(@Nullable AccountID accountOfLiveHash, @NonNull Bytes liveHashToDelete) {
    public static final Codec<CryptoDeleteLiveHashTransactionBody> PROTOBUF = new CryptoDeleteLiveHashTransactionBodyProtoCodec();
    public static final JsonCodec<CryptoDeleteLiveHashTransactionBody> JSON = new CryptoDeleteLiveHashTransactionBodyJsonCodec();
    public static final CryptoDeleteLiveHashTransactionBody DEFAULT = CryptoDeleteLiveHashTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.accountOfLiveHash != null && !this.accountOfLiveHash.equals(CryptoDeleteLiveHashTransactionBody.DEFAULT.accountOfLiveHash)) {
            result = 31 * result + this.accountOfLiveHash.hashCode();
        }
        if (this.liveHashToDelete != null && !this.liveHashToDelete.equals((Object)CryptoDeleteLiveHashTransactionBody.DEFAULT.liveHashToDelete)) {
            result = 31 * result + this.liveHashToDelete.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        CryptoDeleteLiveHashTransactionBody thatObj = (CryptoDeleteLiveHashTransactionBody)that;
        if (this.accountOfLiveHash == null && thatObj.accountOfLiveHash != null) {
            return false;
        }
        if (this.accountOfLiveHash != null && !this.accountOfLiveHash.equals(thatObj.accountOfLiveHash)) {
            return false;
        }
        if (this.liveHashToDelete == null && thatObj.liveHashToDelete != null) {
            return false;
        }
        return this.liveHashToDelete == null || this.liveHashToDelete.equals((Object)thatObj.liveHashToDelete);
    }

    public boolean hasAccountOfLiveHash() {
        return this.accountOfLiveHash != null;
    }

    public AccountID accountOfLiveHashOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountOfLiveHash() ? this.accountOfLiveHash : defaultValue;
    }

    @NonNull
    public AccountID accountOfLiveHashOrThrow() {
        return Objects.requireNonNull(this.accountOfLiveHash, "Field accountOfLiveHash is null");
    }

    public void ifAccountOfLiveHash(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountOfLiveHash()) {
            ifPresent.accept(this.accountOfLiveHash);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountOfLiveHash, this.liveHashToDelete);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private AccountID accountOfLiveHash = null;
        @NonNull
        private Bytes liveHashToDelete = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(AccountID accountOfLiveHash, Bytes liveHashToDelete) {
            this.accountOfLiveHash = accountOfLiveHash;
            this.liveHashToDelete = liveHashToDelete;
        }

        public CryptoDeleteLiveHashTransactionBody build() {
            return new CryptoDeleteLiveHashTransactionBody(this.accountOfLiveHash, this.liveHashToDelete);
        }

        public Builder accountOfLiveHash(@Nullable AccountID accountOfLiveHash) {
            this.accountOfLiveHash = accountOfLiveHash;
            return this;
        }

        public Builder accountOfLiveHash(AccountID.Builder builder) {
            this.accountOfLiveHash = builder.build();
            return this;
        }

        public Builder liveHashToDelete(@NonNull Bytes liveHashToDelete) {
            this.liveHashToDelete = liveHashToDelete != null ? liveHashToDelete : Bytes.EMPTY;
            return this;
        }
    }
}

