/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.token.codec.CryptoTransferTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.CryptoTransferTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record CryptoTransferTransactionBody(@Nullable TransferList transfers, @Nullable List<TokenTransferList> tokenTransfers) {
    public static final Codec<CryptoTransferTransactionBody> PROTOBUF = new CryptoTransferTransactionBodyProtoCodec();
    public static final JsonCodec<CryptoTransferTransactionBody> JSON = new CryptoTransferTransactionBodyJsonCodec();
    public static final CryptoTransferTransactionBody DEFAULT = CryptoTransferTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        List<TokenTransferList> list$tokenTransfers;
        int result = 1;
        if (this.transfers != null && !this.transfers.equals(CryptoTransferTransactionBody.DEFAULT.transfers)) {
            result = 31 * result + this.transfers.hashCode();
        }
        if ((list$tokenTransfers = this.tokenTransfers) != null) {
            for (TokenTransferList o : list$tokenTransfers) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        CryptoTransferTransactionBody thatObj = (CryptoTransferTransactionBody)that;
        if (this.transfers == null && thatObj.transfers != null) {
            return false;
        }
        if (this.transfers != null && !this.transfers.equals(thatObj.transfers)) {
            return false;
        }
        if (this.tokenTransfers == null && thatObj.tokenTransfers != null) {
            return false;
        }
        return this.tokenTransfers == null || this.tokenTransfers.equals(thatObj.tokenTransfers);
    }

    public boolean hasTransfers() {
        return this.transfers != null;
    }

    public TransferList transfersOrElse(@NonNull TransferList defaultValue) {
        return this.hasTransfers() ? this.transfers : defaultValue;
    }

    @NonNull
    public TransferList transfersOrThrow() {
        return Objects.requireNonNull(this.transfers, "Field transfers is null");
    }

    public void ifTransfers(@NonNull Consumer<TransferList> ifPresent) {
        if (this.hasTransfers()) {
            ifPresent.accept(this.transfers);
        }
    }

    public boolean hasTokenTransfers() {
        return this.tokenTransfers != null;
    }

    public List<TokenTransferList> tokenTransfersOrElse(@NonNull List<TokenTransferList> defaultValue) {
        return this.hasTokenTransfers() ? this.tokenTransfers : defaultValue;
    }

    @NonNull
    public List<TokenTransferList> tokenTransfersOrThrow() {
        return Objects.requireNonNull(this.tokenTransfers, "Field tokenTransfers is null");
    }

    public void ifTokenTransfers(@NonNull Consumer<List<TokenTransferList>> ifPresent) {
        if (this.hasTokenTransfers()) {
            ifPresent.accept(this.tokenTransfers);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.transfers, this.tokenTransfers);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TransferList transfers = null;
        @Nullable
        private List<TokenTransferList> tokenTransfers = Collections.emptyList();

        public Builder() {
        }

        public Builder(TransferList transfers, List<TokenTransferList> tokenTransfers) {
            this.transfers = transfers;
            this.tokenTransfers = tokenTransfers;
        }

        public CryptoTransferTransactionBody build() {
            return new CryptoTransferTransactionBody(this.transfers, this.tokenTransfers);
        }

        public Builder transfers(@Nullable TransferList transfers) {
            this.transfers = transfers;
            return this;
        }

        public Builder transfers(TransferList.Builder builder) {
            this.transfers = builder.build();
            return this;
        }

        public Builder tokenTransfers(@Nullable List<TokenTransferList> tokenTransfers) {
            this.tokenTransfers = tokenTransfers;
            return this;
        }

        public Builder tokenTransfers(TokenTransferList ... values) {
            this.tokenTransfers = List.of(values);
            return this;
        }
    }
}

