/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.GrantedTokenAllowanceJsonCodec;
import com.hedera.hapi.node.token.codec.GrantedTokenAllowanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record GrantedTokenAllowance(@Nullable TokenID tokenId, @Nullable AccountID spender, long amount) {
    public static final Codec<GrantedTokenAllowance> PROTOBUF = new GrantedTokenAllowanceProtoCodec();
    public static final JsonCodec<GrantedTokenAllowance> JSON = new GrantedTokenAllowanceJsonCodec();
    public static final GrantedTokenAllowance DEFAULT = GrantedTokenAllowance.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.tokenId != null && !this.tokenId.equals(GrantedTokenAllowance.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        if (this.spender != null && !this.spender.equals(GrantedTokenAllowance.DEFAULT.spender)) {
            result = 31 * result + this.spender.hashCode();
        }
        if (this.amount != GrantedTokenAllowance.DEFAULT.amount) {
            result = 31 * result + Long.hashCode(this.amount);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        GrantedTokenAllowance thatObj = (GrantedTokenAllowance)that;
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        if (this.spender == null && thatObj.spender != null) {
            return false;
        }
        if (this.spender != null && !this.spender.equals(thatObj.spender)) {
            return false;
        }
        return this.amount == thatObj.amount;
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasSpender() {
        return this.spender != null;
    }

    public AccountID spenderOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpender() ? this.spender : defaultValue;
    }

    @NonNull
    public AccountID spenderOrThrow() {
        return Objects.requireNonNull(this.spender, "Field spender is null");
    }

    public void ifSpender(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpender()) {
            ifPresent.accept(this.spender);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.spender, this.amount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TokenID tokenId = null;
        @Nullable
        private AccountID spender = null;
        private long amount = 0L;

        public Builder() {
        }

        public Builder(TokenID tokenId, AccountID spender, long amount) {
            this.tokenId = tokenId;
            this.spender = spender;
            this.amount = amount;
        }

        public GrantedTokenAllowance build() {
            return new GrantedTokenAllowance(this.tokenId, this.spender, this.amount);
        }

        public Builder tokenId(@Nullable TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder spender(@Nullable AccountID spender) {
            this.spender = spender;
            return this;
        }

        public Builder spender(AccountID.Builder builder) {
            this.spender = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }
    }
}

