/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.TokenAssociateTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.TokenAssociateTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenAssociateTransactionBody(@Nullable AccountID account, @Nullable List<TokenID> tokens) {
    public static final Codec<TokenAssociateTransactionBody> PROTOBUF = new TokenAssociateTransactionBodyProtoCodec();
    public static final JsonCodec<TokenAssociateTransactionBody> JSON = new TokenAssociateTransactionBodyJsonCodec();
    public static final TokenAssociateTransactionBody DEFAULT = TokenAssociateTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        List<TokenID> list$tokens;
        int result = 1;
        if (this.account != null && !this.account.equals(TokenAssociateTransactionBody.DEFAULT.account)) {
            result = 31 * result + this.account.hashCode();
        }
        if ((list$tokens = this.tokens) != null) {
            for (TokenID o : list$tokens) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenAssociateTransactionBody thatObj = (TokenAssociateTransactionBody)that;
        if (this.account == null && thatObj.account != null) {
            return false;
        }
        if (this.account != null && !this.account.equals(thatObj.account)) {
            return false;
        }
        if (this.tokens == null && thatObj.tokens != null) {
            return false;
        }
        return this.tokens == null || this.tokens.equals(thatObj.tokens);
    }

    public boolean hasAccount() {
        return this.account != null;
    }

    public AccountID accountOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccount() ? this.account : defaultValue;
    }

    @NonNull
    public AccountID accountOrThrow() {
        return Objects.requireNonNull(this.account, "Field account is null");
    }

    public void ifAccount(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccount()) {
            ifPresent.accept(this.account);
        }
    }

    public boolean hasTokens() {
        return this.tokens != null;
    }

    public List<TokenID> tokensOrElse(@NonNull List<TokenID> defaultValue) {
        return this.hasTokens() ? this.tokens : defaultValue;
    }

    @NonNull
    public List<TokenID> tokensOrThrow() {
        return Objects.requireNonNull(this.tokens, "Field tokens is null");
    }

    public void ifTokens(@NonNull Consumer<List<TokenID>> ifPresent) {
        if (this.hasTokens()) {
            ifPresent.accept(this.tokens);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.account, this.tokens);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private AccountID account = null;
        @Nullable
        private List<TokenID> tokens = Collections.emptyList();

        public Builder() {
        }

        public Builder(AccountID account, List<TokenID> tokens) {
            this.account = account;
            this.tokens = tokens;
        }

        public TokenAssociateTransactionBody build() {
            return new TokenAssociateTransactionBody(this.account, this.tokens);
        }

        public Builder account(@Nullable AccountID account) {
            this.account = account;
            return this;
        }

        public Builder account(AccountID.Builder builder) {
            this.account = builder.build();
            return this;
        }

        public Builder tokens(@Nullable List<TokenID> tokens) {
            this.tokens = tokens;
            return this;
        }

        public Builder tokens(TokenID ... values) {
            this.tokens = List.of(values);
            return this;
        }
    }
}

