/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.TokenFeeScheduleUpdateTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.TokenFeeScheduleUpdateTransactionBodyProtoCodec;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenFeeScheduleUpdateTransactionBody(@Nullable TokenID tokenId, @Nullable List<CustomFee> customFees) {
    public static final Codec<TokenFeeScheduleUpdateTransactionBody> PROTOBUF = new TokenFeeScheduleUpdateTransactionBodyProtoCodec();
    public static final JsonCodec<TokenFeeScheduleUpdateTransactionBody> JSON = new TokenFeeScheduleUpdateTransactionBodyJsonCodec();
    public static final TokenFeeScheduleUpdateTransactionBody DEFAULT = TokenFeeScheduleUpdateTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        List<CustomFee> list$customFees;
        int result = 1;
        if (this.tokenId != null && !this.tokenId.equals(TokenFeeScheduleUpdateTransactionBody.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        if ((list$customFees = this.customFees) != null) {
            for (CustomFee o : list$customFees) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenFeeScheduleUpdateTransactionBody thatObj = (TokenFeeScheduleUpdateTransactionBody)that;
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        if (this.customFees == null && thatObj.customFees != null) {
            return false;
        }
        return this.customFees == null || this.customFees.equals(thatObj.customFees);
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasCustomFees() {
        return this.customFees != null;
    }

    public List<CustomFee> customFeesOrElse(@NonNull List<CustomFee> defaultValue) {
        return this.hasCustomFees() ? this.customFees : defaultValue;
    }

    @NonNull
    public List<CustomFee> customFeesOrThrow() {
        return Objects.requireNonNull(this.customFees, "Field customFees is null");
    }

    public void ifCustomFees(@NonNull Consumer<List<CustomFee>> ifPresent) {
        if (this.hasCustomFees()) {
            ifPresent.accept(this.customFees);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.customFees);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TokenID tokenId = null;
        @Nullable
        private List<CustomFee> customFees = Collections.emptyList();

        public Builder() {
        }

        public Builder(TokenID tokenId, List<CustomFee> customFees) {
            this.tokenId = tokenId;
            this.customFees = customFees;
        }

        public TokenFeeScheduleUpdateTransactionBody build() {
            return new TokenFeeScheduleUpdateTransactionBody(this.tokenId, this.customFees);
        }

        public Builder tokenId(@Nullable TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder customFees(@Nullable List<CustomFee> customFees) {
            this.customFees = customFees;
            return this;
        }

        public Builder customFees(CustomFee ... values) {
            this.customFees = List.of(values);
            return this;
        }
    }
}

