/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenFreezeStatus;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenKycStatus;
import com.hedera.hapi.node.base.TokenPauseStatus;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.token.codec.TokenInfoJsonCodec;
import com.hedera.hapi.node.token.codec.TokenInfoProtoCodec;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenInfo(@Nullable TokenID tokenId, String name, String symbol, int decimals, long totalSupply, @Nullable AccountID treasury, @Nullable Key adminKey, @Nullable Key kycKey, @Nullable Key freezeKey, @Nullable Key wipeKey, @Nullable Key supplyKey, TokenFreezeStatus defaultFreezeStatus, TokenKycStatus defaultKycStatus, boolean deleted, @Nullable AccountID autoRenewAccount, @Nullable Duration autoRenewPeriod, @Nullable Timestamp expiry, String memo, TokenType tokenType, TokenSupplyType supplyType, long maxSupply, @Nullable Key feeScheduleKey, @Nullable List<CustomFee> customFees, @Nullable Key pauseKey, TokenPauseStatus pauseStatus, @NonNull Bytes ledgerId) {
    public static final Codec<TokenInfo> PROTOBUF = new TokenInfoProtoCodec();
    public static final JsonCodec<TokenInfo> JSON = new TokenInfoJsonCodec();
    public static final TokenInfo DEFAULT = TokenInfo.newBuilder().build();

    @Override
    public int hashCode() {
        List<CustomFee> list$customFees;
        int result = 1;
        if (this.tokenId != null && !this.tokenId.equals(TokenInfo.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        if (this.name != null && !this.name.equals(TokenInfo.DEFAULT.name)) {
            result = 31 * result + this.name.hashCode();
        }
        if (this.symbol != null && !this.symbol.equals(TokenInfo.DEFAULT.symbol)) {
            result = 31 * result + this.symbol.hashCode();
        }
        if (this.decimals != TokenInfo.DEFAULT.decimals) {
            result = 31 * result + Integer.hashCode(this.decimals);
        }
        if (this.totalSupply != TokenInfo.DEFAULT.totalSupply) {
            result = 31 * result + Long.hashCode(this.totalSupply);
        }
        if (this.treasury != null && !this.treasury.equals(TokenInfo.DEFAULT.treasury)) {
            result = 31 * result + this.treasury.hashCode();
        }
        if (this.adminKey != null && !this.adminKey.equals(TokenInfo.DEFAULT.adminKey)) {
            result = 31 * result + this.adminKey.hashCode();
        }
        if (this.kycKey != null && !this.kycKey.equals(TokenInfo.DEFAULT.kycKey)) {
            result = 31 * result + this.kycKey.hashCode();
        }
        if (this.freezeKey != null && !this.freezeKey.equals(TokenInfo.DEFAULT.freezeKey)) {
            result = 31 * result + this.freezeKey.hashCode();
        }
        if (this.wipeKey != null && !this.wipeKey.equals(TokenInfo.DEFAULT.wipeKey)) {
            result = 31 * result + this.wipeKey.hashCode();
        }
        if (this.supplyKey != null && !this.supplyKey.equals(TokenInfo.DEFAULT.supplyKey)) {
            result = 31 * result + this.supplyKey.hashCode();
        }
        if (this.defaultFreezeStatus != null && !this.defaultFreezeStatus.equals((Object)TokenInfo.DEFAULT.defaultFreezeStatus)) {
            result = 31 * result + this.defaultFreezeStatus.hashCode();
        }
        if (this.defaultKycStatus != null && !this.defaultKycStatus.equals((Object)TokenInfo.DEFAULT.defaultKycStatus)) {
            result = 31 * result + this.defaultKycStatus.hashCode();
        }
        if (this.deleted != TokenInfo.DEFAULT.deleted) {
            result = 31 * result + Boolean.hashCode(this.deleted);
        }
        if (this.autoRenewAccount != null && !this.autoRenewAccount.equals(TokenInfo.DEFAULT.autoRenewAccount)) {
            result = 31 * result + this.autoRenewAccount.hashCode();
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(TokenInfo.DEFAULT.autoRenewPeriod)) {
            result = 31 * result + this.autoRenewPeriod.hashCode();
        }
        if (this.expiry != null && !this.expiry.equals(TokenInfo.DEFAULT.expiry)) {
            result = 31 * result + this.expiry.hashCode();
        }
        if (this.memo != null && !this.memo.equals(TokenInfo.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.tokenType != null && !this.tokenType.equals((Object)TokenInfo.DEFAULT.tokenType)) {
            result = 31 * result + this.tokenType.hashCode();
        }
        if (this.supplyType != null && !this.supplyType.equals((Object)TokenInfo.DEFAULT.supplyType)) {
            result = 31 * result + this.supplyType.hashCode();
        }
        if (this.maxSupply != TokenInfo.DEFAULT.maxSupply) {
            result = 31 * result + Long.hashCode(this.maxSupply);
        }
        if (this.feeScheduleKey != null && !this.feeScheduleKey.equals(TokenInfo.DEFAULT.feeScheduleKey)) {
            result = 31 * result + this.feeScheduleKey.hashCode();
        }
        if ((list$customFees = this.customFees) != null) {
            for (CustomFee o : list$customFees) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.pauseKey != null && !this.pauseKey.equals(TokenInfo.DEFAULT.pauseKey)) {
            result = 31 * result + this.pauseKey.hashCode();
        }
        if (this.pauseStatus != null && !this.pauseStatus.equals((Object)TokenInfo.DEFAULT.pauseStatus)) {
            result = 31 * result + this.pauseStatus.hashCode();
        }
        if (this.ledgerId != null && !this.ledgerId.equals((Object)TokenInfo.DEFAULT.ledgerId)) {
            result = 31 * result + this.ledgerId.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenInfo thatObj = (TokenInfo)that;
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        if (this.name == null && thatObj.name != null) {
            return false;
        }
        if (this.name != null && !this.name.equals(thatObj.name)) {
            return false;
        }
        if (this.symbol == null && thatObj.symbol != null) {
            return false;
        }
        if (this.symbol != null && !this.symbol.equals(thatObj.symbol)) {
            return false;
        }
        if (this.decimals != thatObj.decimals) {
            return false;
        }
        if (this.totalSupply != thatObj.totalSupply) {
            return false;
        }
        if (this.treasury == null && thatObj.treasury != null) {
            return false;
        }
        if (this.treasury != null && !this.treasury.equals(thatObj.treasury)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.kycKey == null && thatObj.kycKey != null) {
            return false;
        }
        if (this.kycKey != null && !this.kycKey.equals(thatObj.kycKey)) {
            return false;
        }
        if (this.freezeKey == null && thatObj.freezeKey != null) {
            return false;
        }
        if (this.freezeKey != null && !this.freezeKey.equals(thatObj.freezeKey)) {
            return false;
        }
        if (this.wipeKey == null && thatObj.wipeKey != null) {
            return false;
        }
        if (this.wipeKey != null && !this.wipeKey.equals(thatObj.wipeKey)) {
            return false;
        }
        if (this.supplyKey == null && thatObj.supplyKey != null) {
            return false;
        }
        if (this.supplyKey != null && !this.supplyKey.equals(thatObj.supplyKey)) {
            return false;
        }
        if (this.defaultFreezeStatus == null && thatObj.defaultFreezeStatus != null) {
            return false;
        }
        if (this.defaultFreezeStatus != null && !this.defaultFreezeStatus.equals((Object)thatObj.defaultFreezeStatus)) {
            return false;
        }
        if (this.defaultKycStatus == null && thatObj.defaultKycStatus != null) {
            return false;
        }
        if (this.defaultKycStatus != null && !this.defaultKycStatus.equals((Object)thatObj.defaultKycStatus)) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.autoRenewAccount == null && thatObj.autoRenewAccount != null) {
            return false;
        }
        if (this.autoRenewAccount != null && !this.autoRenewAccount.equals(thatObj.autoRenewAccount)) {
            return false;
        }
        if (this.autoRenewPeriod == null && thatObj.autoRenewPeriod != null) {
            return false;
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(thatObj.autoRenewPeriod)) {
            return false;
        }
        if (this.expiry == null && thatObj.expiry != null) {
            return false;
        }
        if (this.expiry != null && !this.expiry.equals(thatObj.expiry)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.tokenType == null && thatObj.tokenType != null) {
            return false;
        }
        if (this.tokenType != null && !this.tokenType.equals((Object)thatObj.tokenType)) {
            return false;
        }
        if (this.supplyType == null && thatObj.supplyType != null) {
            return false;
        }
        if (this.supplyType != null && !this.supplyType.equals((Object)thatObj.supplyType)) {
            return false;
        }
        if (this.maxSupply != thatObj.maxSupply) {
            return false;
        }
        if (this.feeScheduleKey == null && thatObj.feeScheduleKey != null) {
            return false;
        }
        if (this.feeScheduleKey != null && !this.feeScheduleKey.equals(thatObj.feeScheduleKey)) {
            return false;
        }
        if (this.customFees == null && thatObj.customFees != null) {
            return false;
        }
        if (this.customFees != null && !this.customFees.equals(thatObj.customFees)) {
            return false;
        }
        if (this.pauseKey == null && thatObj.pauseKey != null) {
            return false;
        }
        if (this.pauseKey != null && !this.pauseKey.equals(thatObj.pauseKey)) {
            return false;
        }
        if (this.pauseStatus == null && thatObj.pauseStatus != null) {
            return false;
        }
        if (this.pauseStatus != null && !this.pauseStatus.equals((Object)thatObj.pauseStatus)) {
            return false;
        }
        if (this.ledgerId == null && thatObj.ledgerId != null) {
            return false;
        }
        return this.ledgerId == null || this.ledgerId.equals((Object)thatObj.ledgerId);
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasTreasury() {
        return this.treasury != null;
    }

    public AccountID treasuryOrElse(@NonNull AccountID defaultValue) {
        return this.hasTreasury() ? this.treasury : defaultValue;
    }

    @NonNull
    public AccountID treasuryOrThrow() {
        return Objects.requireNonNull(this.treasury, "Field treasury is null");
    }

    public void ifTreasury(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasTreasury()) {
            ifPresent.accept(this.treasury);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasKycKey() {
        return this.kycKey != null;
    }

    public Key kycKeyOrElse(@NonNull Key defaultValue) {
        return this.hasKycKey() ? this.kycKey : defaultValue;
    }

    @NonNull
    public Key kycKeyOrThrow() {
        return Objects.requireNonNull(this.kycKey, "Field kycKey is null");
    }

    public void ifKycKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasKycKey()) {
            ifPresent.accept(this.kycKey);
        }
    }

    public boolean hasFreezeKey() {
        return this.freezeKey != null;
    }

    public Key freezeKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFreezeKey() ? this.freezeKey : defaultValue;
    }

    @NonNull
    public Key freezeKeyOrThrow() {
        return Objects.requireNonNull(this.freezeKey, "Field freezeKey is null");
    }

    public void ifFreezeKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFreezeKey()) {
            ifPresent.accept(this.freezeKey);
        }
    }

    public boolean hasWipeKey() {
        return this.wipeKey != null;
    }

    public Key wipeKeyOrElse(@NonNull Key defaultValue) {
        return this.hasWipeKey() ? this.wipeKey : defaultValue;
    }

    @NonNull
    public Key wipeKeyOrThrow() {
        return Objects.requireNonNull(this.wipeKey, "Field wipeKey is null");
    }

    public void ifWipeKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasWipeKey()) {
            ifPresent.accept(this.wipeKey);
        }
    }

    public boolean hasSupplyKey() {
        return this.supplyKey != null;
    }

    public Key supplyKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSupplyKey() ? this.supplyKey : defaultValue;
    }

    @NonNull
    public Key supplyKeyOrThrow() {
        return Objects.requireNonNull(this.supplyKey, "Field supplyKey is null");
    }

    public void ifSupplyKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSupplyKey()) {
            ifPresent.accept(this.supplyKey);
        }
    }

    public boolean hasAutoRenewAccount() {
        return this.autoRenewAccount != null;
    }

    public AccountID autoRenewAccountOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccount() ? this.autoRenewAccount : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccount, "Field autoRenewAccount is null");
    }

    public void ifAutoRenewAccount(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccount()) {
            ifPresent.accept(this.autoRenewAccount);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasExpiry() {
        return this.expiry != null;
    }

    public Timestamp expiryOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpiry() ? this.expiry : defaultValue;
    }

    @NonNull
    public Timestamp expiryOrThrow() {
        return Objects.requireNonNull(this.expiry, "Field expiry is null");
    }

    public void ifExpiry(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpiry()) {
            ifPresent.accept(this.expiry);
        }
    }

    public boolean hasFeeScheduleKey() {
        return this.feeScheduleKey != null;
    }

    public Key feeScheduleKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFeeScheduleKey() ? this.feeScheduleKey : defaultValue;
    }

    @NonNull
    public Key feeScheduleKeyOrThrow() {
        return Objects.requireNonNull(this.feeScheduleKey, "Field feeScheduleKey is null");
    }

    public void ifFeeScheduleKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFeeScheduleKey()) {
            ifPresent.accept(this.feeScheduleKey);
        }
    }

    public boolean hasCustomFees() {
        return this.customFees != null;
    }

    public List<CustomFee> customFeesOrElse(@NonNull List<CustomFee> defaultValue) {
        return this.hasCustomFees() ? this.customFees : defaultValue;
    }

    @NonNull
    public List<CustomFee> customFeesOrThrow() {
        return Objects.requireNonNull(this.customFees, "Field customFees is null");
    }

    public void ifCustomFees(@NonNull Consumer<List<CustomFee>> ifPresent) {
        if (this.hasCustomFees()) {
            ifPresent.accept(this.customFees);
        }
    }

    public boolean hasPauseKey() {
        return this.pauseKey != null;
    }

    public Key pauseKeyOrElse(@NonNull Key defaultValue) {
        return this.hasPauseKey() ? this.pauseKey : defaultValue;
    }

    @NonNull
    public Key pauseKeyOrThrow() {
        return Objects.requireNonNull(this.pauseKey, "Field pauseKey is null");
    }

    public void ifPauseKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasPauseKey()) {
            ifPresent.accept(this.pauseKey);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.name, this.symbol, this.decimals, this.totalSupply, this.treasury, this.adminKey, this.kycKey, this.freezeKey, this.wipeKey, this.supplyKey, this.defaultFreezeStatus, this.defaultKycStatus, this.deleted, this.autoRenewAccount, this.autoRenewPeriod, this.expiry, this.memo, this.tokenType, this.supplyType, this.maxSupply, this.feeScheduleKey, this.customFees, this.pauseKey, this.pauseStatus, this.ledgerId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TokenID tokenId = null;
        private String name = "";
        private String symbol = "";
        private int decimals = 0;
        private long totalSupply = 0L;
        @Nullable
        private AccountID treasury = null;
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Key kycKey = null;
        @Nullable
        private Key freezeKey = null;
        @Nullable
        private Key wipeKey = null;
        @Nullable
        private Key supplyKey = null;
        private TokenFreezeStatus defaultFreezeStatus = TokenFreezeStatus.values()[0];
        private TokenKycStatus defaultKycStatus = TokenKycStatus.values()[0];
        private boolean deleted = false;
        @Nullable
        private AccountID autoRenewAccount = null;
        @Nullable
        private Duration autoRenewPeriod = null;
        @Nullable
        private Timestamp expiry = null;
        private String memo = "";
        private TokenType tokenType = TokenType.values()[0];
        private TokenSupplyType supplyType = TokenSupplyType.values()[0];
        private long maxSupply = 0L;
        @Nullable
        private Key feeScheduleKey = null;
        @Nullable
        private List<CustomFee> customFees = Collections.emptyList();
        @Nullable
        private Key pauseKey = null;
        private TokenPauseStatus pauseStatus = TokenPauseStatus.values()[0];
        @NonNull
        private Bytes ledgerId = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(TokenID tokenId, String name, String symbol, int decimals, long totalSupply, AccountID treasury, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, TokenFreezeStatus defaultFreezeStatus, TokenKycStatus defaultKycStatus, boolean deleted, AccountID autoRenewAccount, Duration autoRenewPeriod, Timestamp expiry, String memo, TokenType tokenType, TokenSupplyType supplyType, long maxSupply, Key feeScheduleKey, List<CustomFee> customFees, Key pauseKey, TokenPauseStatus pauseStatus, Bytes ledgerId) {
            this.tokenId = tokenId;
            this.name = name;
            this.symbol = symbol;
            this.decimals = decimals;
            this.totalSupply = totalSupply;
            this.treasury = treasury;
            this.adminKey = adminKey;
            this.kycKey = kycKey;
            this.freezeKey = freezeKey;
            this.wipeKey = wipeKey;
            this.supplyKey = supplyKey;
            this.defaultFreezeStatus = defaultFreezeStatus;
            this.defaultKycStatus = defaultKycStatus;
            this.deleted = deleted;
            this.autoRenewAccount = autoRenewAccount;
            this.autoRenewPeriod = autoRenewPeriod;
            this.expiry = expiry;
            this.memo = memo;
            this.tokenType = tokenType;
            this.supplyType = supplyType;
            this.maxSupply = maxSupply;
            this.feeScheduleKey = feeScheduleKey;
            this.customFees = customFees;
            this.pauseKey = pauseKey;
            this.pauseStatus = pauseStatus;
            this.ledgerId = ledgerId;
        }

        public TokenInfo build() {
            return new TokenInfo(this.tokenId, this.name, this.symbol, this.decimals, this.totalSupply, this.treasury, this.adminKey, this.kycKey, this.freezeKey, this.wipeKey, this.supplyKey, this.defaultFreezeStatus, this.defaultKycStatus, this.deleted, this.autoRenewAccount, this.autoRenewPeriod, this.expiry, this.memo, this.tokenType, this.supplyType, this.maxSupply, this.feeScheduleKey, this.customFees, this.pauseKey, this.pauseStatus, this.ledgerId);
        }

        public Builder tokenId(@Nullable TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public Builder decimals(int decimals) {
            this.decimals = decimals;
            return this;
        }

        public Builder totalSupply(long totalSupply) {
            this.totalSupply = totalSupply;
            return this;
        }

        public Builder treasury(@Nullable AccountID treasury) {
            this.treasury = treasury;
            return this;
        }

        public Builder treasury(AccountID.Builder builder) {
            this.treasury = builder.build();
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder kycKey(@Nullable Key kycKey) {
            this.kycKey = kycKey;
            return this;
        }

        public Builder kycKey(Key.Builder builder) {
            this.kycKey = builder.build();
            return this;
        }

        public Builder freezeKey(@Nullable Key freezeKey) {
            this.freezeKey = freezeKey;
            return this;
        }

        public Builder freezeKey(Key.Builder builder) {
            this.freezeKey = builder.build();
            return this;
        }

        public Builder wipeKey(@Nullable Key wipeKey) {
            this.wipeKey = wipeKey;
            return this;
        }

        public Builder wipeKey(Key.Builder builder) {
            this.wipeKey = builder.build();
            return this;
        }

        public Builder supplyKey(@Nullable Key supplyKey) {
            this.supplyKey = supplyKey;
            return this;
        }

        public Builder supplyKey(Key.Builder builder) {
            this.supplyKey = builder.build();
            return this;
        }

        public Builder defaultFreezeStatus(TokenFreezeStatus defaultFreezeStatus) {
            this.defaultFreezeStatus = defaultFreezeStatus;
            return this;
        }

        public Builder defaultKycStatus(TokenKycStatus defaultKycStatus) {
            this.defaultKycStatus = defaultKycStatus;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder autoRenewAccount(@Nullable AccountID autoRenewAccount) {
            this.autoRenewAccount = autoRenewAccount;
            return this;
        }

        public Builder autoRenewAccount(AccountID.Builder builder) {
            this.autoRenewAccount = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(@Nullable Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder expiry(@Nullable Timestamp expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder expiry(Timestamp.Builder builder) {
            this.expiry = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder tokenType(TokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder supplyType(TokenSupplyType supplyType) {
            this.supplyType = supplyType;
            return this;
        }

        public Builder maxSupply(long maxSupply) {
            this.maxSupply = maxSupply;
            return this;
        }

        public Builder feeScheduleKey(@Nullable Key feeScheduleKey) {
            this.feeScheduleKey = feeScheduleKey;
            return this;
        }

        public Builder feeScheduleKey(Key.Builder builder) {
            this.feeScheduleKey = builder.build();
            return this;
        }

        public Builder customFees(@Nullable List<CustomFee> customFees) {
            this.customFees = customFees;
            return this;
        }

        public Builder customFees(CustomFee ... values) {
            this.customFees = List.of(values);
            return this;
        }

        public Builder pauseKey(@Nullable Key pauseKey) {
            this.pauseKey = pauseKey;
            return this;
        }

        public Builder pauseKey(Key.Builder builder) {
            this.pauseKey = builder.build();
            return this;
        }

        public Builder pauseStatus(TokenPauseStatus pauseStatus) {
            this.pauseStatus = pauseStatus;
            return this;
        }

        public Builder ledgerId(@NonNull Bytes ledgerId) {
            this.ledgerId = ledgerId != null ? ledgerId : Bytes.EMPTY;
            return this;
        }
    }
}

