/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.TokenMintTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.TokenMintTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenMintTransactionBody(@Nullable TokenID token, long amount, @NonNull List<Bytes> metadata) {
    public static final Codec<TokenMintTransactionBody> PROTOBUF = new TokenMintTransactionBodyProtoCodec();
    public static final JsonCodec<TokenMintTransactionBody> JSON = new TokenMintTransactionBodyJsonCodec();
    public static final TokenMintTransactionBody DEFAULT = TokenMintTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        List<Bytes> list$metadata;
        int result = 1;
        if (this.token != null && !this.token.equals(TokenMintTransactionBody.DEFAULT.token)) {
            result = 31 * result + this.token.hashCode();
        }
        if (this.amount != TokenMintTransactionBody.DEFAULT.amount) {
            result = 31 * result + Long.hashCode(this.amount);
        }
        if ((list$metadata = this.metadata) != null) {
            for (Bytes o : list$metadata) {
                if (o != null) {
                    result = 31 * result + o.hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenMintTransactionBody thatObj = (TokenMintTransactionBody)that;
        if (this.token == null && thatObj.token != null) {
            return false;
        }
        if (this.token != null && !this.token.equals(thatObj.token)) {
            return false;
        }
        if (this.amount != thatObj.amount) {
            return false;
        }
        if (this.metadata == null && thatObj.metadata != null) {
            return false;
        }
        return this.metadata == null || this.metadata.equals(thatObj.metadata);
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public TokenID tokenOrElse(@NonNull TokenID defaultValue) {
        return this.hasToken() ? this.token : defaultValue;
    }

    @NonNull
    public TokenID tokenOrThrow() {
        return Objects.requireNonNull(this.token, "Field token is null");
    }

    public void ifToken(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasToken()) {
            ifPresent.accept(this.token);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.token, this.amount, this.metadata);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TokenID token = null;
        private long amount = 0L;
        @NonNull
        private List<Bytes> metadata = Collections.emptyList();

        public Builder() {
        }

        public Builder(TokenID token, long amount, List<Bytes> metadata) {
            this.token = token;
            this.amount = amount;
            this.metadata = metadata;
        }

        public TokenMintTransactionBody build() {
            return new TokenMintTransactionBody(this.token, this.amount, this.metadata);
        }

        public Builder token(@Nullable TokenID token) {
            this.token = token;
            return this;
        }

        public Builder token(TokenID.Builder builder) {
            this.token = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder metadata(@NonNull List<Bytes> metadata) {
            this.metadata = metadata != null ? metadata : Collections.emptyList();
            return this;
        }

        public Builder metadata(Bytes ... values) {
            this.metadata = List.of(values) != null ? this.metadata : Collections.emptyList();
            return this;
        }
    }
}

