/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.token.LiveHash;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class LiveHashJsonCodec
implements JsonCodec<LiveHash> {
    @NonNull
    public LiveHash parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            AccountID temp_accountId = null;
            Bytes temp_hash = Bytes.EMPTY;
            KeyList temp_keys = null;
            Duration temp_duration = null;
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "accountId": {
                        temp_accountId = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block14;
                    }
                    case "hash": {
                        temp_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                    case "keys": {
                        temp_keys = (KeyList)KeyList.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block14;
                    }
                    case "duration": {
                        temp_duration = (Duration)Duration.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new LiveHash(temp_accountId, temp_hash, temp_keys, temp_duration);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull LiveHash data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.accountId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"accountId", AccountID.JSON, (Object)data.accountId()));
        }
        if (data.hash() != Bytes.EMPTY && data.hash() != null && data.hash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"hash", (Bytes)data.hash()));
        }
        if (data.keys() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"keys", KeyList.JSON, (Object)data.keys()));
        }
        if (data.duration() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"duration", Duration.JSON, (Object)data.duration()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

