/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.NftAllowance;
import com.hedera.hapi.node.token.schema.NftAllowanceSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class NftAllowanceJsonCodec
implements JsonCodec<NftAllowance> {
    @NonNull
    public NftAllowance parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            TokenID temp_tokenId = null;
            AccountID temp_owner = null;
            AccountID temp_spender = null;
            List<Long> temp_serial_numbers = Collections.emptyList();
            Boolean temp_approved_for_all = null;
            AccountID temp_delegating_spender = null;
            block18: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "tokenId": {
                        temp_tokenId = (TokenID)TokenID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block18;
                    }
                    case "owner": {
                        temp_owner = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block18;
                    }
                    case "spender": {
                        temp_spender = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block18;
                    }
                    case "serialNumbers": {
                        temp_serial_numbers = kvPair.value().arr().value().stream().map(v -> JsonTools.parseLong((JSONParser.ValueContext)v)).toList();
                        continue block18;
                    }
                    case "approvedForAll": {
                        temp_approved_for_all = JsonTools.parseBoolean((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "delegatingSpender": {
                        temp_delegating_spender = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block18;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new NftAllowance(temp_tokenId, temp_owner, temp_spender, temp_serial_numbers, temp_approved_for_all, temp_delegating_spender);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull NftAllowance data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.tokenId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"tokenId", TokenID.JSON, (Object)data.tokenId()));
        }
        if (data.owner() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"owner", AccountID.JSON, (Object)data.owner()));
        }
        if (data.spender() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"spender", AccountID.JSON, (Object)data.spender()));
        }
        if (!data.serialNumbers().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"serialNumbers", (FieldDefinition)NftAllowanceSchema.SERIAL_NUMBERS, data.serialNumbers()));
        }
        if (data.approvedForAll() != null) {
            fieldLines.add(JsonTools.field((String)"approvedForAll", (Boolean)data.approvedForAll()));
        }
        if (data.delegatingSpender() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"delegatingSpender", AccountID.JSON, (Object)data.delegatingSpender()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

