/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.FractionalFee;
import com.hedera.hapi.node.transaction.RoyaltyFee;
import com.hedera.hapi.node.transaction.codec.CustomFeeJsonCodec;
import com.hedera.hapi.node.transaction.codec.CustomFeeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record CustomFee(OneOf<FeeOneOfType> fee, @Nullable AccountID feeCollectorAccountId, boolean allCollectorsAreExempt) {
    public static final Codec<CustomFee> PROTOBUF = new CustomFeeProtoCodec();
    public static final JsonCodec<CustomFee> JSON = new CustomFeeJsonCodec();
    public static final CustomFee DEFAULT = CustomFee.newBuilder().build();

    public CustomFee {
        if (fee == null) {
            throw new NullPointerException("Parameter 'fee' must be supplied and can not be null");
        }
    }

    @Override
    public int hashCode() {
        int result = 1;
        if (this.fee != null && !this.fee.equals(CustomFee.DEFAULT.fee)) {
            result = 31 * result + this.fee.hashCode();
        }
        if (this.feeCollectorAccountId != null && !this.feeCollectorAccountId.equals(CustomFee.DEFAULT.feeCollectorAccountId)) {
            result = 31 * result + this.feeCollectorAccountId.hashCode();
        }
        if (this.allCollectorsAreExempt != CustomFee.DEFAULT.allCollectorsAreExempt) {
            result = 31 * result + Boolean.hashCode(this.allCollectorsAreExempt);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        CustomFee thatObj = (CustomFee)that;
        if (this.fee == null && thatObj.fee != null) {
            return false;
        }
        if (this.fee != null && !this.fee.equals(thatObj.fee)) {
            return false;
        }
        if (this.feeCollectorAccountId == null && thatObj.feeCollectorAccountId != null) {
            return false;
        }
        if (this.feeCollectorAccountId != null && !this.feeCollectorAccountId.equals(thatObj.feeCollectorAccountId)) {
            return false;
        }
        return this.allCollectorsAreExempt == thatObj.allCollectorsAreExempt;
    }

    public boolean hasFeeCollectorAccountId() {
        return this.feeCollectorAccountId != null;
    }

    public AccountID feeCollectorAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasFeeCollectorAccountId() ? this.feeCollectorAccountId : defaultValue;
    }

    @NonNull
    public AccountID feeCollectorAccountIdOrThrow() {
        return Objects.requireNonNull(this.feeCollectorAccountId, "Field feeCollectorAccountId is null");
    }

    public void ifFeeCollectorAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasFeeCollectorAccountId()) {
            ifPresent.accept(this.feeCollectorAccountId);
        }
    }

    @Nullable
    public FixedFee fixedFee() {
        return this.fee.kind() == FeeOneOfType.FIXED_FEE ? (FixedFee)this.fee.value() : null;
    }

    public boolean hasFixedFee() {
        return this.fee.kind() == FeeOneOfType.FIXED_FEE;
    }

    public FixedFee fixedFeeOrElse(@NonNull FixedFee defaultValue) {
        return this.hasFixedFee() ? this.fixedFee() : defaultValue;
    }

    @NonNull
    public FixedFee fixedFeeOrThrow() {
        return Objects.requireNonNull(this.fixedFee(), "Field fixedFee is null");
    }

    @Nullable
    public FractionalFee fractionalFee() {
        return this.fee.kind() == FeeOneOfType.FRACTIONAL_FEE ? (FractionalFee)this.fee.value() : null;
    }

    public boolean hasFractionalFee() {
        return this.fee.kind() == FeeOneOfType.FRACTIONAL_FEE;
    }

    public FractionalFee fractionalFeeOrElse(@NonNull FractionalFee defaultValue) {
        return this.hasFractionalFee() ? this.fractionalFee() : defaultValue;
    }

    @NonNull
    public FractionalFee fractionalFeeOrThrow() {
        return Objects.requireNonNull(this.fractionalFee(), "Field fractionalFee is null");
    }

    @Nullable
    public RoyaltyFee royaltyFee() {
        return this.fee.kind() == FeeOneOfType.ROYALTY_FEE ? (RoyaltyFee)this.fee.value() : null;
    }

    public boolean hasRoyaltyFee() {
        return this.fee.kind() == FeeOneOfType.ROYALTY_FEE;
    }

    public RoyaltyFee royaltyFeeOrElse(@NonNull RoyaltyFee defaultValue) {
        return this.hasRoyaltyFee() ? this.royaltyFee() : defaultValue;
    }

    @NonNull
    public RoyaltyFee royaltyFeeOrThrow() {
        return Objects.requireNonNull(this.royaltyFee(), "Field royaltyFee is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.fee, this.feeCollectorAccountId, this.allCollectorsAreExempt);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum FeeOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        FIXED_FEE(1, "fixed_fee"),
        FRACTIONAL_FEE(2, "fractional_fee"),
        ROYALTY_FEE(4, "royalty_fee");

        private final int protoOrdinal;
        private final String protoName;

        private FeeOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static FeeOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> FIXED_FEE;
                case 2 -> FRACTIONAL_FEE;
                case 4 -> ROYALTY_FEE;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static FeeOneOfType fromString(String name) {
            return switch (name) {
                case "fixed_fee", "FIXED_FEE" -> FIXED_FEE;
                case "fractional_fee", "FRACTIONAL_FEE" -> FRACTIONAL_FEE;
                case "royalty_fee", "ROYALTY_FEE" -> ROYALTY_FEE;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private OneOf<FeeOneOfType> fee = CustomFeeProtoCodec.FEE_UNSET;
        @Nullable
        private AccountID feeCollectorAccountId = null;
        private boolean allCollectorsAreExempt = false;

        public Builder() {
        }

        public Builder(OneOf<FeeOneOfType> fee, AccountID feeCollectorAccountId, boolean allCollectorsAreExempt) {
            this.fee = fee;
            this.feeCollectorAccountId = feeCollectorAccountId;
            this.allCollectorsAreExempt = allCollectorsAreExempt;
        }

        public CustomFee build() {
            return new CustomFee(this.fee, this.feeCollectorAccountId, this.allCollectorsAreExempt);
        }

        public Builder fixedFee(@Nullable FixedFee fixedFee) {
            this.fee = new OneOf((Enum)FeeOneOfType.FIXED_FEE, (Object)fixedFee);
            return this;
        }

        public Builder fixedFee(FixedFee.Builder builder) {
            this.fee = new OneOf((Enum)FeeOneOfType.FIXED_FEE, (Object)builder.build());
            return this;
        }

        public Builder fractionalFee(@Nullable FractionalFee fractionalFee) {
            this.fee = new OneOf((Enum)FeeOneOfType.FRACTIONAL_FEE, (Object)fractionalFee);
            return this;
        }

        public Builder fractionalFee(FractionalFee.Builder builder) {
            this.fee = new OneOf((Enum)FeeOneOfType.FRACTIONAL_FEE, (Object)builder.build());
            return this;
        }

        public Builder royaltyFee(@Nullable RoyaltyFee royaltyFee) {
            this.fee = new OneOf((Enum)FeeOneOfType.ROYALTY_FEE, (Object)royaltyFee);
            return this;
        }

        public Builder royaltyFee(RoyaltyFee.Builder builder) {
            this.fee = new OneOf((Enum)FeeOneOfType.ROYALTY_FEE, (Object)builder.build());
            return this;
        }

        public Builder feeCollectorAccountId(@Nullable AccountID feeCollectorAccountId) {
            this.feeCollectorAccountId = feeCollectorAccountId;
            return this;
        }

        public Builder feeCollectorAccountId(AccountID.Builder builder) {
            this.feeCollectorAccountId = builder.build();
            return this;
        }

        public Builder allCollectorsAreExempt(boolean allCollectorsAreExempt) {
            this.allCollectorsAreExempt = allCollectorsAreExempt;
            return this;
        }
    }
}

