/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.transaction.codec.NodeStakeJsonCodec;
import com.hedera.hapi.node.transaction.codec.NodeStakeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;

public record NodeStake(long maxStake, long minStake, long nodeId, long rewardRate, long stake, long stakeNotRewarded, long stakeRewarded) {
    public static final Codec<NodeStake> PROTOBUF = new NodeStakeProtoCodec();
    public static final JsonCodec<NodeStake> JSON = new NodeStakeJsonCodec();
    public static final NodeStake DEFAULT = NodeStake.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.maxStake != NodeStake.DEFAULT.maxStake) {
            result = 31 * result + Long.hashCode(this.maxStake);
        }
        if (this.minStake != NodeStake.DEFAULT.minStake) {
            result = 31 * result + Long.hashCode(this.minStake);
        }
        if (this.nodeId != NodeStake.DEFAULT.nodeId) {
            result = 31 * result + Long.hashCode(this.nodeId);
        }
        if (this.rewardRate != NodeStake.DEFAULT.rewardRate) {
            result = 31 * result + Long.hashCode(this.rewardRate);
        }
        if (this.stake != NodeStake.DEFAULT.stake) {
            result = 31 * result + Long.hashCode(this.stake);
        }
        if (this.stakeNotRewarded != NodeStake.DEFAULT.stakeNotRewarded) {
            result = 31 * result + Long.hashCode(this.stakeNotRewarded);
        }
        if (this.stakeRewarded != NodeStake.DEFAULT.stakeRewarded) {
            result = 31 * result + Long.hashCode(this.stakeRewarded);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        NodeStake thatObj = (NodeStake)that;
        if (this.maxStake != thatObj.maxStake) {
            return false;
        }
        if (this.minStake != thatObj.minStake) {
            return false;
        }
        if (this.nodeId != thatObj.nodeId) {
            return false;
        }
        if (this.rewardRate != thatObj.rewardRate) {
            return false;
        }
        if (this.stake != thatObj.stake) {
            return false;
        }
        if (this.stakeNotRewarded != thatObj.stakeNotRewarded) {
            return false;
        }
        return this.stakeRewarded == thatObj.stakeRewarded;
    }

    public Builder copyBuilder() {
        return new Builder(this.maxStake, this.minStake, this.nodeId, this.rewardRate, this.stake, this.stakeNotRewarded, this.stakeRewarded);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long maxStake = 0L;
        private long minStake = 0L;
        private long nodeId = 0L;
        private long rewardRate = 0L;
        private long stake = 0L;
        private long stakeNotRewarded = 0L;
        private long stakeRewarded = 0L;

        public Builder() {
        }

        public Builder(long maxStake, long minStake, long nodeId, long rewardRate, long stake, long stakeNotRewarded, long stakeRewarded) {
            this.maxStake = maxStake;
            this.minStake = minStake;
            this.nodeId = nodeId;
            this.rewardRate = rewardRate;
            this.stake = stake;
            this.stakeNotRewarded = stakeNotRewarded;
            this.stakeRewarded = stakeRewarded;
        }

        public NodeStake build() {
            return new NodeStake(this.maxStake, this.minStake, this.nodeId, this.rewardRate, this.stake, this.stakeNotRewarded, this.stakeRewarded);
        }

        public Builder maxStake(long maxStake) {
            this.maxStake = maxStake;
            return this;
        }

        public Builder minStake(long minStake) {
            this.minStake = minStake;
            return this;
        }

        public Builder nodeId(long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder rewardRate(long rewardRate) {
            this.rewardRate = rewardRate;
            return this;
        }

        public Builder stake(long stake) {
            this.stake = stake;
            return this;
        }

        public Builder stakeNotRewarded(long stakeNotRewarded) {
            this.stakeNotRewarded = stakeNotRewarded;
            return this;
        }

        public Builder stakeRewarded(long stakeRewarded) {
            this.stakeRewarded = stakeRewarded;
            return this;
        }
    }
}

