/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.codec.RoyaltyFeeJsonCodec;
import com.hedera.hapi.node.transaction.codec.RoyaltyFeeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record RoyaltyFee(@Nullable Fraction exchangeValueFraction, @Nullable FixedFee fallbackFee) {
    public static final Codec<RoyaltyFee> PROTOBUF = new RoyaltyFeeProtoCodec();
    public static final JsonCodec<RoyaltyFee> JSON = new RoyaltyFeeJsonCodec();
    public static final RoyaltyFee DEFAULT = RoyaltyFee.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.exchangeValueFraction != null && !this.exchangeValueFraction.equals(RoyaltyFee.DEFAULT.exchangeValueFraction)) {
            result = 31 * result + this.exchangeValueFraction.hashCode();
        }
        if (this.fallbackFee != null && !this.fallbackFee.equals(RoyaltyFee.DEFAULT.fallbackFee)) {
            result = 31 * result + this.fallbackFee.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        RoyaltyFee thatObj = (RoyaltyFee)that;
        if (this.exchangeValueFraction == null && thatObj.exchangeValueFraction != null) {
            return false;
        }
        if (this.exchangeValueFraction != null && !this.exchangeValueFraction.equals(thatObj.exchangeValueFraction)) {
            return false;
        }
        if (this.fallbackFee == null && thatObj.fallbackFee != null) {
            return false;
        }
        return this.fallbackFee == null || this.fallbackFee.equals(thatObj.fallbackFee);
    }

    public boolean hasExchangeValueFraction() {
        return this.exchangeValueFraction != null;
    }

    public Fraction exchangeValueFractionOrElse(@NonNull Fraction defaultValue) {
        return this.hasExchangeValueFraction() ? this.exchangeValueFraction : defaultValue;
    }

    @NonNull
    public Fraction exchangeValueFractionOrThrow() {
        return Objects.requireNonNull(this.exchangeValueFraction, "Field exchangeValueFraction is null");
    }

    public void ifExchangeValueFraction(@NonNull Consumer<Fraction> ifPresent) {
        if (this.hasExchangeValueFraction()) {
            ifPresent.accept(this.exchangeValueFraction);
        }
    }

    public boolean hasFallbackFee() {
        return this.fallbackFee != null;
    }

    public FixedFee fallbackFeeOrElse(@NonNull FixedFee defaultValue) {
        return this.hasFallbackFee() ? this.fallbackFee : defaultValue;
    }

    @NonNull
    public FixedFee fallbackFeeOrThrow() {
        return Objects.requireNonNull(this.fallbackFee, "Field fallbackFee is null");
    }

    public void ifFallbackFee(@NonNull Consumer<FixedFee> ifPresent) {
        if (this.hasFallbackFee()) {
            ifPresent.accept(this.fallbackFee);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.exchangeValueFraction, this.fallbackFee);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Fraction exchangeValueFraction = null;
        @Nullable
        private FixedFee fallbackFee = null;

        public Builder() {
        }

        public Builder(Fraction exchangeValueFraction, FixedFee fallbackFee) {
            this.exchangeValueFraction = exchangeValueFraction;
            this.fallbackFee = fallbackFee;
        }

        public RoyaltyFee build() {
            return new RoyaltyFee(this.exchangeValueFraction, this.fallbackFee);
        }

        public Builder exchangeValueFraction(@Nullable Fraction exchangeValueFraction) {
            this.exchangeValueFraction = exchangeValueFraction;
            return this;
        }

        public Builder exchangeValueFraction(Fraction.Builder builder) {
            this.exchangeValueFraction = builder.build();
            return this;
        }

        public Builder fallbackFee(@Nullable FixedFee fallbackFee) {
            this.fallbackFee = fallbackFee;
            return this;
        }

        public Builder fallbackFee(FixedFee.Builder builder) {
            this.fallbackFee = builder.build();
            return this;
        }
    }
}

