/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.transaction.codec.SignedTransactionJsonCodec;
import com.hedera.hapi.node.transaction.codec.SignedTransactionProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record SignedTransaction(@NonNull Bytes bodyBytes, @Nullable SignatureMap sigMap) {
    public static final Codec<SignedTransaction> PROTOBUF = new SignedTransactionProtoCodec();
    public static final JsonCodec<SignedTransaction> JSON = new SignedTransactionJsonCodec();
    public static final SignedTransaction DEFAULT = SignedTransaction.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.bodyBytes != null && !this.bodyBytes.equals((Object)SignedTransaction.DEFAULT.bodyBytes)) {
            result = 31 * result + this.bodyBytes.hashCode();
        }
        if (this.sigMap != null && !this.sigMap.equals(SignedTransaction.DEFAULT.sigMap)) {
            result = 31 * result + this.sigMap.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SignedTransaction thatObj = (SignedTransaction)that;
        if (this.bodyBytes == null && thatObj.bodyBytes != null) {
            return false;
        }
        if (this.bodyBytes != null && !this.bodyBytes.equals((Object)thatObj.bodyBytes)) {
            return false;
        }
        if (this.sigMap == null && thatObj.sigMap != null) {
            return false;
        }
        return this.sigMap == null || this.sigMap.equals(thatObj.sigMap);
    }

    public boolean hasSigMap() {
        return this.sigMap != null;
    }

    public SignatureMap sigMapOrElse(@NonNull SignatureMap defaultValue) {
        return this.hasSigMap() ? this.sigMap : defaultValue;
    }

    @NonNull
    public SignatureMap sigMapOrThrow() {
        return Objects.requireNonNull(this.sigMap, "Field sigMap is null");
    }

    public void ifSigMap(@NonNull Consumer<SignatureMap> ifPresent) {
        if (this.hasSigMap()) {
            ifPresent.accept(this.sigMap);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.bodyBytes, this.sigMap);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @NonNull
        private Bytes bodyBytes = Bytes.EMPTY;
        @Nullable
        private SignatureMap sigMap = null;

        public Builder() {
        }

        public Builder(Bytes bodyBytes, SignatureMap sigMap) {
            this.bodyBytes = bodyBytes;
            this.sigMap = sigMap;
        }

        public SignedTransaction build() {
            return new SignedTransaction(this.bodyBytes, this.sigMap);
        }

        public Builder bodyBytes(@NonNull Bytes bodyBytes) {
            this.bodyBytes = bodyBytes != null ? bodyBytes : Bytes.EMPTY;
            return this;
        }

        public Builder sigMap(@Nullable SignatureMap sigMap) {
            this.sigMap = sigMap;
            return this;
        }

        public Builder sigMap(SignatureMap.Builder builder) {
            this.sigMap = builder.build();
            return this;
        }
    }
}

