/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.codec.TransactionRecordJsonCodec;
import com.hedera.hapi.node.transaction.codec.TransactionRecordProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TransactionRecord(@Nullable TransactionReceipt receipt, @NonNull Bytes transactionHash, @Nullable Timestamp consensusTimestamp, @Nullable TransactionID transactionID, String memo, long transactionFee, OneOf<BodyOneOfType> body, @Nullable TransferList transferList, @Nullable List<TokenTransferList> tokenTransferLists, @Nullable ScheduleID scheduleRef, @Nullable List<AssessedCustomFee> assessedCustomFees, @Nullable List<TokenAssociation> automaticTokenAssociations, @Nullable Timestamp parentConsensusTimestamp, @NonNull Bytes alias, @NonNull Bytes ethereumHash, @Nullable List<AccountAmount> paidStakingRewards, OneOf<EntropyOneOfType> entropy, @NonNull Bytes evmAddress) {
    public static final Codec<TransactionRecord> PROTOBUF = new TransactionRecordProtoCodec();
    public static final JsonCodec<TransactionRecord> JSON = new TransactionRecordJsonCodec();
    public static final TransactionRecord DEFAULT = TransactionRecord.newBuilder().build();

    public TransactionRecord {
        if (body == null) {
            throw new NullPointerException("Parameter 'body' must be supplied and can not be null");
        }
        if (entropy == null) {
            throw new NullPointerException("Parameter 'entropy' must be supplied and can not be null");
        }
    }

    @Override
    public int hashCode() {
        List<AccountAmount> list;
        List<TokenAssociation> list2;
        List<AssessedCustomFee> list$assessedCustomFees;
        List<TokenTransferList> list$tokenTransferLists;
        int result = 1;
        if (this.receipt != null && !this.receipt.equals(TransactionRecord.DEFAULT.receipt)) {
            result = 31 * result + this.receipt.hashCode();
        }
        if (this.transactionHash != null && !this.transactionHash.equals((Object)TransactionRecord.DEFAULT.transactionHash)) {
            result = 31 * result + this.transactionHash.hashCode();
        }
        if (this.consensusTimestamp != null && !this.consensusTimestamp.equals(TransactionRecord.DEFAULT.consensusTimestamp)) {
            result = 31 * result + this.consensusTimestamp.hashCode();
        }
        if (this.transactionID != null && !this.transactionID.equals(TransactionRecord.DEFAULT.transactionID)) {
            result = 31 * result + this.transactionID.hashCode();
        }
        if (this.memo != null && !this.memo.equals(TransactionRecord.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.transactionFee != TransactionRecord.DEFAULT.transactionFee) {
            result = 31 * result + Long.hashCode(this.transactionFee);
        }
        if (this.body != null && !this.body.equals(TransactionRecord.DEFAULT.body)) {
            result = 31 * result + this.body.hashCode();
        }
        if (this.transferList != null && !this.transferList.equals(TransactionRecord.DEFAULT.transferList)) {
            result = 31 * result + this.transferList.hashCode();
        }
        if ((list$tokenTransferLists = this.tokenTransferLists) != null) {
            for (TokenTransferList tokenTransferList : list$tokenTransferLists) {
                if (tokenTransferList != null) {
                    result = 31 * result + ((Object)tokenTransferList).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.scheduleRef != null && !this.scheduleRef.equals(TransactionRecord.DEFAULT.scheduleRef)) {
            result = 31 * result + this.scheduleRef.hashCode();
        }
        if ((list$assessedCustomFees = this.assessedCustomFees) != null) {
            for (AssessedCustomFee assessedCustomFee : list$assessedCustomFees) {
                if (assessedCustomFee != null) {
                    result = 31 * result + ((Object)assessedCustomFee).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if ((list2 = this.automaticTokenAssociations) != null) {
            for (TokenAssociation tokenAssociation : list2) {
                if (tokenAssociation != null) {
                    result = 31 * result + ((Object)tokenAssociation).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.parentConsensusTimestamp != null && !this.parentConsensusTimestamp.equals(TransactionRecord.DEFAULT.parentConsensusTimestamp)) {
            result = 31 * result + this.parentConsensusTimestamp.hashCode();
        }
        if (this.alias != null && !this.alias.equals((Object)TransactionRecord.DEFAULT.alias)) {
            result = 31 * result + this.alias.hashCode();
        }
        if (this.ethereumHash != null && !this.ethereumHash.equals((Object)TransactionRecord.DEFAULT.ethereumHash)) {
            result = 31 * result + this.ethereumHash.hashCode();
        }
        if ((list = this.paidStakingRewards) != null) {
            for (AccountAmount accountAmount : list) {
                if (accountAmount != null) {
                    result = 31 * result + ((Object)accountAmount).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.entropy != null && !this.entropy.equals(TransactionRecord.DEFAULT.entropy)) {
            result = 31 * result + this.entropy.hashCode();
        }
        if (this.evmAddress != null && !this.evmAddress.equals((Object)TransactionRecord.DEFAULT.evmAddress)) {
            result = 31 * result + this.evmAddress.hashCode();
        }
        long l = result;
        l += l << 30;
        l ^= l >>> 27;
        l += l << 16;
        l ^= l >>> 20;
        l += l << 5;
        l ^= l >>> 18;
        l += l << 10;
        l ^= l >>> 24;
        l += l << 30;
        return (int)l;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransactionRecord thatObj = (TransactionRecord)that;
        if (this.receipt == null && thatObj.receipt != null) {
            return false;
        }
        if (this.receipt != null && !this.receipt.equals(thatObj.receipt)) {
            return false;
        }
        if (this.transactionHash == null && thatObj.transactionHash != null) {
            return false;
        }
        if (this.transactionHash != null && !this.transactionHash.equals((Object)thatObj.transactionHash)) {
            return false;
        }
        if (this.consensusTimestamp == null && thatObj.consensusTimestamp != null) {
            return false;
        }
        if (this.consensusTimestamp != null && !this.consensusTimestamp.equals(thatObj.consensusTimestamp)) {
            return false;
        }
        if (this.transactionID == null && thatObj.transactionID != null) {
            return false;
        }
        if (this.transactionID != null && !this.transactionID.equals(thatObj.transactionID)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.transactionFee != thatObj.transactionFee) {
            return false;
        }
        if (this.body == null && thatObj.body != null) {
            return false;
        }
        if (this.body != null && !this.body.equals(thatObj.body)) {
            return false;
        }
        if (this.transferList == null && thatObj.transferList != null) {
            return false;
        }
        if (this.transferList != null && !this.transferList.equals(thatObj.transferList)) {
            return false;
        }
        if (this.tokenTransferLists == null && thatObj.tokenTransferLists != null) {
            return false;
        }
        if (this.tokenTransferLists != null && !this.tokenTransferLists.equals(thatObj.tokenTransferLists)) {
            return false;
        }
        if (this.scheduleRef == null && thatObj.scheduleRef != null) {
            return false;
        }
        if (this.scheduleRef != null && !this.scheduleRef.equals(thatObj.scheduleRef)) {
            return false;
        }
        if (this.assessedCustomFees == null && thatObj.assessedCustomFees != null) {
            return false;
        }
        if (this.assessedCustomFees != null && !this.assessedCustomFees.equals(thatObj.assessedCustomFees)) {
            return false;
        }
        if (this.automaticTokenAssociations == null && thatObj.automaticTokenAssociations != null) {
            return false;
        }
        if (this.automaticTokenAssociations != null && !this.automaticTokenAssociations.equals(thatObj.automaticTokenAssociations)) {
            return false;
        }
        if (this.parentConsensusTimestamp == null && thatObj.parentConsensusTimestamp != null) {
            return false;
        }
        if (this.parentConsensusTimestamp != null && !this.parentConsensusTimestamp.equals(thatObj.parentConsensusTimestamp)) {
            return false;
        }
        if (this.alias == null && thatObj.alias != null) {
            return false;
        }
        if (this.alias != null && !this.alias.equals((Object)thatObj.alias)) {
            return false;
        }
        if (this.ethereumHash == null && thatObj.ethereumHash != null) {
            return false;
        }
        if (this.ethereumHash != null && !this.ethereumHash.equals((Object)thatObj.ethereumHash)) {
            return false;
        }
        if (this.paidStakingRewards == null && thatObj.paidStakingRewards != null) {
            return false;
        }
        if (this.paidStakingRewards != null && !this.paidStakingRewards.equals(thatObj.paidStakingRewards)) {
            return false;
        }
        if (this.entropy == null && thatObj.entropy != null) {
            return false;
        }
        if (this.entropy != null && !this.entropy.equals(thatObj.entropy)) {
            return false;
        }
        if (this.evmAddress == null && thatObj.evmAddress != null) {
            return false;
        }
        return this.evmAddress == null || this.evmAddress.equals((Object)thatObj.evmAddress);
    }

    public boolean hasReceipt() {
        return this.receipt != null;
    }

    public TransactionReceipt receiptOrElse(@NonNull TransactionReceipt defaultValue) {
        return this.hasReceipt() ? this.receipt : defaultValue;
    }

    @NonNull
    public TransactionReceipt receiptOrThrow() {
        return Objects.requireNonNull(this.receipt, "Field receipt is null");
    }

    public void ifReceipt(@NonNull Consumer<TransactionReceipt> ifPresent) {
        if (this.hasReceipt()) {
            ifPresent.accept(this.receipt);
        }
    }

    public boolean hasConsensusTimestamp() {
        return this.consensusTimestamp != null;
    }

    public Timestamp consensusTimestampOrElse(@NonNull Timestamp defaultValue) {
        return this.hasConsensusTimestamp() ? this.consensusTimestamp : defaultValue;
    }

    @NonNull
    public Timestamp consensusTimestampOrThrow() {
        return Objects.requireNonNull(this.consensusTimestamp, "Field consensusTimestamp is null");
    }

    public void ifConsensusTimestamp(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasConsensusTimestamp()) {
            ifPresent.accept(this.consensusTimestamp);
        }
    }

    public boolean hasTransactionID() {
        return this.transactionID != null;
    }

    public TransactionID transactionIDOrElse(@NonNull TransactionID defaultValue) {
        return this.hasTransactionID() ? this.transactionID : defaultValue;
    }

    @NonNull
    public TransactionID transactionIDOrThrow() {
        return Objects.requireNonNull(this.transactionID, "Field transactionID is null");
    }

    public void ifTransactionID(@NonNull Consumer<TransactionID> ifPresent) {
        if (this.hasTransactionID()) {
            ifPresent.accept(this.transactionID);
        }
    }

    public boolean hasTransferList() {
        return this.transferList != null;
    }

    public TransferList transferListOrElse(@NonNull TransferList defaultValue) {
        return this.hasTransferList() ? this.transferList : defaultValue;
    }

    @NonNull
    public TransferList transferListOrThrow() {
        return Objects.requireNonNull(this.transferList, "Field transferList is null");
    }

    public void ifTransferList(@NonNull Consumer<TransferList> ifPresent) {
        if (this.hasTransferList()) {
            ifPresent.accept(this.transferList);
        }
    }

    public boolean hasTokenTransferLists() {
        return this.tokenTransferLists != null;
    }

    public List<TokenTransferList> tokenTransferListsOrElse(@NonNull List<TokenTransferList> defaultValue) {
        return this.hasTokenTransferLists() ? this.tokenTransferLists : defaultValue;
    }

    @NonNull
    public List<TokenTransferList> tokenTransferListsOrThrow() {
        return Objects.requireNonNull(this.tokenTransferLists, "Field tokenTransferLists is null");
    }

    public void ifTokenTransferLists(@NonNull Consumer<List<TokenTransferList>> ifPresent) {
        if (this.hasTokenTransferLists()) {
            ifPresent.accept(this.tokenTransferLists);
        }
    }

    public boolean hasScheduleRef() {
        return this.scheduleRef != null;
    }

    public ScheduleID scheduleRefOrElse(@NonNull ScheduleID defaultValue) {
        return this.hasScheduleRef() ? this.scheduleRef : defaultValue;
    }

    @NonNull
    public ScheduleID scheduleRefOrThrow() {
        return Objects.requireNonNull(this.scheduleRef, "Field scheduleRef is null");
    }

    public void ifScheduleRef(@NonNull Consumer<ScheduleID> ifPresent) {
        if (this.hasScheduleRef()) {
            ifPresent.accept(this.scheduleRef);
        }
    }

    public boolean hasAssessedCustomFees() {
        return this.assessedCustomFees != null;
    }

    public List<AssessedCustomFee> assessedCustomFeesOrElse(@NonNull List<AssessedCustomFee> defaultValue) {
        return this.hasAssessedCustomFees() ? this.assessedCustomFees : defaultValue;
    }

    @NonNull
    public List<AssessedCustomFee> assessedCustomFeesOrThrow() {
        return Objects.requireNonNull(this.assessedCustomFees, "Field assessedCustomFees is null");
    }

    public void ifAssessedCustomFees(@NonNull Consumer<List<AssessedCustomFee>> ifPresent) {
        if (this.hasAssessedCustomFees()) {
            ifPresent.accept(this.assessedCustomFees);
        }
    }

    public boolean hasAutomaticTokenAssociations() {
        return this.automaticTokenAssociations != null;
    }

    public List<TokenAssociation> automaticTokenAssociationsOrElse(@NonNull List<TokenAssociation> defaultValue) {
        return this.hasAutomaticTokenAssociations() ? this.automaticTokenAssociations : defaultValue;
    }

    @NonNull
    public List<TokenAssociation> automaticTokenAssociationsOrThrow() {
        return Objects.requireNonNull(this.automaticTokenAssociations, "Field automaticTokenAssociations is null");
    }

    public void ifAutomaticTokenAssociations(@NonNull Consumer<List<TokenAssociation>> ifPresent) {
        if (this.hasAutomaticTokenAssociations()) {
            ifPresent.accept(this.automaticTokenAssociations);
        }
    }

    public boolean hasParentConsensusTimestamp() {
        return this.parentConsensusTimestamp != null;
    }

    public Timestamp parentConsensusTimestampOrElse(@NonNull Timestamp defaultValue) {
        return this.hasParentConsensusTimestamp() ? this.parentConsensusTimestamp : defaultValue;
    }

    @NonNull
    public Timestamp parentConsensusTimestampOrThrow() {
        return Objects.requireNonNull(this.parentConsensusTimestamp, "Field parentConsensusTimestamp is null");
    }

    public void ifParentConsensusTimestamp(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasParentConsensusTimestamp()) {
            ifPresent.accept(this.parentConsensusTimestamp);
        }
    }

    public boolean hasPaidStakingRewards() {
        return this.paidStakingRewards != null;
    }

    public List<AccountAmount> paidStakingRewardsOrElse(@NonNull List<AccountAmount> defaultValue) {
        return this.hasPaidStakingRewards() ? this.paidStakingRewards : defaultValue;
    }

    @NonNull
    public List<AccountAmount> paidStakingRewardsOrThrow() {
        return Objects.requireNonNull(this.paidStakingRewards, "Field paidStakingRewards is null");
    }

    public void ifPaidStakingRewards(@NonNull Consumer<List<AccountAmount>> ifPresent) {
        if (this.hasPaidStakingRewards()) {
            ifPresent.accept(this.paidStakingRewards);
        }
    }

    @Nullable
    public ContractFunctionResult contractCallResult() {
        return this.body.kind() == BodyOneOfType.CONTRACT_CALL_RESULT ? (ContractFunctionResult)this.body.value() : null;
    }

    public boolean hasContractCallResult() {
        return this.body.kind() == BodyOneOfType.CONTRACT_CALL_RESULT;
    }

    public ContractFunctionResult contractCallResultOrElse(@NonNull ContractFunctionResult defaultValue) {
        return this.hasContractCallResult() ? this.contractCallResult() : defaultValue;
    }

    @NonNull
    public ContractFunctionResult contractCallResultOrThrow() {
        return Objects.requireNonNull(this.contractCallResult(), "Field contractCallResult is null");
    }

    @Nullable
    public ContractFunctionResult contractCreateResult() {
        return this.body.kind() == BodyOneOfType.CONTRACT_CREATE_RESULT ? (ContractFunctionResult)this.body.value() : null;
    }

    public boolean hasContractCreateResult() {
        return this.body.kind() == BodyOneOfType.CONTRACT_CREATE_RESULT;
    }

    public ContractFunctionResult contractCreateResultOrElse(@NonNull ContractFunctionResult defaultValue) {
        return this.hasContractCreateResult() ? this.contractCreateResult() : defaultValue;
    }

    @NonNull
    public ContractFunctionResult contractCreateResultOrThrow() {
        return Objects.requireNonNull(this.contractCreateResult(), "Field contractCreateResult is null");
    }

    @Nullable
    public Bytes prngBytes() {
        return this.entropy.kind() == EntropyOneOfType.PRNG_BYTES ? (Bytes)this.entropy.value() : null;
    }

    public boolean hasPrngBytes() {
        return this.entropy.kind() == EntropyOneOfType.PRNG_BYTES;
    }

    public Bytes prngBytesOrElse(@NonNull Bytes defaultValue) {
        return this.hasPrngBytes() ? this.prngBytes() : defaultValue;
    }

    @NonNull
    public Bytes prngBytesOrThrow() {
        return Objects.requireNonNull(this.prngBytes(), "Field prngBytes is null");
    }

    @Nullable
    public Integer prngNumber() {
        return this.entropy.kind() == EntropyOneOfType.PRNG_NUMBER ? (Integer)this.entropy.value() : null;
    }

    public boolean hasPrngNumber() {
        return this.entropy.kind() == EntropyOneOfType.PRNG_NUMBER;
    }

    public Integer prngNumberOrElse(@NonNull Integer defaultValue) {
        return this.hasPrngNumber() ? this.prngNumber() : defaultValue;
    }

    @NonNull
    public Integer prngNumberOrThrow() {
        return Objects.requireNonNull(this.prngNumber(), "Field prngNumber is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.receipt, this.transactionHash, this.consensusTimestamp, this.transactionID, this.memo, this.transactionFee, this.body, this.transferList, this.tokenTransferLists, this.scheduleRef, this.assessedCustomFees, this.automaticTokenAssociations, this.parentConsensusTimestamp, this.alias, this.ethereumHash, this.paidStakingRewards, this.entropy, this.evmAddress);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum BodyOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        CONTRACT_CALL_RESULT(7, "contractCallResult"),
        CONTRACT_CREATE_RESULT(8, "contractCreateResult");

        private final int protoOrdinal;
        private final String protoName;

        private BodyOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static BodyOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 7 -> CONTRACT_CALL_RESULT;
                case 8 -> CONTRACT_CREATE_RESULT;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static BodyOneOfType fromString(String name) {
            return switch (name) {
                case "contractCallResult", "CONTRACT_CALL_RESULT" -> CONTRACT_CALL_RESULT;
                case "contractCreateResult", "CONTRACT_CREATE_RESULT" -> CONTRACT_CREATE_RESULT;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static enum EntropyOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        PRNG_BYTES(19, "prng_bytes"),
        PRNG_NUMBER(20, "prng_number");

        private final int protoOrdinal;
        private final String protoName;

        private EntropyOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static EntropyOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 19 -> PRNG_BYTES;
                case 20 -> PRNG_NUMBER;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static EntropyOneOfType fromString(String name) {
            return switch (name) {
                case "prng_bytes", "PRNG_BYTES" -> PRNG_BYTES;
                case "prng_number", "PRNG_NUMBER" -> PRNG_NUMBER;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        @Nullable
        private TransactionReceipt receipt = null;
        @NonNull
        private Bytes transactionHash = Bytes.EMPTY;
        @Nullable
        private Timestamp consensusTimestamp = null;
        @Nullable
        private TransactionID transactionID = null;
        private String memo = "";
        private long transactionFee = 0L;
        private OneOf<BodyOneOfType> body = TransactionRecordProtoCodec.BODY_UNSET;
        @Nullable
        private TransferList transferList = null;
        @Nullable
        private List<TokenTransferList> tokenTransferLists = Collections.emptyList();
        @Nullable
        private ScheduleID scheduleRef = null;
        @Nullable
        private List<AssessedCustomFee> assessedCustomFees = Collections.emptyList();
        @Nullable
        private List<TokenAssociation> automaticTokenAssociations = Collections.emptyList();
        @Nullable
        private Timestamp parentConsensusTimestamp = null;
        @NonNull
        private Bytes alias = Bytes.EMPTY;
        @NonNull
        private Bytes ethereumHash = Bytes.EMPTY;
        @Nullable
        private List<AccountAmount> paidStakingRewards = Collections.emptyList();
        private OneOf<EntropyOneOfType> entropy = TransactionRecordProtoCodec.ENTROPY_UNSET;
        @NonNull
        private Bytes evmAddress = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(TransactionReceipt receipt, Bytes transactionHash, Timestamp consensusTimestamp, TransactionID transactionID, String memo, long transactionFee, OneOf<BodyOneOfType> body, TransferList transferList, List<TokenTransferList> tokenTransferLists, ScheduleID scheduleRef, List<AssessedCustomFee> assessedCustomFees, List<TokenAssociation> automaticTokenAssociations, Timestamp parentConsensusTimestamp, Bytes alias, Bytes ethereumHash, List<AccountAmount> paidStakingRewards, OneOf<EntropyOneOfType> entropy, Bytes evmAddress) {
            this.receipt = receipt;
            this.transactionHash = transactionHash;
            this.consensusTimestamp = consensusTimestamp;
            this.transactionID = transactionID;
            this.memo = memo;
            this.transactionFee = transactionFee;
            this.body = body;
            this.transferList = transferList;
            this.tokenTransferLists = tokenTransferLists;
            this.scheduleRef = scheduleRef;
            this.assessedCustomFees = assessedCustomFees;
            this.automaticTokenAssociations = automaticTokenAssociations;
            this.parentConsensusTimestamp = parentConsensusTimestamp;
            this.alias = alias;
            this.ethereumHash = ethereumHash;
            this.paidStakingRewards = paidStakingRewards;
            this.entropy = entropy;
            this.evmAddress = evmAddress;
        }

        public TransactionRecord build() {
            return new TransactionRecord(this.receipt, this.transactionHash, this.consensusTimestamp, this.transactionID, this.memo, this.transactionFee, this.body, this.transferList, this.tokenTransferLists, this.scheduleRef, this.assessedCustomFees, this.automaticTokenAssociations, this.parentConsensusTimestamp, this.alias, this.ethereumHash, this.paidStakingRewards, this.entropy, this.evmAddress);
        }

        public Builder receipt(@Nullable TransactionReceipt receipt) {
            this.receipt = receipt;
            return this;
        }

        public Builder receipt(TransactionReceipt.Builder builder) {
            this.receipt = builder.build();
            return this;
        }

        public Builder transactionHash(@NonNull Bytes transactionHash) {
            this.transactionHash = transactionHash != null ? transactionHash : Bytes.EMPTY;
            return this;
        }

        public Builder consensusTimestamp(@Nullable Timestamp consensusTimestamp) {
            this.consensusTimestamp = consensusTimestamp;
            return this;
        }

        public Builder consensusTimestamp(Timestamp.Builder builder) {
            this.consensusTimestamp = builder.build();
            return this;
        }

        public Builder transactionID(@Nullable TransactionID transactionID) {
            this.transactionID = transactionID;
            return this;
        }

        public Builder transactionID(TransactionID.Builder builder) {
            this.transactionID = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder transactionFee(long transactionFee) {
            this.transactionFee = transactionFee;
            return this;
        }

        public Builder contractCallResult(@Nullable ContractFunctionResult contractCallResult) {
            this.body = new OneOf((Enum)BodyOneOfType.CONTRACT_CALL_RESULT, (Object)contractCallResult);
            return this;
        }

        public Builder contractCallResult(ContractFunctionResult.Builder builder) {
            this.body = new OneOf((Enum)BodyOneOfType.CONTRACT_CALL_RESULT, (Object)builder.build());
            return this;
        }

        public Builder contractCreateResult(@Nullable ContractFunctionResult contractCreateResult) {
            this.body = new OneOf((Enum)BodyOneOfType.CONTRACT_CREATE_RESULT, (Object)contractCreateResult);
            return this;
        }

        public Builder contractCreateResult(ContractFunctionResult.Builder builder) {
            this.body = new OneOf((Enum)BodyOneOfType.CONTRACT_CREATE_RESULT, (Object)builder.build());
            return this;
        }

        public Builder transferList(@Nullable TransferList transferList) {
            this.transferList = transferList;
            return this;
        }

        public Builder transferList(TransferList.Builder builder) {
            this.transferList = builder.build();
            return this;
        }

        public Builder tokenTransferLists(@Nullable List<TokenTransferList> tokenTransferLists) {
            this.tokenTransferLists = tokenTransferLists;
            return this;
        }

        public Builder tokenTransferLists(TokenTransferList ... values) {
            this.tokenTransferLists = List.of(values);
            return this;
        }

        public Builder scheduleRef(@Nullable ScheduleID scheduleRef) {
            this.scheduleRef = scheduleRef;
            return this;
        }

        public Builder scheduleRef(ScheduleID.Builder builder) {
            this.scheduleRef = builder.build();
            return this;
        }

        public Builder assessedCustomFees(@Nullable List<AssessedCustomFee> assessedCustomFees) {
            this.assessedCustomFees = assessedCustomFees;
            return this;
        }

        public Builder assessedCustomFees(AssessedCustomFee ... values) {
            this.assessedCustomFees = List.of(values);
            return this;
        }

        public Builder automaticTokenAssociations(@Nullable List<TokenAssociation> automaticTokenAssociations) {
            this.automaticTokenAssociations = automaticTokenAssociations;
            return this;
        }

        public Builder automaticTokenAssociations(TokenAssociation ... values) {
            this.automaticTokenAssociations = List.of(values);
            return this;
        }

        public Builder parentConsensusTimestamp(@Nullable Timestamp parentConsensusTimestamp) {
            this.parentConsensusTimestamp = parentConsensusTimestamp;
            return this;
        }

        public Builder parentConsensusTimestamp(Timestamp.Builder builder) {
            this.parentConsensusTimestamp = builder.build();
            return this;
        }

        public Builder alias(@NonNull Bytes alias) {
            this.alias = alias != null ? alias : Bytes.EMPTY;
            return this;
        }

        public Builder ethereumHash(@NonNull Bytes ethereumHash) {
            this.ethereumHash = ethereumHash != null ? ethereumHash : Bytes.EMPTY;
            return this;
        }

        public Builder paidStakingRewards(@Nullable List<AccountAmount> paidStakingRewards) {
            this.paidStakingRewards = paidStakingRewards;
            return this;
        }

        public Builder paidStakingRewards(AccountAmount ... values) {
            this.paidStakingRewards = List.of(values);
            return this;
        }

        public Builder prngBytes(@NonNull Bytes prngBytes) {
            this.entropy = new OneOf((Enum)EntropyOneOfType.PRNG_BYTES, (Object)prngBytes);
            return this;
        }

        public Builder prngNumber(int prngNumber) {
            this.entropy = new OneOf((Enum)EntropyOneOfType.PRNG_NUMBER, (Object)prngNumber);
            return this;
        }

        public Builder evmAddress(@NonNull Bytes evmAddress) {
            this.evmAddress = evmAddress != null ? evmAddress : Bytes.EMPTY;
            return this;
        }
    }
}

