/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.schema.ExchangeRateSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class ExchangeRateProtoCodec
implements Codec<ExchangeRate> {
    @NonNull
    public ExchangeRate parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ExchangeRate parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ExchangeRate data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)ExchangeRateSchema.HBAR_EQUIV, (int)data.hbarEquiv());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)ExchangeRateSchema.CENT_EQUIV, (int)data.centEquiv());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ExchangeRateSchema.EXPIRATION_TIME, (Object)data.expirationTime(), (arg_0, arg_1) -> TimestampSeconds.PROTOBUF.write(arg_0, arg_1), arg_0 -> TimestampSeconds.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ExchangeRate data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ExchangeRateSchema.HBAR_EQUIV, (int)data.hbarEquiv());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)ExchangeRateSchema.CENT_EQUIV, (int)data.centEquiv());
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ExchangeRateSchema.EXPIRATION_TIME, (Object)data.expirationTime(), arg_0 -> TimestampSeconds.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ExchangeRate item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NonNull
    private ExchangeRate parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            temp_hbarEquiv = 0;
            temp_centEquiv = 0;
            temp_expirationTime = null;
            block12: while (input.hasRemaining()) {
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                field = tag >>> 3;
                f = ExchangeRateSchema.getField(field);
                switch (tag) {
                    case 8: {
                        temp_hbarEquiv = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block12;
                    }
                    case 16: {
                        temp_centEquiv = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block12;
                    }
                    case 26: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl25
                        value = TimestampSeconds.DEFAULT;
                        ** GOTO lbl38
lbl25:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value = strictMode != false ? (TimestampSeconds)TimestampSeconds.PROTOBUF.parseStrict(input) : (TimestampSeconds)TimestampSeconds.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl38:
                        // 2 sources

                        temp_expirationTime = value;
                        continue block12;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new ExchangeRate(temp_hbarEquiv, temp_centEquiv, temp_expirationTime);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

