/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.transaction.NodeStake;
import com.hedera.hapi.node.transaction.schema.NodeStakeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class NodeStakeProtoCodec
implements Codec<NodeStake> {
    @NonNull
    public NodeStake parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public NodeStake parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull NodeStake data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeSchema.MAX_STAKE, (long)data.maxStake());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeSchema.MIN_STAKE, (long)data.minStake());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeSchema.NODE_ID, (long)data.nodeId());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeSchema.REWARD_RATE, (long)data.rewardRate());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeSchema.STAKE, (long)data.stake());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeSchema.STAKE_NOT_REWARDED, (long)data.stakeNotRewarded());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeSchema.STAKE_REWARDED, (long)data.stakeRewarded());
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(NodeStake data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeSchema.MAX_STAKE, (long)data.maxStake());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeSchema.MIN_STAKE, (long)data.minStake());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeSchema.NODE_ID, (long)data.nodeId());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeSchema.REWARD_RATE, (long)data.rewardRate());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeSchema.STAKE, (long)data.stake());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeSchema.STAKE_NOT_REWARDED, (long)data.stakeNotRewarded());
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeSchema.STAKE_REWARDED, (long)data.stakeRewarded());
    }

    public boolean fastEquals(@NonNull NodeStake item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    @NonNull
    private NodeStake parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            long temp_max_stake = 0L;
            long temp_min_stake = 0L;
            long temp_node_id = 0L;
            long temp_reward_rate = 0L;
            long temp_stake = 0L;
            long temp_stake_not_rewarded = 0L;
            long temp_stake_rewarded = 0L;
            block13: while (input.hasRemaining()) {
                int tag;
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                int field = tag >>> 3;
                FieldDefinition f = NodeStakeSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_max_stake = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block13;
                    }
                    case 16: {
                        long value;
                        temp_min_stake = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block13;
                    }
                    case 24: {
                        long value;
                        temp_node_id = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block13;
                    }
                    case 32: {
                        long value;
                        temp_reward_rate = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block13;
                    }
                    case 40: {
                        long value;
                        temp_stake = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block13;
                    }
                    case 48: {
                        long value;
                        temp_stake_not_rewarded = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block13;
                    }
                    case 56: {
                        long value;
                        temp_stake_rewarded = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block13;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new NodeStake(temp_max_stake, temp_min_stake, temp_node_id, temp_reward_rate, temp_stake, temp_stake_not_rewarded, temp_stake_rewarded);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

