/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.transaction.ThrottleBucket;
import com.hedera.hapi.node.transaction.ThrottleGroup;
import com.hedera.hapi.node.transaction.schema.ThrottleBucketSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Collections;

public final class ThrottleBucketProtoCodec
implements Codec<ThrottleBucket> {
    @NonNull
    public ThrottleBucket parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ThrottleBucket parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ThrottleBucket data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)ThrottleBucketSchema.NAME, (String)data.name());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ThrottleBucketSchema.BURST_PERIOD_MS, (long)data.burstPeriodMs());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)ThrottleBucketSchema.THROTTLE_GROUPS, data.throttleGroups(), (arg_0, arg_1) -> ThrottleGroup.PROTOBUF.write(arg_0, arg_1), arg_0 -> ThrottleGroup.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ThrottleBucket data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfString((FieldDefinition)ThrottleBucketSchema.NAME, (String)data.name());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ThrottleBucketSchema.BURST_PERIOD_MS, (long)data.burstPeriodMs());
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ThrottleBucketSchema.THROTTLE_GROUPS, data.throttleGroups(), arg_0 -> ThrottleGroup.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ThrottleBucket item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NonNull
    private ThrottleBucket parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            temp_name = "";
            temp_burstPeriodMs = 0L;
            temp_throttleGroups = Collections.emptyList();
            block12: while (input.hasRemaining()) {
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                field = tag >>> 3;
                f = ThrottleBucketSchema.getField(field);
                switch (tag) {
                    case 10: {
                        temp_name = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block12;
                    }
                    case 16: {
                        temp_burstPeriodMs = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block12;
                    }
                    case 26: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl25
                        value = ThrottleGroup.DEFAULT;
                        ** GOTO lbl38
lbl25:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value = strictMode != false ? (ThrottleGroup)ThrottleGroup.PROTOBUF.parseStrict(input) : (ThrottleGroup)ThrottleGroup.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl38:
                        // 2 sources

                        temp_throttleGroups = ProtoParserTools.addToList(temp_throttleGroups, (Object)value);
                        continue block12;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new ThrottleBucket(temp_name, temp_burstPeriodMs, temp_throttleGroups);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

