/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.ThrottleGroup;
import com.hedera.hapi.node.transaction.schema.ThrottleGroupSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.List;

public final class ThrottleGroupProtoCodec
implements Codec<ThrottleGroup> {
    @NonNull
    public ThrottleGroup parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ThrottleGroup parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ThrottleGroup data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeEnumList((WritableSequentialData)out, (FieldDefinition)ThrottleGroupSchema.OPERATIONS, data.operations());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ThrottleGroupSchema.MILLI_OPS_PER_SEC, (long)data.milliOpsPerSec());
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ThrottleGroup data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfEnumList((FieldDefinition)ThrottleGroupSchema.OPERATIONS, data.operations());
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)ThrottleGroupSchema.MILLI_OPS_PER_SEC, (long)data.milliOpsPerSec());
    }

    public boolean fastEquals(@NonNull ThrottleGroup item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    @NonNull
    private ThrottleGroup parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            List temp_operations = Collections.emptyList();
            long temp_milliOpsPerSec = 0L;
            block9: while (input.hasRemaining()) {
                int tag;
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                int field = tag >>> 3;
                FieldDefinition f = ThrottleGroupSchema.getField(field);
                switch (tag) {
                    case 8: {
                        HederaFunctionality value = HederaFunctionality.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        temp_operations = ProtoParserTools.addToList(temp_operations, (Object)((Object)value));
                        break;
                    }
                    case 10: {
                        long length = input.readVarInt(false);
                        if (input.remaining() < length) {
                            throw new BufferUnderflowException();
                        }
                        long beforeLimit = input.limit();
                        long beforePosition = input.position();
                        input.limit(input.position() + length);
                        while (input.hasRemaining()) {
                            temp_operations = ProtoParserTools.addToList((List)temp_operations, (Object)((Object)HederaFunctionality.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input))));
                        }
                        input.limit(beforeLimit);
                        if (input.position() == beforePosition + length) continue block9;
                        throw new BufferUnderflowException();
                    }
                    case 16: {
                        long value;
                        temp_milliOpsPerSec = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        break;
                    }
                    default: {
                        int wireType = tag & 7;
                        if (field == 0) {
                            throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                        }
                        if (wireType > 5) {
                            throw new IOException("Cannot understand wire_type of " + wireType);
                        }
                        if (f == null) {
                            if (strictMode) {
                                throw new UnknownFieldException(field);
                            }
                            ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                            break;
                        }
                        throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                    }
                }
            }
            return new ThrottleGroup(temp_operations, temp_milliOpsPerSec);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

