/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.schema.TransactionReceiptSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TransactionReceiptJsonCodec
implements JsonCodec<TransactionReceipt> {
    @NonNull
    public TransactionReceipt parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            ResponseCodeEnum temp_status = ResponseCodeEnum.values()[0];
            AccountID temp_accountID = null;
            FileID temp_fileID = null;
            ContractID temp_contractID = null;
            ExchangeRateSet temp_exchangeRate = null;
            TopicID temp_topicID = null;
            long temp_topicSequenceNumber = 0L;
            Bytes temp_topicRunningHash = Bytes.EMPTY;
            long temp_topicRunningHashVersion = 0L;
            TokenID temp_tokenID = null;
            long temp_newTotalSupply = 0L;
            ScheduleID temp_scheduleID = null;
            TransactionID temp_scheduledTransactionID = null;
            List<Long> temp_serialNumbers = Collections.emptyList();
            block34: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "status": {
                        temp_status = ResponseCodeEnum.fromString(kvPair.value().STRING().getText());
                        continue block34;
                    }
                    case "accountID": {
                        temp_accountID = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block34;
                    }
                    case "fileID": {
                        temp_fileID = (FileID)FileID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block34;
                    }
                    case "contractID": {
                        temp_contractID = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block34;
                    }
                    case "exchangeRate": {
                        temp_exchangeRate = (ExchangeRateSet)ExchangeRateSet.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block34;
                    }
                    case "topicID": {
                        temp_topicID = (TopicID)TopicID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block34;
                    }
                    case "topicSequenceNumber": {
                        temp_topicSequenceNumber = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block34;
                    }
                    case "topicRunningHash": {
                        temp_topicRunningHash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block34;
                    }
                    case "topicRunningHashVersion": {
                        temp_topicRunningHashVersion = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block34;
                    }
                    case "tokenID": {
                        temp_tokenID = (TokenID)TokenID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block34;
                    }
                    case "newTotalSupply": {
                        temp_newTotalSupply = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block34;
                    }
                    case "scheduleID": {
                        temp_scheduleID = (ScheduleID)ScheduleID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block34;
                    }
                    case "scheduledTransactionID": {
                        temp_scheduledTransactionID = (TransactionID)TransactionID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block34;
                    }
                    case "serialNumbers": {
                        temp_serialNumbers = kvPair.value().arr().value().stream().map(v -> JsonTools.parseLong((JSONParser.ValueContext)v)).toList();
                        continue block34;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new TransactionReceipt(temp_status, temp_accountID, temp_fileID, temp_contractID, temp_exchangeRate, temp_topicID, temp_topicSequenceNumber, temp_topicRunningHash, temp_topicRunningHashVersion, temp_tokenID, temp_newTotalSupply, temp_scheduleID, temp_scheduledTransactionID, temp_serialNumbers);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull TransactionReceipt data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.status() != ResponseCodeEnum.values()[0]) {
            fieldLines.add(JsonTools.field((String)"status", (String)data.status().protoName()));
        }
        if (data.accountID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"accountID", AccountID.JSON, (Object)data.accountID()));
        }
        if (data.fileID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"fileID", FileID.JSON, (Object)data.fileID()));
        }
        if (data.contractID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractID", ContractID.JSON, (Object)data.contractID()));
        }
        if (data.exchangeRate() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"exchangeRate", ExchangeRateSet.JSON, (Object)data.exchangeRate()));
        }
        if (data.topicID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"topicID", TopicID.JSON, (Object)data.topicID()));
        }
        if (data.topicSequenceNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"topicSequenceNumber", (long)data.topicSequenceNumber()));
        }
        if (data.topicRunningHash() != Bytes.EMPTY && data.topicRunningHash() != null && data.topicRunningHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"topicRunningHash", (Bytes)data.topicRunningHash()));
        }
        if (data.topicRunningHashVersion() != 0L) {
            fieldLines.add(JsonTools.field((String)"topicRunningHashVersion", (long)data.topicRunningHashVersion()));
        }
        if (data.tokenID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"tokenID", TokenID.JSON, (Object)data.tokenID()));
        }
        if (data.newTotalSupply() != 0L) {
            fieldLines.add(JsonTools.field((String)"newTotalSupply", (long)data.newTotalSupply()));
        }
        if (data.scheduleID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"scheduleID", ScheduleID.JSON, (Object)data.scheduleID()));
        }
        if (data.scheduledTransactionID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"scheduledTransactionID", TransactionID.JSON, (Object)data.scheduledTransactionID()));
        }
        if (!data.serialNumbers().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"serialNumbers", (FieldDefinition)TransactionReceiptSchema.SERIAL_NUMBERS, data.serialNumbers()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

