/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.hapi.node.transaction.schema.TransactionRecordSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Collections;

public final class TransactionRecordProtoCodec
implements Codec<TransactionRecord> {
    public static final OneOf<TransactionRecord.BodyOneOfType> BODY_UNSET = new OneOf((Enum)TransactionRecord.BodyOneOfType.UNSET, null);
    public static final OneOf<TransactionRecord.EntropyOneOfType> ENTROPY_UNSET = new OneOf((Enum)TransactionRecord.EntropyOneOfType.UNSET, null);

    @NonNull
    public TransactionRecord parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TransactionRecord parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TransactionRecord data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.RECEIPT, (Object)data.receipt(), (arg_0, arg_1) -> TransactionReceipt.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransactionReceipt.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.TRANSACTION_HASH, (RandomAccessData)data.transactionHash());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.CONSENSUS_TIMESTAMP, (Object)data.consensusTimestamp(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.TRANSACTION_ID, (Object)data.transactionID(), (arg_0, arg_1) -> TransactionID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransactionID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.TRANSACTION_FEE, (long)data.transactionFee());
        if (data.body().kind() == TransactionRecord.BodyOneOfType.CONTRACT_CALL_RESULT) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.CONTRACT_CALL_RESULT, (Object)((ContractFunctionResult)data.body().as()), (arg_0, arg_1) -> ContractFunctionResult.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractFunctionResult.PROTOBUF.measureRecord(arg_0));
        }
        if (data.body().kind() == TransactionRecord.BodyOneOfType.CONTRACT_CREATE_RESULT) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.CONTRACT_CREATE_RESULT, (Object)((ContractFunctionResult)data.body().as()), (arg_0, arg_1) -> ContractFunctionResult.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractFunctionResult.PROTOBUF.measureRecord(arg_0));
        }
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.TRANSFER_LIST, (Object)data.transferList(), (arg_0, arg_1) -> TransferList.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransferList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.TOKEN_TRANSFER_LISTS, data.tokenTransferLists(), (arg_0, arg_1) -> TokenTransferList.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenTransferList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.SCHEDULE_REF, (Object)data.scheduleRef(), (arg_0, arg_1) -> ScheduleID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ScheduleID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.ASSESSED_CUSTOM_FEES, data.assessedCustomFees(), (arg_0, arg_1) -> AssessedCustomFee.PROTOBUF.write(arg_0, arg_1), arg_0 -> AssessedCustomFee.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.AUTOMATIC_TOKEN_ASSOCIATIONS, data.automaticTokenAssociations(), (arg_0, arg_1) -> TokenAssociation.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenAssociation.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.PARENT_CONSENSUS_TIMESTAMP, (Object)data.parentConsensusTimestamp(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.ALIAS, (RandomAccessData)data.alias());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.ETHEREUM_HASH, (RandomAccessData)data.ethereumHash());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.PAID_STAKING_REWARDS, data.paidStakingRewards(), (arg_0, arg_1) -> AccountAmount.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountAmount.PROTOBUF.measureRecord(arg_0));
        if (data.entropy().kind() == TransactionRecord.EntropyOneOfType.PRNG_BYTES) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.PRNG_BYTES, (RandomAccessData)((RandomAccessData)data.entropy().as()));
        }
        if (data.entropy().kind() == TransactionRecord.EntropyOneOfType.PRNG_NUMBER) {
            ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.PRNG_NUMBER, (int)((Integer)data.entropy().as()));
        }
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.EVM_ADDRESS, (RandomAccessData)data.evmAddress());
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TransactionRecord data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.RECEIPT, (Object)data.receipt(), arg_0 -> TransactionReceipt.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.TRANSACTION_HASH, (RandomAccessData)data.transactionHash());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.CONSENSUS_TIMESTAMP, (Object)data.consensusTimestamp(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.TRANSACTION_ID, (Object)data.transactionID(), arg_0 -> TransactionID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)TransactionRecordSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TransactionRecordSchema.TRANSACTION_FEE, (long)data.transactionFee());
        if (data.body().kind() == TransactionRecord.BodyOneOfType.CONTRACT_CALL_RESULT) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.CONTRACT_CALL_RESULT, (Object)((ContractFunctionResult)data.body().as()), arg_0 -> ContractFunctionResult.PROTOBUF.measureRecord(arg_0));
        }
        if (data.body().kind() == TransactionRecord.BodyOneOfType.CONTRACT_CREATE_RESULT) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.CONTRACT_CREATE_RESULT, (Object)((ContractFunctionResult)data.body().as()), arg_0 -> ContractFunctionResult.PROTOBUF.measureRecord(arg_0));
        }
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.TRANSFER_LIST, (Object)data.transferList(), arg_0 -> TransferList.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.TOKEN_TRANSFER_LISTS, data.tokenTransferLists(), arg_0 -> TokenTransferList.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.SCHEDULE_REF, (Object)data.scheduleRef(), arg_0 -> ScheduleID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.ASSESSED_CUSTOM_FEES, data.assessedCustomFees(), arg_0 -> AssessedCustomFee.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.AUTOMATIC_TOKEN_ASSOCIATIONS, data.automaticTokenAssociations(), arg_0 -> TokenAssociation.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.PARENT_CONSENSUS_TIMESTAMP, (Object)data.parentConsensusTimestamp(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.ALIAS, (RandomAccessData)data.alias());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.ETHEREUM_HASH, (RandomAccessData)data.ethereumHash());
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.PAID_STAKING_REWARDS, data.paidStakingRewards(), arg_0 -> AccountAmount.PROTOBUF.measureRecord(arg_0));
        if (data.entropy().kind() == TransactionRecord.EntropyOneOfType.PRNG_BYTES) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.PRNG_BYTES, (RandomAccessData)((RandomAccessData)data.entropy().as()));
        }
        if (data.entropy().kind() == TransactionRecord.EntropyOneOfType.PRNG_NUMBER) {
            size += ProtoWriterTools.sizeOfInteger((FieldDefinition)TransactionRecordSchema.PRNG_NUMBER, (int)((Integer)data.entropy().as()));
        }
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.EVM_ADDRESS, (RandomAccessData)data.evmAddress());
    }

    public boolean fastEquals(@NonNull TransactionRecord item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NonNull
    private TransactionRecord parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            temp_receipt /* !! */  = null;
            temp_transactionHash = Bytes.EMPTY;
            temp_consensusTimestamp /* !! */  = null;
            temp_transactionID /* !! */  = null;
            temp_memo = "";
            temp_transactionFee = 0L;
            temp_body = TransactionRecordProtoCodec.BODY_UNSET;
            temp_transferList /* !! */  = null;
            temp_tokenTransferLists = Collections.emptyList();
            temp_scheduleRef /* !! */  = null;
            temp_assessed_custom_fees = Collections.emptyList();
            temp_automatic_token_associations = Collections.emptyList();
            temp_parent_consensus_timestamp /* !! */  = null;
            temp_alias = Bytes.EMPTY;
            temp_ethereum_hash = Bytes.EMPTY;
            temp_paid_staking_rewards = Collections.emptyList();
            temp_entropy = TransactionRecordProtoCodec.ENTROPY_UNSET;
            temp_evm_address = Bytes.EMPTY;
            block62: while (input.hasRemaining()) {
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                field = tag >>> 3;
                f = TransactionRecordSchema.getField(field);
                switch (tag) {
                    case 10: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl34
                        value /* !! */  = TransactionReceipt.DEFAULT;
                        ** GOTO lbl47
lbl34:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value /* !! */  = strictMode != false ? (TransactionReceipt)TransactionReceipt.PROTOBUF.parseStrict(input) : (TransactionReceipt)TransactionReceipt.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl47:
                        // 2 sources

                        temp_receipt /* !! */  = value /* !! */ ;
                        continue block62;
                    }
                    case 18: {
                        temp_transactionHash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block62;
                    }
                    case 26: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl57
                        value /* !! */  = Timestamp.DEFAULT;
                        ** GOTO lbl70
lbl57:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v1 /* !! */  = value /* !! */  = strictMode != false ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl70:
                        // 2 sources

                        temp_consensusTimestamp /* !! */  = value /* !! */ ;
                        continue block62;
                    }
                    case 34: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl77
                        value /* !! */  = TransactionID.DEFAULT;
                        ** GOTO lbl90
lbl77:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v2 /* !! */  = value /* !! */  = strictMode != false ? (TransactionID)TransactionID.PROTOBUF.parseStrict(input) : (TransactionID)TransactionID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl90:
                        // 2 sources

                        temp_transactionID /* !! */  = value /* !! */ ;
                        continue block62;
                    }
                    case 42: {
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block62;
                    }
                    case 48: {
                        temp_transactionFee = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block62;
                    }
                    case 58: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl103
                        value /* !! */  = ContractFunctionResult.DEFAULT;
                        ** GOTO lbl116
lbl103:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v3 /* !! */  = value /* !! */  = strictMode != false ? (ContractFunctionResult)ContractFunctionResult.PROTOBUF.parseStrict(input) : (ContractFunctionResult)ContractFunctionResult.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl116:
                        // 2 sources

                        temp_body = new OneOf((Enum)TransactionRecord.BodyOneOfType.CONTRACT_CALL_RESULT, (Object)value /* !! */ );
                        continue block62;
                    }
                    case 66: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl123
                        value /* !! */  = ContractFunctionResult.DEFAULT;
                        ** GOTO lbl136
lbl123:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v4 /* !! */  = value /* !! */  = strictMode != false ? (ContractFunctionResult)ContractFunctionResult.PROTOBUF.parseStrict(input) : (ContractFunctionResult)ContractFunctionResult.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl136:
                        // 2 sources

                        temp_body = new OneOf((Enum)TransactionRecord.BodyOneOfType.CONTRACT_CREATE_RESULT, (Object)value /* !! */ );
                        continue block62;
                    }
                    case 82: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl143
                        value /* !! */  = TransferList.DEFAULT;
                        ** GOTO lbl156
lbl143:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v5 /* !! */  = value /* !! */  = strictMode != false ? (TransferList)TransferList.PROTOBUF.parseStrict(input) : (TransferList)TransferList.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl156:
                        // 2 sources

                        temp_transferList /* !! */  = value /* !! */ ;
                        continue block62;
                    }
                    case 90: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl163
                        value /* !! */  = TokenTransferList.DEFAULT;
                        ** GOTO lbl176
lbl163:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v6 /* !! */  = value /* !! */  = strictMode != false ? (TokenTransferList)TokenTransferList.PROTOBUF.parseStrict(input) : (TokenTransferList)TokenTransferList.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl176:
                        // 2 sources

                        temp_tokenTransferLists = ProtoParserTools.addToList(temp_tokenTransferLists, (Object)value /* !! */ );
                        continue block62;
                    }
                    case 98: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl183
                        value /* !! */  = ScheduleID.DEFAULT;
                        ** GOTO lbl196
lbl183:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v7 /* !! */  = value /* !! */  = strictMode != false ? (ScheduleID)ScheduleID.PROTOBUF.parseStrict(input) : (ScheduleID)ScheduleID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl196:
                        // 2 sources

                        temp_scheduleRef /* !! */  = value /* !! */ ;
                        continue block62;
                    }
                    case 106: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl203
                        value /* !! */  = AssessedCustomFee.DEFAULT;
                        ** GOTO lbl216
lbl203:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v8 /* !! */  = value /* !! */  = strictMode != false ? (AssessedCustomFee)AssessedCustomFee.PROTOBUF.parseStrict(input) : (AssessedCustomFee)AssessedCustomFee.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl216:
                        // 2 sources

                        temp_assessed_custom_fees = ProtoParserTools.addToList(temp_assessed_custom_fees, (Object)value /* !! */ );
                        continue block62;
                    }
                    case 114: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl223
                        value /* !! */  = TokenAssociation.DEFAULT;
                        ** GOTO lbl236
lbl223:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v9 /* !! */  = value /* !! */  = strictMode != false ? (TokenAssociation)TokenAssociation.PROTOBUF.parseStrict(input) : (TokenAssociation)TokenAssociation.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl236:
                        // 2 sources

                        temp_automatic_token_associations = ProtoParserTools.addToList(temp_automatic_token_associations, (Object)value /* !! */ );
                        continue block62;
                    }
                    case 122: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl243
                        value /* !! */  = Timestamp.DEFAULT;
                        ** GOTO lbl256
lbl243:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v10 /* !! */  = value /* !! */  = strictMode != false ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl256:
                        // 2 sources

                        temp_parent_consensus_timestamp /* !! */  = value /* !! */ ;
                        continue block62;
                    }
                    case 130: {
                        temp_alias = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block62;
                    }
                    case 138: {
                        temp_ethereum_hash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block62;
                    }
                    case 146: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl269
                        value /* !! */  = AccountAmount.DEFAULT;
                        ** GOTO lbl282
lbl269:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v11 /* !! */  = value /* !! */  = strictMode != false ? (AccountAmount)AccountAmount.PROTOBUF.parseStrict(input) : (AccountAmount)AccountAmount.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl282:
                        // 2 sources

                        temp_paid_staking_rewards = ProtoParserTools.addToList(temp_paid_staking_rewards, (Object)value /* !! */ );
                        continue block62;
                    }
                    case 154: {
                        value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_entropy = new OneOf((Enum)TransactionRecord.EntropyOneOfType.PRNG_BYTES, (Object)value);
                        continue block62;
                    }
                    case 160: {
                        value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        temp_entropy = new OneOf((Enum)TransactionRecord.EntropyOneOfType.PRNG_NUMBER, (Object)value);
                        continue block62;
                    }
                    case 170: {
                        temp_evm_address = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block62;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new TransactionRecord(temp_receipt /* !! */ , temp_transactionHash, (Timestamp)temp_consensusTimestamp /* !! */ , (TransactionID)temp_transactionID /* !! */ , temp_memo, temp_transactionFee, (OneOf<TransactionRecord.BodyOneOfType>)temp_body, (TransferList)temp_transferList /* !! */ , temp_tokenTransferLists, (ScheduleID)temp_scheduleRef /* !! */ , temp_assessed_custom_fees, temp_automatic_token_associations, (Timestamp)temp_parent_consensus_timestamp /* !! */ , temp_alias, temp_ethereum_hash, temp_paid_staking_rewards, (OneOf<TransactionRecord.EntropyOneOfType>)temp_entropy, temp_evm_address);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

