/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.SidecarType;
import com.hedera.hapi.streams.codec.SidecarMetadataJsonCodec;
import com.hedera.hapi.streams.codec.SidecarMetadataProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record SidecarMetadata(@Nullable HashObject hash, int id, List<SidecarType> types) {
    public static final Codec<SidecarMetadata> PROTOBUF = new SidecarMetadataProtoCodec();
    public static final JsonCodec<SidecarMetadata> JSON = new SidecarMetadataJsonCodec();
    public static final SidecarMetadata DEFAULT = SidecarMetadata.newBuilder().build();

    @Override
    public int hashCode() {
        List<SidecarType> list$types;
        int result = 1;
        if (this.hash != null && !this.hash.equals(SidecarMetadata.DEFAULT.hash)) {
            result = 31 * result + this.hash.hashCode();
        }
        if (this.id != SidecarMetadata.DEFAULT.id) {
            result = 31 * result + Integer.hashCode(this.id);
        }
        if ((list$types = this.types) != null) {
            for (SidecarType o : list$types) {
                if (o != null) {
                    result = 31 * result + ((Object)((Object)o)).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SidecarMetadata thatObj = (SidecarMetadata)that;
        if (this.hash == null && thatObj.hash != null) {
            return false;
        }
        if (this.hash != null && !this.hash.equals(thatObj.hash)) {
            return false;
        }
        if (this.id != thatObj.id) {
            return false;
        }
        if (this.types == null && thatObj.types != null) {
            return false;
        }
        return this.types == null || this.types.equals(thatObj.types);
    }

    public boolean hasHash() {
        return this.hash != null;
    }

    public HashObject hashOrElse(@NonNull HashObject defaultValue) {
        return this.hasHash() ? this.hash : defaultValue;
    }

    @NonNull
    public HashObject hashOrThrow() {
        return Objects.requireNonNull(this.hash, "Field hash is null");
    }

    public void ifHash(@NonNull Consumer<HashObject> ifPresent) {
        if (this.hasHash()) {
            ifPresent.accept(this.hash);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.hash, this.id, this.types);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private HashObject hash = null;
        private int id = 0;
        private List<SidecarType> types = Collections.emptyList();

        public Builder() {
        }

        public Builder(HashObject hash, int id, List<SidecarType> types) {
            this.hash = hash;
            this.id = id;
            this.types = types;
        }

        public SidecarMetadata build() {
            return new SidecarMetadata(this.hash, this.id, this.types);
        }

        public Builder hash(@Nullable HashObject hash) {
            this.hash = hash;
            return this;
        }

        public Builder hash(HashObject.Builder builder) {
            this.hash = builder.build();
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder types(List<SidecarType> types) {
            this.types = types;
            return this;
        }

        public Builder types(SidecarType ... values) {
            this.types = List.of(values);
            return this;
        }
    }
}

