/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.streams.TokenUnitBalance;
import com.hedera.hapi.streams.codec.SingleAccountBalancesJsonCodec;
import com.hedera.hapi.streams.codec.SingleAccountBalancesProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record SingleAccountBalances(@Nullable AccountID accountID, long hbarBalance, @Nullable List<TokenUnitBalance> tokenUnitBalances) {
    public static final Codec<SingleAccountBalances> PROTOBUF = new SingleAccountBalancesProtoCodec();
    public static final JsonCodec<SingleAccountBalances> JSON = new SingleAccountBalancesJsonCodec();
    public static final SingleAccountBalances DEFAULT = SingleAccountBalances.newBuilder().build();

    @Override
    public int hashCode() {
        List<TokenUnitBalance> list$tokenUnitBalances;
        int result = 1;
        if (this.accountID != null && !this.accountID.equals(SingleAccountBalances.DEFAULT.accountID)) {
            result = 31 * result + this.accountID.hashCode();
        }
        if (this.hbarBalance != SingleAccountBalances.DEFAULT.hbarBalance) {
            result = 31 * result + Long.hashCode(this.hbarBalance);
        }
        if ((list$tokenUnitBalances = this.tokenUnitBalances) != null) {
            for (TokenUnitBalance o : list$tokenUnitBalances) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SingleAccountBalances thatObj = (SingleAccountBalances)that;
        if (this.accountID == null && thatObj.accountID != null) {
            return false;
        }
        if (this.accountID != null && !this.accountID.equals(thatObj.accountID)) {
            return false;
        }
        if (this.hbarBalance != thatObj.hbarBalance) {
            return false;
        }
        if (this.tokenUnitBalances == null && thatObj.tokenUnitBalances != null) {
            return false;
        }
        return this.tokenUnitBalances == null || this.tokenUnitBalances.equals(thatObj.tokenUnitBalances);
    }

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public boolean hasTokenUnitBalances() {
        return this.tokenUnitBalances != null;
    }

    public List<TokenUnitBalance> tokenUnitBalancesOrElse(@NonNull List<TokenUnitBalance> defaultValue) {
        return this.hasTokenUnitBalances() ? this.tokenUnitBalances : defaultValue;
    }

    @NonNull
    public List<TokenUnitBalance> tokenUnitBalancesOrThrow() {
        return Objects.requireNonNull(this.tokenUnitBalances, "Field tokenUnitBalances is null");
    }

    public void ifTokenUnitBalances(@NonNull Consumer<List<TokenUnitBalance>> ifPresent) {
        if (this.hasTokenUnitBalances()) {
            ifPresent.accept(this.tokenUnitBalances);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountID, this.hbarBalance, this.tokenUnitBalances);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private AccountID accountID = null;
        private long hbarBalance = 0L;
        @Nullable
        private List<TokenUnitBalance> tokenUnitBalances = Collections.emptyList();

        public Builder() {
        }

        public Builder(AccountID accountID, long hbarBalance, List<TokenUnitBalance> tokenUnitBalances) {
            this.accountID = accountID;
            this.hbarBalance = hbarBalance;
            this.tokenUnitBalances = tokenUnitBalances;
        }

        public SingleAccountBalances build() {
            return new SingleAccountBalances(this.accountID, this.hbarBalance, this.tokenUnitBalances);
        }

        public Builder accountID(@Nullable AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder hbarBalance(long hbarBalance) {
            this.hbarBalance = hbarBalance;
            return this;
        }

        public Builder tokenUnitBalances(@Nullable List<TokenUnitBalance> tokenUnitBalances) {
            this.tokenUnitBalances = tokenUnitBalances;
            return this;
        }

        public Builder tokenUnitBalances(TokenUnitBalance ... values) {
            this.tokenUnitBalances = List.of(values);
            return this;
        }
    }
}

