/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.streams.codec.TokenUnitBalanceJsonCodec;
import com.hedera.hapi.streams.codec.TokenUnitBalanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenUnitBalance(@Nullable TokenID tokenId, long balance) {
    public static final Codec<TokenUnitBalance> PROTOBUF = new TokenUnitBalanceProtoCodec();
    public static final JsonCodec<TokenUnitBalance> JSON = new TokenUnitBalanceJsonCodec();
    public static final TokenUnitBalance DEFAULT = TokenUnitBalance.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.tokenId != null && !this.tokenId.equals(TokenUnitBalance.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        if (this.balance != TokenUnitBalance.DEFAULT.balance) {
            result = 31 * result + Long.hashCode(this.balance);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenUnitBalance thatObj = (TokenUnitBalance)that;
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        return this.balance == thatObj.balance;
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.balance);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TokenID tokenId = null;
        private long balance = 0L;

        public Builder() {
        }

        public Builder(TokenID tokenId, long balance) {
            this.tokenId = tokenId;
            this.balance = balance;
        }

        public TokenUnitBalance build() {
            return new TokenUnitBalance(this.tokenId, this.balance);
        }

        public Builder tokenId(@Nullable TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder balance(long balance) {
            this.balance = balance;
            return this;
        }
    }
}

