/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.CallOperationType;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.hapi.streams.ContractActionType;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class ContractActionJsonCodec
implements JsonCodec<ContractAction> {
    public static final OneOf<ContractAction.CallerOneOfType> CALLER_UNSET = new OneOf((Enum)ContractAction.CallerOneOfType.UNSET, null);
    public static final OneOf<ContractAction.RecipientOneOfType> RECIPIENT_UNSET = new OneOf((Enum)ContractAction.RecipientOneOfType.UNSET, null);
    public static final OneOf<ContractAction.ResultDataOneOfType> RESULT_DATA_UNSET = new OneOf((Enum)ContractAction.ResultDataOneOfType.UNSET, null);

    @NonNull
    public ContractAction parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            ContractActionType temp_call_type = ContractActionType.values()[0];
            OneOf temp_caller = CALLER_UNSET;
            long temp_gas = 0L;
            Bytes temp_input = Bytes.EMPTY;
            OneOf temp_recipient = RECIPIENT_UNSET;
            long temp_value = 0L;
            long temp_gas_used = 0L;
            OneOf temp_result_data = RESULT_DATA_UNSET;
            int temp_call_depth = 0;
            CallOperationType temp_call_operation_type = CallOperationType.values()[0];
            block36: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "callType": {
                        temp_call_type = ContractActionType.fromString(kvPair.value().STRING().getText());
                        continue block36;
                    }
                    case "callingAccount": {
                        temp_caller = new OneOf((Enum)ContractAction.CallerOneOfType.CALLING_ACCOUNT, AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false));
                        continue block36;
                    }
                    case "callingContract": {
                        temp_caller = new OneOf((Enum)ContractAction.CallerOneOfType.CALLING_CONTRACT, ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false));
                        continue block36;
                    }
                    case "gas": {
                        temp_gas = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block36;
                    }
                    case "input": {
                        temp_input = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block36;
                    }
                    case "recipientAccount": {
                        temp_recipient = new OneOf((Enum)ContractAction.RecipientOneOfType.RECIPIENT_ACCOUNT, AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false));
                        continue block36;
                    }
                    case "recipientContract": {
                        temp_recipient = new OneOf((Enum)ContractAction.RecipientOneOfType.RECIPIENT_CONTRACT, ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false));
                        continue block36;
                    }
                    case "targetedAddress": {
                        temp_recipient = new OneOf((Enum)ContractAction.RecipientOneOfType.TARGETED_ADDRESS, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block36;
                    }
                    case "value": {
                        temp_value = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block36;
                    }
                    case "gasUsed": {
                        temp_gas_used = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block36;
                    }
                    case "output": {
                        temp_result_data = new OneOf((Enum)ContractAction.ResultDataOneOfType.OUTPUT, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block36;
                    }
                    case "revertReason": {
                        temp_result_data = new OneOf((Enum)ContractAction.ResultDataOneOfType.REVERT_REASON, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block36;
                    }
                    case "error": {
                        temp_result_data = new OneOf((Enum)ContractAction.ResultDataOneOfType.ERROR, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block36;
                    }
                    case "callDepth": {
                        temp_call_depth = JsonTools.parseInteger((JSONParser.ValueContext)kvPair.value());
                        continue block36;
                    }
                    case "callOperationType": {
                        temp_call_operation_type = CallOperationType.fromString(kvPair.value().STRING().getText());
                        continue block36;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ContractAction(temp_call_type, temp_caller, temp_gas, temp_input, temp_recipient, temp_value, temp_gas_used, temp_result_data, temp_call_depth, temp_call_operation_type);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ContractAction data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.callType() != ContractActionType.values()[0]) {
            fieldLines.add(JsonTools.field((String)"callType", (String)data.callType().protoName()));
        }
        if (data.caller().kind() == ContractAction.CallerOneOfType.CALLING_ACCOUNT) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"callingAccount", AccountID.JSON, (Object)data.callingAccount()));
        }
        if (data.caller().kind() == ContractAction.CallerOneOfType.CALLING_CONTRACT) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"callingContract", ContractID.JSON, (Object)data.callingContract()));
        }
        if (data.gas() != 0L) {
            fieldLines.add(JsonTools.field((String)"gas", (long)data.gas()));
        }
        if (data.input() != Bytes.EMPTY && data.input() != null && data.input().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"input", (Bytes)data.input()));
        }
        if (data.recipient().kind() == ContractAction.RecipientOneOfType.RECIPIENT_ACCOUNT) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"recipientAccount", AccountID.JSON, (Object)data.recipientAccount()));
        }
        if (data.recipient().kind() == ContractAction.RecipientOneOfType.RECIPIENT_CONTRACT) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"recipientContract", ContractID.JSON, (Object)data.recipientContract()));
        }
        if (data.recipient().kind() == ContractAction.RecipientOneOfType.TARGETED_ADDRESS) {
            fieldLines.add(JsonTools.field((String)"targetedAddress", (Bytes)data.targetedAddress()));
        }
        if (data.value() != 0L) {
            fieldLines.add(JsonTools.field((String)"value", (long)data.value()));
        }
        if (data.gasUsed() != 0L) {
            fieldLines.add(JsonTools.field((String)"gasUsed", (long)data.gasUsed()));
        }
        if (data.resultData().kind() == ContractAction.ResultDataOneOfType.OUTPUT) {
            fieldLines.add(JsonTools.field((String)"output", (Bytes)data.output()));
        }
        if (data.resultData().kind() == ContractAction.ResultDataOneOfType.REVERT_REASON) {
            fieldLines.add(JsonTools.field((String)"revertReason", (Bytes)data.revertReason()));
        }
        if (data.resultData().kind() == ContractAction.ResultDataOneOfType.ERROR) {
            fieldLines.add(JsonTools.field((String)"error", (Bytes)data.error()));
        }
        if (data.callDepth() != 0) {
            fieldLines.add(JsonTools.field((String)"callDepth", (int)data.callDepth()));
        }
        if (data.callOperationType() != CallOperationType.values()[0]) {
            fieldLines.add(JsonTools.field((String)"callOperationType", (String)data.callOperationType().protoName()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

