/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.ContractBytecode;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class ContractBytecodeJsonCodec
implements JsonCodec<ContractBytecode> {
    @NonNull
    public ContractBytecode parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            ContractID temp_contract_id = null;
            Bytes temp_initcode = Bytes.EMPTY;
            Bytes temp_runtime_bytecode = Bytes.EMPTY;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "contractId": {
                        temp_contract_id = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block12;
                    }
                    case "initcode": {
                        temp_initcode = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block12;
                    }
                    case "runtimeBytecode": {
                        temp_runtime_bytecode = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ContractBytecode(temp_contract_id, temp_initcode, temp_runtime_bytecode);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ContractBytecode data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.contractId() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractId", ContractID.JSON, (Object)data.contractId()));
        }
        if (data.initcode() != Bytes.EMPTY && data.initcode() != null && data.initcode().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"initcode", (Bytes)data.initcode()));
        }
        if (data.runtimeBytecode() != Bytes.EMPTY && data.runtimeBytecode() != null && data.runtimeBytecode().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"runtimeBytecode", (Bytes)data.runtimeBytecode()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

