/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.ContractBytecode;
import com.hedera.hapi.streams.schema.ContractBytecodeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class ContractBytecodeProtoCodec
implements Codec<ContractBytecode> {
    @NonNull
    public ContractBytecode parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ContractBytecode parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ContractBytecode data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractBytecodeSchema.CONTRACT_ID, (Object)data.contractId(), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractBytecodeSchema.INITCODE, (RandomAccessData)data.initcode());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractBytecodeSchema.RUNTIME_BYTECODE, (RandomAccessData)data.runtimeBytecode());
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ContractBytecode data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractBytecodeSchema.CONTRACT_ID, (Object)data.contractId(), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractBytecodeSchema.INITCODE, (RandomAccessData)data.initcode());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractBytecodeSchema.RUNTIME_BYTECODE, (RandomAccessData)data.runtimeBytecode());
    }

    public boolean fastEquals(@NonNull ContractBytecode item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NonNull
    private ContractBytecode parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            temp_contract_id = null;
            temp_initcode = Bytes.EMPTY;
            temp_runtime_bytecode = Bytes.EMPTY;
            block12: while (input.hasRemaining()) {
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                field = tag >>> 3;
                f = ContractBytecodeSchema.getField(field);
                switch (tag) {
                    case 10: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl19
                        value = ContractID.DEFAULT;
                        ** GOTO lbl32
lbl19:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value = strictMode != false ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl32:
                        // 2 sources

                        temp_contract_id = value;
                        continue block12;
                    }
                    case 18: {
                        temp_initcode = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block12;
                    }
                    case 26: {
                        temp_runtime_bytecode = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block12;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new ContractBytecode(temp_contract_id, temp_initcode, temp_runtime_bytecode);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

