/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.RecordStreamFile;
import com.hedera.hapi.streams.RecordStreamItem;
import com.hedera.hapi.streams.SidecarMetadata;
import com.hedera.hapi.streams.schema.RecordStreamFileSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Collections;

public final class RecordStreamFileProtoCodec
implements Codec<RecordStreamFile> {
    @NonNull
    public RecordStreamFile parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public RecordStreamFile parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull RecordStreamFile data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.HAPI_PROTO_VERSION, (Object)data.hapiProtoVersion(), (arg_0, arg_1) -> SemanticVersion.PROTOBUF.write(arg_0, arg_1), arg_0 -> SemanticVersion.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.START_OBJECT_RUNNING_HASH, (Object)data.startObjectRunningHash(), (arg_0, arg_1) -> HashObject.PROTOBUF.write(arg_0, arg_1), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.RECORD_STREAM_ITEMS, data.recordStreamItems(), (arg_0, arg_1) -> RecordStreamItem.PROTOBUF.write(arg_0, arg_1), arg_0 -> RecordStreamItem.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.END_OBJECT_RUNNING_HASH, (Object)data.endObjectRunningHash(), (arg_0, arg_1) -> HashObject.PROTOBUF.write(arg_0, arg_1), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.BLOCK_NUMBER, (long)data.blockNumber());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)RecordStreamFileSchema.SIDECARS, data.sidecars(), (arg_0, arg_1) -> SidecarMetadata.PROTOBUF.write(arg_0, arg_1), arg_0 -> SidecarMetadata.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(RecordStreamFile data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamFileSchema.HAPI_PROTO_VERSION, (Object)data.hapiProtoVersion(), arg_0 -> SemanticVersion.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamFileSchema.START_OBJECT_RUNNING_HASH, (Object)data.startObjectRunningHash(), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)RecordStreamFileSchema.RECORD_STREAM_ITEMS, data.recordStreamItems(), arg_0 -> RecordStreamItem.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)RecordStreamFileSchema.END_OBJECT_RUNNING_HASH, (Object)data.endObjectRunningHash(), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)RecordStreamFileSchema.BLOCK_NUMBER, (long)data.blockNumber());
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)RecordStreamFileSchema.SIDECARS, data.sidecars(), arg_0 -> SidecarMetadata.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull RecordStreamFile item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NonNull
    private RecordStreamFile parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            temp_hapi_proto_version /* !! */  = null;
            temp_start_object_running_hash /* !! */  = null;
            temp_record_stream_items = Collections.emptyList();
            temp_end_object_running_hash /* !! */  = null;
            temp_block_number = 0L;
            temp_sidecars = Collections.emptyList();
            block27: while (input.hasRemaining()) {
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                field = tag >>> 3;
                f = RecordStreamFileSchema.getField(field);
                switch (tag) {
                    case 10: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl22
                        value /* !! */  = SemanticVersion.DEFAULT;
                        ** GOTO lbl35
lbl22:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value /* !! */  = strictMode != false ? (SemanticVersion)SemanticVersion.PROTOBUF.parseStrict(input) : (SemanticVersion)SemanticVersion.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl35:
                        // 2 sources

                        temp_hapi_proto_version /* !! */  = value /* !! */ ;
                        continue block27;
                    }
                    case 18: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl42
                        value /* !! */  = HashObject.DEFAULT;
                        ** GOTO lbl55
lbl42:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v1 /* !! */  = value /* !! */  = strictMode != false ? (HashObject)HashObject.PROTOBUF.parseStrict(input) : (HashObject)HashObject.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl55:
                        // 2 sources

                        temp_start_object_running_hash /* !! */  = value /* !! */ ;
                        continue block27;
                    }
                    case 26: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl62
                        value /* !! */  = RecordStreamItem.DEFAULT;
                        ** GOTO lbl75
lbl62:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v2 /* !! */  = value /* !! */  = strictMode != false ? (RecordStreamItem)RecordStreamItem.PROTOBUF.parseStrict(input) : (RecordStreamItem)RecordStreamItem.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl75:
                        // 2 sources

                        temp_record_stream_items = ProtoParserTools.addToList(temp_record_stream_items, (Object)value /* !! */ );
                        continue block27;
                    }
                    case 34: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl82
                        value /* !! */  = HashObject.DEFAULT;
                        ** GOTO lbl95
lbl82:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v3 /* !! */  = value /* !! */  = strictMode != false ? (HashObject)HashObject.PROTOBUF.parseStrict(input) : (HashObject)HashObject.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl95:
                        // 2 sources

                        temp_end_object_running_hash /* !! */  = value /* !! */ ;
                        continue block27;
                    }
                    case 40: {
                        temp_block_number = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block27;
                    }
                    case 50: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl105
                        value /* !! */  = SidecarMetadata.DEFAULT;
                        ** GOTO lbl118
lbl105:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v4 /* !! */  = value /* !! */  = strictMode != false ? (SidecarMetadata)SidecarMetadata.PROTOBUF.parseStrict(input) : (SidecarMetadata)SidecarMetadata.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl118:
                        // 2 sources

                        temp_sidecars = ProtoParserTools.addToList(temp_sidecars, (Object)value /* !! */ );
                        continue block27;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new RecordStreamFile(temp_hapi_proto_version /* !! */ , (HashObject)temp_start_object_running_hash /* !! */ , temp_record_stream_items, (HashObject)temp_end_object_running_hash /* !! */ , temp_block_number, temp_sidecars);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

