/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.streams.StorageChange;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class StorageChangeJsonCodec
implements JsonCodec<StorageChange> {
    @NonNull
    public StorageChange parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            Bytes temp_slot = Bytes.EMPTY;
            Bytes temp_value_read = Bytes.EMPTY;
            Bytes temp_value_written = null;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "slot": {
                        temp_slot = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block12;
                    }
                    case "valueRead": {
                        temp_value_read = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block12;
                    }
                    case "valueWritten": {
                        temp_value_written = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new StorageChange(temp_slot, temp_value_read, temp_value_written);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull StorageChange data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.slot() != Bytes.EMPTY && data.slot() != null && data.slot().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"slot", (Bytes)data.slot()));
        }
        if (data.valueRead() != Bytes.EMPTY && data.valueRead() != null && data.valueRead().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"valueRead", (Bytes)data.valueRead()));
        }
        if (data.valueWritten() != null) {
            fieldLines.add(JsonTools.field((String)"valueWritten", (Bytes)data.valueWritten()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

