/*
 * Decompiled with CFR 0.152.
 */
package com.hederahashgraph.builder;

import com.google.protobuf.ByteString;
import com.hedera.services.legacy.proto.utils.CommonUtils;
import com.hedera.services.legacy.proto.utils.KeyExpansion;
import com.hedera.services.legacy.proto.utils.SignatureGenerator;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.KeyList;
import com.hederahashgraph.api.proto.java.SignatureMap;
import com.hederahashgraph.api.proto.java.SignaturePair;
import com.hederahashgraph.api.proto.java.Transaction;
import com.hederahashgraph.api.proto.java.TransactionOrBuilder;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class TransactionSigner {
    static final String ECDSA_SIGNATURE_ALGORITHM = "SHA384withECDSA";

    public static ByteString signBytes(byte[] msgBytes, PrivateKey priv) {
        byte[] sigBytes = null;
        try {
            if (priv instanceof EdDSAPrivateKey) {
                EdDSAEngine engine = new EdDSAEngine();
                engine.initSign(priv);
                sigBytes = engine.signOneShot(msgBytes);
            } else {
                Signature sigInstance = null;
                sigInstance = Signature.getInstance(ECDSA_SIGNATURE_ALGORITHM);
                sigInstance.initSign(priv);
                sigInstance.update(msgBytes, 0, msgBytes.length);
                sigBytes = sigInstance.sign();
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            e.printStackTrace();
        }
        return ByteString.copyFrom(sigBytes);
    }

    public static Transaction signTransaction(Transaction transaction, List<PrivateKey> privKeyList) {
        return TransactionSigner.signTransaction(transaction, privKeyList, false);
    }

    public static Transaction signTransaction(Transaction transaction, List<PrivateKey> privKeyList, boolean appendSigMap) {
        ArrayList<Key> keyList = new ArrayList<Key>();
        HashMap<String, PrivateKey> pubKey2privKeyMap = new HashMap<String, PrivateKey>();
        for (PrivateKey pk : privKeyList) {
            byte[] pubKey = ((EdDSAPrivateKey)pk).getAbyte();
            Key key = Key.newBuilder().setEd25519(ByteString.copyFrom((byte[])pubKey)).build();
            keyList.add(key);
            String pubKeyHex = Hex.encodeHexString((byte[])pubKey);
            pubKey2privKeyMap.put(pubKeyHex, pk);
        }
        try {
            return TransactionSigner.signTransactionComplexWithSigMap(transaction, keyList, pubKey2privKeyMap, appendSigMap);
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
            return transaction;
        }
    }

    public static Transaction signTransactionComplexWithSigMap(TransactionOrBuilder transaction, List<Key> keys, Map<String, PrivateKey> pubKey2privKeyMap) throws Exception {
        return TransactionSigner.signTransactionComplexWithSigMap(transaction, keys, pubKey2privKeyMap, false);
    }

    public static Transaction signTransactionComplexWithSigMap(TransactionOrBuilder transaction, List<Key> keys, Map<String, PrivateKey> pubKey2privKeyMap, boolean appendSigMap) throws Exception {
        byte[] bodyBytes = CommonUtils.extractTransactionBodyBytes(transaction);
        SignatureMap sigsMap = TransactionSigner.signAsSignatureMap(bodyBytes, keys, pubKey2privKeyMap);
        Transaction.Builder builder = CommonUtils.toTransactionBuilder(transaction);
        if (appendSigMap) {
            SignatureMap currentSigMap = CommonUtils.extractSignatureMapOrUseDefault(transaction);
            SignatureMap sigMapToSet = currentSigMap.toBuilder().addAllSigPair(sigsMap.getSigPairList()).build();
            return builder.setSigMap(sigMapToSet).build();
        }
        return builder.setSigMap(sigsMap).build();
    }

    public static SignatureMap signAsSignatureMap(byte[] messageBytes, List<Key> keys, Map<String, PrivateKey> pubKey2privKeyMap) throws Exception {
        ArrayList<Key> expandedKeys = new ArrayList<Key>();
        Key aKey = Key.newBuilder().setKeyList(KeyList.newBuilder().addAllKeys(keys).build()).build();
        KeyExpansion.expandKeyMinimum4Signing(aKey, 1, expandedKeys);
        HashSet<Key> uniqueKeys = new HashSet<Key>(expandedKeys);
        int len = TransactionSigner.findMinPrefixLength(uniqueKeys);
        ArrayList<SignaturePair> pairs = new ArrayList<SignaturePair>();
        for (Key key : uniqueKeys) {
            if (key.hasContractID()) continue;
            SignaturePair sig = KeyExpansion.signBasicAsSignaturePair(key, len, pubKey2privKeyMap, messageBytes);
            pairs.add(sig);
        }
        SignatureMap sigsMap = SignatureMap.newBuilder().addAllSigPair(pairs).build();
        return sigsMap;
    }

    private static int findMinPrefixLength(Set<Key> keys) {
        if (keys.size() == 1) {
            return 3;
        }
        int rv = 0;
        int numKeys = keys.size();
        ArrayList<String> keyHexes = new ArrayList<String>();
        int maxBytes = 0;
        for (Key key : keys) {
            byte[] bytes = key.getEd25519().toByteArray();
            if (bytes.length > maxBytes) {
                maxBytes = bytes.length;
            }
            String hex = Hex.encodeHexString((byte[])bytes);
            keyHexes.add(hex);
        }
        rv = maxBytes;
        for (int i = 1; i <= maxBytes; ++i) {
            HashSet<String> prefixSet = new HashSet<String>();
            for (String khex : keyHexes) {
                prefixSet.add(khex.substring(0, i * 2));
            }
            if (prefixSet.size() != numKeys) continue;
            rv = i;
            break;
        }
        return Math.max(3, rv);
    }

    public static Transaction signTransactionNewWithSignatureMap(Transaction transaction, List<List<PrivateKey>> privKeysList, List<List<PublicKey>> pubKeysList) throws Exception {
        byte[] bodyBytes = CommonUtils.extractTransactionBodyBytes(transaction);
        if (pubKeysList.size() != privKeysList.size()) {
            new Exception("public and private keys size mismtach! pubKeysList size = " + pubKeysList.size() + ", privKeysList size = " + privKeysList.size());
        }
        ArrayList<SignaturePair> pairs = new ArrayList<SignaturePair>();
        int i = 0;
        for (List<PrivateKey> privKeyList : privKeysList) {
            List<PublicKey> pubKeyList = pubKeysList.get(i++);
            int j = 0;
            for (PrivateKey privKey : privKeyList) {
                PublicKey pubKey = pubKeyList.get(j++);
                SignaturePair sig = TransactionSigner.signAsSignaturePair(pubKey, privKey, bodyBytes);
                pairs.add(sig);
            }
        }
        SignatureMap sigsMap = SignatureMap.newBuilder().addAllSigPair(pairs).build();
        return transaction.toBuilder().setSigMap(sigsMap).build();
    }

    private static SignaturePair signAsSignaturePair(PublicKey pubKey, PrivateKey privKey, byte[] bodyBytes) throws InvalidKeyException, NoSuchAlgorithmException, UnsupportedEncodingException, SignatureException, DecoderException {
        byte[] pubKeyBytes = ((EdDSAPublicKey)pubKey).getAbyte();
        String sigHex = SignatureGenerator.signBytes(bodyBytes, privKey);
        SignaturePair rv = SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFrom((byte[])pubKeyBytes)).setEd25519(ByteString.copyFrom((byte[])Hex.decodeHex((String)sigHex))).build();
        return rv;
    }

    public static Transaction signTransactionWithSignatureMap(Transaction transaction, List<PrivateKey> privKeyList, List<PublicKey> pubKeyList) throws Exception {
        ArrayList<List<PrivateKey>> privKeysList = new ArrayList<List<PrivateKey>>();
        ArrayList<List<PublicKey>> pubKeysList = new ArrayList<List<PublicKey>>();
        int i = 0;
        for (PrivateKey pk : privKeyList) {
            ArrayList<PrivateKey> aList = new ArrayList<PrivateKey>();
            aList.add(pk);
            privKeysList.add(aList);
            ArrayList<PublicKey> bList = new ArrayList<PublicKey>();
            PublicKey pubKey = pubKeyList.get(i++);
            bList.add(pubKey);
            pubKeysList.add(bList);
        }
        return TransactionSigner.signTransactionNewWithSignatureMap(transaction, privKeysList, pubKeysList);
    }
}

