/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.services.legacy.proto.utils;

import com.hedera.services.legacy.proto.utils.SignatureVerifier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class SignatureGenerator {
    public static final String PUBLIC_KEY_HEX = "PUBLIC_KEY_HEX";
    public static final String SIGNATURE_HEX = "SIGNATURE_HEX";
    private static final String NAMED_EC_CURVE = "secp384r1";
    public static final String KEY_SAVE_DIR = "data/keys/";
    public static String ECDSA = "ECDSA";
    public static String ED25519 = "ED25519";
    public static String RSA = "RSA";

    public static Map<String, String> sign(String msg, KeyPair pair) throws SignatureException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        HashMap<String, String> rv = new HashMap<String, String>();
        PrivateKey priv = pair.getPrivate();
        String sigHex = SignatureGenerator.sign(msg, priv);
        String pubKeyHex = SignatureGenerator.getPubKeyHex(pair);
        rv.put(PUBLIC_KEY_HEX, pubKeyHex);
        rv.put(SIGNATURE_HEX, sigHex);
        return rv;
    }

    public static String sign(String msg, PrivateKey priv) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, SignatureException {
        byte[] sigBytes = null;
        byte[] msgBytes = SignatureVerifier.getMsgBytes(msg);
        if (priv instanceof EdDSAPrivateKey) {
            EdDSAEngine engine = new EdDSAEngine();
            engine.initSign(priv);
            sigBytes = engine.signOneShot(msgBytes);
        } else {
            Signature sigInstance = Signature.getInstance("SHA384withECDSA");
            sigInstance.initSign(priv);
            sigInstance.update(msgBytes, 0, msgBytes.length);
            sigBytes = sigInstance.sign();
        }
        String sigHex = Hex.encodeHexString((byte[])sigBytes);
        return sigHex;
    }

    public static String signBytes(byte[] msgBytes, PrivateKey priv) throws NoSuchAlgorithmException, InvalidKeyException, UnsupportedEncodingException, SignatureException {
        byte[] sigBytes = null;
        if (priv instanceof EdDSAPrivateKey) {
            EdDSAEngine engine = new EdDSAEngine();
            engine.initSign(priv);
            sigBytes = engine.signOneShot(msgBytes);
        } else {
            Signature sigInstance = Signature.getInstance("SHA384withECDSA");
            sigInstance.initSign(priv);
            sigInstance.update(msgBytes, 0, msgBytes.length);
            sigBytes = sigInstance.sign();
        }
        String sigHex = Hex.encodeHexString((byte[])sigBytes);
        return sigHex;
    }

    public static String getPubKeyHex(KeyPair pair) {
        byte[] pubKeyBytes = null;
        PublicKey pub = pair.getPublic();
        pubKeyBytes = pub instanceof EdDSAPublicKey ? ((EdDSAPublicKey)pair.getPublic()).getAbyte() : pub.getEncoded();
        String pubKeyHex = Hex.encodeHexString((byte[])pubKeyBytes);
        return pubKeyHex;
    }

    public static Map<String, String> sign(String msg) throws SignatureException, UnsupportedEncodingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        KeyPair pair = SignatureGenerator.generateKeyPair();
        return SignatureGenerator.sign(msg, pair);
    }

    public static ECPublicKey getPublicKeyFromBinary(byte[] x, byte[] y, String namedCurve, String keyAlgorithm) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, InvalidKeySpecException {
        ECPoint pubPoint = new ECPoint(new BigInteger(1, x), new BigInteger(1, y));
        AlgorithmParameters parameters = AlgorithmParameters.getInstance(keyAlgorithm);
        parameters.init(new ECGenParameterSpec(namedCurve));
        ECParameterSpec ecParameters = parameters.getParameterSpec(ECParameterSpec.class);
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(pubPoint, ecParameters);
        KeyFactory kf = KeyFactory.getInstance(keyAlgorithm);
        ECPublicKey rv = (ECPublicKey)kf.generatePublic(pubSpec);
        return rv;
    }

    public static ECPublicKey getEC384PublicKeyFromBinary(String binaryHex) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidParameterSpecException, InvalidKeySpecException, DecoderException, StringIndexOutOfBoundsException {
        ECPublicKey key = null;
        String xHex = binaryHex.substring(2, 98);
        String yHex = binaryHex.substring(98, 194);
        byte[] x = Hex.decodeHex((String)xHex);
        byte[] y = Hex.decodeHex((String)yHex);
        key = SignatureGenerator.getPublicKeyFromBinary(x, y, NAMED_EC_CURVE, "EC");
        return key;
    }

    public static void main(String[] args) throws Exception {
        KeyPair pair = SignatureGenerator.generateKeyPair();
        String path = "data/keys//test/";
        SignatureGenerator.save(pair, path);
        PrivateKey privateKey = SignatureGenerator.readPrivate(path + "privateKey");
        String msg = "a test message";
        String signature = SignatureGenerator.sign(msg, privateKey);
        String pubKeyStr = SignatureGenerator.readPublic(path + "publicKey");
        boolean rv = SignatureVerifier.verifyECDSA(signature, msg, pubKeyStr);
        System.out.println("rv =" + rv);
    }

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
        SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
        keyGen.initialize(384, random);
        KeyPair pair = keyGen.generateKeyPair();
        return pair;
    }

    public static void writeToFile(String path, byte[] data) throws IOException {
        File f = new File(path);
        f.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(f);){
            fos.write(data);
            fos.flush();
        }
    }

    public static void save(KeyPair pair, String dir) throws IOException {
        PrivateKey privateKey = pair.getPrivate();
        PublicKey publicKey = pair.getPublic();
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        SignatureGenerator.writeToFile(dir + "privateKey", privateKey.getEncoded());
        SignatureGenerator.writeToFile(dir + "publicKey", publicKey.getEncoded());
    }

    public static PrivateKey readPrivate(String filename) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] keyBytes = Files.readAllBytes(new File(filename).toPath());
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance("EC");
        return kf.generatePrivate(spec);
    }

    public static String readPublic(String filename) throws Exception {
        byte[] keyBytes = Files.readAllBytes(new File(filename).toPath());
        String pubKeyHex = Hex.encodeHexString((byte[])keyBytes);
        return pubKeyHex;
    }

    public static KeyPair generateKeyPair(String algorithm) throws NoSuchAlgorithmException {
        KeyPair pair;
        if (algorithm.equals(ECDSA)) {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            keyGen.initialize(384, random);
            pair = keyGen.generateKeyPair();
        } else {
            net.i2p.crypto.eddsa.KeyPairGenerator keyPairGen = new net.i2p.crypto.eddsa.KeyPairGenerator();
            pair = keyPairGen.generateKeyPair();
        }
        return pair;
    }
}

