/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.services.legacy.proto.utils;

import com.hedera.services.legacy.proto.utils.SignatureGenerator;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.X509EncodedKeySpec;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SignatureVerifier {
    private static final Logger log = LogManager.getLogger(SignatureVerifier.class);
    static final String KEY_ALGORITHM = "EC";
    static final String SIGNATURE_ALGORITHM = "SHA384withECDSA";
    public static final String CHARACTER_SET_NAME = "UTF-8";
    public static final int KEY_SIZE = 384;
    public static final String RANDOM_ALGORITHM = "SHA1PRNG";

    public static boolean verifyECDSA(String signature, String msg, String pubKeyStr) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, SignatureException, InvalidKeyException, DecoderException, UnsupportedEncodingException, InvalidParameterSpecException {
        if (pubKeyStr.startsWith("04")) {
            return SignatureVerifier.verifyWithBinaryEC384PublicKey(signature, msg, pubKeyStr);
        }
        return SignatureVerifier.verifyX509PublicKey(signature, msg, pubKeyStr);
    }

    public static boolean verifyX509PublicKey(String signature, String msg, String pubKeyStr) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, SignatureException, InvalidKeyException, DecoderException, UnsupportedEncodingException {
        boolean rv = false;
        byte[] sigBytes = SignatureVerifier.getSigBytes(signature);
        byte[] msgBytes = SignatureVerifier.getMsgBytes(msg);
        byte[] pubKeyBytes = SignatureVerifier.getPubKeyBytes(pubKeyStr);
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
        Signature sigInstance = Signature.getInstance(SIGNATURE_ALGORITHM);
        sigInstance.initVerify(pubKey);
        sigInstance.update(msgBytes, 0, msgBytes.length);
        rv = sigInstance.verify(sigBytes);
        return rv;
    }

    public static boolean checkECDSAAddressFormat(String pubKeyStr) throws Exception {
        boolean rv = false;
        try {
            if (pubKeyStr.startsWith("04")) {
                if (pubKeyStr.length() != 194) {
                    throw new Exception("Public address is not 194 bytes. Address = " + pubKeyStr);
                }
                SignatureGenerator.getEC384PublicKeyFromBinary(pubKeyStr);
                rv = true;
            } else {
                byte[] pubKeyBytes = SignatureVerifier.getPubKeyBytes(pubKeyStr);
                X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyBytes);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                keyFactory.generatePublic(pubKeySpec);
                rv = true;
            }
        }
        catch (Exception e) {
            rv = false;
            throw new Exception("Invalid address detected: " + pubKeyStr, e);
        }
        return rv;
    }

    public static boolean verifyWithBinaryEC384PublicKey(String signature, String msg, String pubKeyStr) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException, SignatureException, InvalidKeyException, DecoderException, UnsupportedEncodingException, InvalidParameterSpecException {
        boolean rv = false;
        byte[] sigBytes = SignatureVerifier.getSigBytes(signature);
        byte[] msgBytes = SignatureVerifier.getMsgBytes(msg);
        ECPublicKey pubKey = SignatureGenerator.getEC384PublicKeyFromBinary(pubKeyStr);
        Signature sigInstance = Signature.getInstance(SIGNATURE_ALGORITHM);
        sigInstance.initVerify(pubKey);
        sigInstance.update(msgBytes, 0, msgBytes.length);
        rv = sigInstance.verify(sigBytes);
        return rv;
    }

    private static byte[] getPubKeyBytes(String pubKey) throws DecoderException {
        byte[] rv = null;
        rv = Hex.decodeHex((String)pubKey);
        return rv;
    }

    static byte[] getMsgBytes(String msg) throws UnsupportedEncodingException {
        byte[] rv = null;
        rv = msg.getBytes(CHARACTER_SET_NAME);
        return rv;
    }

    private static byte[] getSigBytes(String signature) throws DecoderException {
        byte[] rv = null;
        rv = Hex.decodeHex((String)signature);
        return rv;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: VerSig publickeyfile signaturefile datafile");
            System.exit(1);
        }
        byte[] encKey = null;
        try (FileInputStream keyfis = new FileInputStream(args[0]);){
            encKey = new byte[keyfis.available()];
            keyfis.read(encKey);
        }
        catch (IOException e) {
            System.err.println("Caught IOException when reading public key file " + e.toString());
            log.error("Caught IOException when reading public key file ", (Throwable)e);
        }
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
        PublicKey pubKey = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("DSA", "SUN");
            pubKey = keyFactory.generatePublic(pubKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            System.err.println("Caught exception when generating public key " + e.toString());
            log.error("Caught Exception when generating public key", (Throwable)e);
        }
        byte[] sigToVerify = null;
        try (FileInputStream sigfis = new FileInputStream(args[1]);){
            sigToVerify = new byte[sigfis.available()];
            sigfis.read(sigToVerify);
        }
        catch (IOException e) {
            System.err.println("Caught IOException when reading public key file " + e.toString());
            log.error("Caught IOException when reading public key file", (Throwable)e);
        }
        Signature sig = null;
        try {
            sig = Signature.getInstance("SHA1withDSA", "SUN");
            sig.initVerify(pubKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            System.err.println("Caught exception when initializing verifying signature " + e.toString());
            log.error("Caught Exception when initializing verifying signature", (Throwable)e);
        }
        try (FileInputStream datafis = new FileInputStream(args[2]);
             BufferedInputStream bufin = new BufferedInputStream(datafis);){
            byte[] buffer = new byte[1024];
            while (bufin.available() != 0) {
                int len = bufin.read(buffer);
                sig.update(buffer, 0, len);
            }
        }
        catch (IOException | SignatureException e) {
            System.err.println("Caught exception when reading data file " + e.toString());
            log.error("Caught Exception when reading data file", (Throwable)e);
        }
        boolean verifies = false;
        try {
            verifies = sig.verify(sigToVerify);
        }
        catch (SignatureException e) {
            System.err.println("Caught exception when verifying signature " + e.toString());
            log.error("Caught Exception when verifying signature", (Throwable)e);
        }
        System.out.println("signature verifies: " + verifies);
    }

    public static boolean verifyED25519Signature(String pubKeyStr, String message, String signature) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException, DecoderException {
        byte[] sigBytes = SignatureVerifier.getSigBytes(signature);
        byte[] msgBytes = SignatureVerifier.getMsgBytes(message);
        byte[] pubKeyBytes = SignatureVerifier.getPubKeyBytes(pubKeyStr);
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");
        EdDSAPublicKeySpec pubKey = new EdDSAPublicKeySpec(pubKeyBytes, (EdDSAParameterSpec)spec);
        EdDSAPublicKey vKey = new EdDSAPublicKey(pubKey);
        EdDSAEngine verifier = new EdDSAEngine(MessageDigest.getInstance(spec.getHashAlgorithm()));
        verifier.initVerify((PublicKey)vKey);
        verifier.update(msgBytes);
        return verifier.verify(sigBytes);
    }

    public static boolean verifyED25519(byte[] pubKeyBytes, byte[] msgBytes, byte[] sigBytes) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, UnsupportedEncodingException, DecoderException {
        EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"Ed25519");
        EdDSAPublicKeySpec pubKey = new EdDSAPublicKeySpec(pubKeyBytes, (EdDSAParameterSpec)spec);
        EdDSAPublicKey vKey = new EdDSAPublicKey(pubKey);
        EdDSAEngine verifier = new EdDSAEngine(MessageDigest.getInstance(spec.getHashAlgorithm()));
        verifier.initVerify((PublicKey)vKey);
        verifier.update(msgBytes);
        return verifier.verify(sigBytes);
    }
}

