/*
 * Decompiled with CFR 0.152.
 */
package com.hederahashgraph.fee;

import com.google.common.base.Charsets;
import com.google.protobuf.ByteString;
import com.hederahashgraph.api.proto.java.AccountID;
import com.hederahashgraph.api.proto.java.ConsensusCreateTopicTransactionBody;
import com.hederahashgraph.api.proto.java.ConsensusSubmitMessageTransactionBody;
import com.hederahashgraph.api.proto.java.ConsensusUpdateTopicTransactionBody;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.Timestamp;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.builder.RequestBuilder;
import com.hederahashgraph.exception.InvalidTxBodyException;
import com.hederahashgraph.fee.FeeBuilder;
import com.hederahashgraph.fee.SigValueObj;
import java.time.Duration;
import java.time.Instant;

public class ConsensusServiceFeeBuilder
extends FeeBuilder {
    public static FeeData getConsensusCreateTopicFee(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasConsensusCreateTopic()) {
            throw new InvalidTxBodyException("consensusCreateTopic field not available for Fee Calculation");
        }
        ConsensusCreateTopicTransactionBody createTopicTxBody = txBody.getConsensusCreateTopic();
        int variableSize = ConsensusServiceFeeBuilder.computeVariableSizedFieldsUsage(createTopicTxBody.getAdminKey(), createTopicTxBody.getSubmitKey(), createTopicTxBody.getMemo(), createTopicTxBody.hasAutoRenewAccount());
        long extraRbsServices = 0L;
        if (createTopicTxBody.hasAutoRenewPeriod()) {
            extraRbsServices = (long)ConsensusServiceFeeBuilder.getTopicRamBytes(variableSize) * createTopicTxBody.getAutoRenewPeriod().getSeconds();
        }
        return ConsensusServiceFeeBuilder.getTxFeeMatrices(txBody, sigValObj, variableSize + 8, extraRbsServices, 4320L);
    }

    public static FeeData getConsensusUpdateTopicFee(TransactionBody txBody, long rbsIncrease, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasConsensusUpdateTopic()) {
            throw new InvalidTxBodyException("consensusUpdateTopic field not available for Fee Calculation");
        }
        ConsensusUpdateTopicTransactionBody updateTopicTxBody = txBody.getConsensusUpdateTopic();
        int variableSize = ConsensusServiceFeeBuilder.computeVariableSizedFieldsUsage(updateTopicTxBody.getAdminKey(), updateTopicTxBody.getSubmitKey(), updateTopicTxBody.getMemo().getValue(), updateTopicTxBody.hasAutoRenewAccount());
        return ConsensusServiceFeeBuilder.getTxFeeMatrices(txBody, sigValObj, ConsensusServiceFeeBuilder.getConsensusUpdateTopicTransactionBodySize(updateTopicTxBody, variableSize), rbsIncrease, 0L);
    }

    private static int getConsensusUpdateTopicTransactionBodySize(ConsensusUpdateTopicTransactionBody updateTopicTxBody, int variableSize) {
        variableSize += 24;
        if (updateTopicTxBody.hasExpirationTime()) {
            variableSize += 8;
        }
        if (updateTopicTxBody.hasAutoRenewPeriod()) {
            variableSize += 8;
        }
        return variableSize;
    }

    public static long getUpdateTopicRbsIncrease(Timestamp txValidStartTimestamp, Key oldAdminKey, Key oldSubmitKey, String oldMemo, boolean hasOldAutoRenewAccount, Timestamp oldExpirationTimeStamp, ConsensusUpdateTopicTransactionBody updateTopicTxBody) {
        int oldRamBytes = ConsensusServiceFeeBuilder.getTopicRamBytes(ConsensusServiceFeeBuilder.computeVariableSizedFieldsUsage(oldAdminKey, oldSubmitKey, oldMemo, hasOldAutoRenewAccount));
        String newMemo = updateTopicTxBody.hasMemo() ? updateTopicTxBody.getMemo().getValue() : oldMemo;
        boolean hasNewAutoRenewAccount = hasOldAutoRenewAccount;
        if (updateTopicTxBody.hasAutoRenewAccount()) {
            hasNewAutoRenewAccount = true;
            AccountID account = updateTopicTxBody.getAutoRenewAccount();
            if (account.getAccountNum() == 0L && account.getShardNum() == 0L && account.getRealmNum() == 0L) {
                hasNewAutoRenewAccount = false;
            }
        }
        Key newAdminKey = oldAdminKey;
        if (updateTopicTxBody.hasAdminKey() && (newAdminKey = updateTopicTxBody.getAdminKey()).hasKeyList() && newAdminKey.getKeyList().getKeysCount() == 0) {
            newAdminKey = null;
        }
        Key newSubmitKey = oldSubmitKey;
        if (updateTopicTxBody.hasSubmitKey() && (newSubmitKey = updateTopicTxBody.getSubmitKey()).hasKeyList() && newSubmitKey.getKeyList().getKeysCount() == 0) {
            newSubmitKey = null;
        }
        int newRamBytes = ConsensusServiceFeeBuilder.getTopicRamBytes(ConsensusServiceFeeBuilder.computeVariableSizedFieldsUsage(newAdminKey, newSubmitKey, newMemo, hasNewAutoRenewAccount));
        Timestamp newExpirationTimeStamp = updateTopicTxBody.hasExpirationTime() ? updateTopicTxBody.getExpirationTime() : oldExpirationTimeStamp;
        return ConsensusServiceFeeBuilder.calculateRbsIncrease(txValidStartTimestamp, oldRamBytes, oldExpirationTimeStamp, newRamBytes, newExpirationTimeStamp);
    }

    private static long calculateRbsIncrease(Timestamp txValidStartTimestamp, long oldRamBytes, Timestamp oldExpirationTimeStamp, long newRamBytes, Timestamp newExpirationTimeStamp) {
        Instant txValidStart = RequestBuilder.convertProtoTimeStamp(txValidStartTimestamp);
        Instant oldExpiration = RequestBuilder.convertProtoTimeStamp(oldExpirationTimeStamp);
        Instant newExpiration = RequestBuilder.convertProtoTimeStamp(newExpirationTimeStamp);
        long rbsRefund = oldRamBytes * Duration.between(txValidStart, oldExpiration).getSeconds();
        long rbsCharge = newRamBytes * Duration.between(txValidStart, newExpiration).getSeconds();
        long netRbs = rbsCharge - rbsRefund;
        return netRbs > 0L ? netRbs : 0L;
    }

    public static FeeData getConsensusDeleteTopicFee(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasConsensusDeleteTopic()) {
            throw new InvalidTxBodyException("consensusDeleteTopic field not available for Fee Calculation");
        }
        return ConsensusServiceFeeBuilder.getTxFeeMatrices(txBody, sigValObj, 24, 0L, 0L);
    }

    public static FeeData getConsensusSubmitMessageFee(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasConsensusSubmitMessage()) {
            throw new InvalidTxBodyException("consensusSubmitMessage field not available for Fee Calculation");
        }
        ConsensusSubmitMessageTransactionBody submitMessageTxBody = txBody.getConsensusSubmitMessage();
        int submitMessageTxBodySize = 24;
        if (submitMessageTxBody.getMessage() != ByteString.EMPTY) {
            submitMessageTxBodySize += submitMessageTxBody.getMessage().size();
        }
        return ConsensusServiceFeeBuilder.getTxFeeMatrices(txBody, sigValObj, submitMessageTxBodySize, 0L, 10080L);
    }

    private static FeeData getTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj, int txBodyDataSize, long extraRbsServices, long extraRbsNetwork) throws InvalidTxBodyException {
        FeeComponents.Builder feeComponentsBuilder = FeeComponents.newBuilder().setVpt(sigValObj.getTotalSigCount()).setSbh(0L).setGas(0L).setTv(0L).setBpr(4L).setSbpr(0L);
        feeComponentsBuilder.setBpt(ConsensusServiceFeeBuilder.getCommonTransactionBodyBytes(txBody) + txBodyDataSize + sigValObj.getSignatureSize());
        feeComponentsBuilder.setRbh((long)(ConsensusServiceFeeBuilder.getBaseTransactionRecordSize(txBody) * 180) + extraRbsServices);
        long rbsNetwork = ConsensusServiceFeeBuilder.getDefaultRBHNetworkSize() + extraRbsNetwork;
        return ConsensusServiceFeeBuilder.getFeeDataMatrices(feeComponentsBuilder.build(), sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public static int getTopicRamBytes(int variableSize) {
        return 100 + variableSize;
    }

    public static int computeVariableSizedFieldsUsage(Key adminKey, Key submitKey, String memo, boolean hasAutoRenewAccount) {
        int size = 0;
        if (memo != null) {
            size += memo.getBytes(Charsets.UTF_8).length;
        }
        size += ConsensusServiceFeeBuilder.getAccountKeyStorageSize(adminKey);
        size += ConsensusServiceFeeBuilder.getAccountKeyStorageSize(submitKey);
        return size += hasAutoRenewAccount ? 24 : 0;
    }
}

