/*
 * Decompiled with CFR 0.152.
 */
package com.hederahashgraph.fee;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.services.legacy.proto.utils.CommonUtils;
import com.hederahashgraph.api.proto.java.ContractFunctionResult;
import com.hederahashgraph.api.proto.java.ExchangeRate;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.LiveHash;
import com.hederahashgraph.api.proto.java.ResponseType;
import com.hederahashgraph.api.proto.java.Transaction;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.api.proto.java.TransactionRecord;
import com.hederahashgraph.exception.InvalidTxBodyException;
import com.hederahashgraph.fee.FeeObject;
import java.math.BigInteger;
import java.util.List;

public class FeeBuilder {
    public static final int LONG_SIZE = 8;
    public static final int FEE_MATRICES_CONST = 1;
    public static final int INT_SIZE = 4;
    public static final int BOOL_SIZE = 4;
    public static final int SOLIDITY_ADDRESS = 20;
    public static final int KEY_SIZE = 32;
    public static final int TX_HASH_SIZE = 48;
    public static final int DEFAULT_PAYER_ACC_SIG_COUNT = 0;
    public static final int RECEIPT_STORAGE_TIME_SEC = 180;
    public static final int THRESHOLD_STORAGE_TIME_SEC = 90000;
    public static final int DEFAULT_RBS_NETWORK = 0;
    public static final int FEE_DIVISOR_FACTOR = 1000;
    public static final int SIGNATURE_SIZE = 64;
    public static final int HRS_DIVISOR = 3600;
    public static final int BASIC_ENTITY_ID_SIZE = 24;
    public static final int BASIC_RICH_INSTANT_SIZE = 12;
    public static final int BASIC_ACCOUNT_AMT_SIZE = 32;
    public static final int BASIC_TX_ID_SIZE = 32;
    public static final int EXCHANGE_RATE_SIZE = 16;
    public static final int BASIC_RECEIPT_SIZE = 36;
    public static final int BASIC_TX_BODY_SIZE = 76;
    public static final int STATE_PROOF_SIZE = 2000;
    public static final int BASE_FILEINFO_SIZE = 44;
    public static final int BASIC_ACCOUNT_SIZE = 68;
    public static final int BASIC_QUERY_RES_HEADER = 16;
    public static final int BASIC_QUERY_HEADER = 212;
    public static final int BASIC_CONTRACT_CREATE_SIZE = 72;
    public static final int BASIC_CONTRACT_INFO_SIZE = 100;
    public static final int BASIC_TX_RECORD_SIZE = 132;

    public static long getComponentFeeInTinyCents(FeeComponents componentCoefficients, FeeComponents componentMetrics) {
        long bytesUsageFee = componentCoefficients.getBpt() * componentMetrics.getBpt();
        long verificationFee = componentCoefficients.getVpt() * componentMetrics.getVpt();
        long ramStorageFee = componentCoefficients.getRbh() * componentMetrics.getRbh();
        long storageFee = componentCoefficients.getSbh() * componentMetrics.getSbh();
        long evmGasFee = componentCoefficients.getGas() * componentMetrics.getGas();
        long txValueFee = Math.round(componentCoefficients.getTv() * componentMetrics.getTv() / 1000L);
        long bytesResponseFee = componentCoefficients.getBpr() * componentMetrics.getBpr();
        long storageBytesResponseFee = componentCoefficients.getSbpr() * componentMetrics.getSbpr();
        long componentUsage = componentCoefficients.getConstant() * componentMetrics.getConstant();
        long totalComponentFee = componentUsage + (bytesUsageFee + verificationFee + ramStorageFee + storageFee + evmGasFee + txValueFee + bytesResponseFee + storageBytesResponseFee);
        if (totalComponentFee < componentCoefficients.getMin()) {
            totalComponentFee = componentCoefficients.getMin();
        } else if (totalComponentFee > componentCoefficients.getMax()) {
            totalComponentFee = componentCoefficients.getMax();
        }
        return Math.max(totalComponentFee > 0L ? 1L : 0L, totalComponentFee / 1000L);
    }

    public static long getTotalFeeforRequest(FeeData feeCoefficients, FeeData componentMetrics, ExchangeRate exchangeRate) {
        FeeObject feeObject = FeeBuilder.getFeeObject(feeCoefficients, componentMetrics, exchangeRate);
        long totalFee = feeObject.getServiceFee() + feeObject.getNodeFee() + feeObject.getNetworkFee();
        return totalFee;
    }

    public static FeeObject getFeeObject(FeeData feeData, FeeData feeMatrices, ExchangeRate exchangeRate) {
        long networkFee = FeeBuilder.getComponentFeeInTinyCents(feeData.getNetworkdata(), feeMatrices.getNetworkdata());
        long nodeFee = FeeBuilder.getComponentFeeInTinyCents(feeData.getNodedata(), feeMatrices.getNodedata());
        long serviceFee = FeeBuilder.getComponentFeeInTinyCents(feeData.getServicedata(), feeMatrices.getServicedata());
        networkFee = FeeBuilder.getTinybarsFromTinyCents(exchangeRate, networkFee);
        nodeFee = FeeBuilder.getTinybarsFromTinyCents(exchangeRate, nodeFee);
        serviceFee = FeeBuilder.getTinybarsFromTinyCents(exchangeRate, serviceFee);
        return new FeeObject(nodeFee, networkFee, serviceFee);
    }

    public static int getCommonTransactionBodyBytes(TransactionBody txBody) throws InvalidTxBodyException {
        if (txBody == null) {
            throw new InvalidTxBodyException("Transaction Body not available for Fee Calculation");
        }
        int memoSize = 0;
        if (txBody.getMemo() != null) {
            memoSize = txBody.getMemoBytes().size();
        }
        return 76 + memoSize;
    }

    public static int getAccountKeyStorageSize(Key key) {
        if (key == null) {
            return 0;
        }
        if (key == Key.getDefaultInstance()) {
            return 0;
        }
        int keyStorageSize = 0;
        try {
            int[] countKeyMetatData = new int[]{0, 0};
            countKeyMetatData = FeeBuilder.calculateKeysMetadata(key, countKeyMetatData);
            keyStorageSize = countKeyMetatData[0] * 32 + countKeyMetatData[1] * 4;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keyStorageSize;
    }

    public static int[] calculateKeysMetadata(Key key, int[] count) {
        if (key.hasKeyList()) {
            List<Key> keyList = key.getKeyList().getKeysList();
            for (int i = 0; i < keyList.size(); ++i) {
                count = FeeBuilder.calculateKeysMetadata(keyList.get(i), count);
            }
        } else if (key.hasThresholdKey()) {
            List<Key> keyList = key.getThresholdKey().getKeys().getKeysList();
            count[1] = count[1] + 1;
            for (int i = 0; i < keyList.size(); ++i) {
                count = FeeBuilder.calculateKeysMetadata(keyList.get(i), count);
            }
        } else {
            count[0] = count[0] + 1;
        }
        return count;
    }

    public static FeeData getCostForQueryByIDOnly() {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 28L;
        bpr = 16L;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FeeData.getDefaultInstance();
    }

    public static FeeComponents getDefaultMatrices() {
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(0L).setVpt(0L).setRbh(0L).setSbh(0L).setGas(0L).setTv(0L).setBpr(0L).setSbpr(0L).build();
        return feeMatricesForTx;
    }

    public static int sizeOfLiveHashKeyStorage(Key key) {
        int keyStorageSize = 0;
        try {
            int[] countKeyMetatData = new int[]{0, 0};
            countKeyMetatData = FeeBuilder.calculateKeysMetadata(key, countKeyMetatData);
            keyStorageSize = countKeyMetatData[0] * 32 + countKeyMetatData[1] * 4;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keyStorageSize;
    }

    public static int getSignatureCount(Transaction transaction) {
        try {
            return CommonUtils.extractSignatureMap(transaction).getSigPairCount();
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            return 0;
        }
    }

    public static int getSignatureSize(Transaction transaction) {
        try {
            return CommonUtils.extractSignatureMap(transaction).toByteArray().length;
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            return 0;
        }
    }

    public static long getTinybarsFromTinyCents(ExchangeRate exchangeRate, long tinyCentsFee) {
        BigInteger hbarMultiplier = BigInteger.valueOf(exchangeRate.getHbarEquiv());
        BigInteger centsDivisor = BigInteger.valueOf(exchangeRate.getCentEquiv());
        BigInteger feeInBigInt = BigInteger.valueOf(tinyCentsFee);
        feeInBigInt = feeInBigInt.multiply(hbarMultiplier);
        feeInBigInt = feeInBigInt.divide(centsDivisor);
        return feeInBigInt.longValue();
    }

    public static FeeData getFeeDataMatrices(FeeComponents feeComponents, int payerVpt, long rbsNetwork) {
        long rbh = Math.max(feeComponents.getRbh() > 0L ? 1L : 0L, feeComponents.getRbh() / 3600L);
        long sbh = Math.max(feeComponents.getSbh() > 0L ? 1L : 0L, feeComponents.getSbh() / 3600L);
        long rbhNetwork = Math.max(rbsNetwork > 0L ? 1L : 0L, rbsNetwork / 3600L);
        FeeComponents feeMatricesForTxService = FeeComponents.newBuilder().setConstant(1L).setRbh(rbh).setSbh(sbh).setTv(feeComponents.getTv()).build();
        FeeComponents feeMatricesForTxNetwork = FeeComponents.newBuilder().setConstant(1L).setBpt(feeComponents.getBpt()).setVpt(feeComponents.getVpt()).setRbh(rbhNetwork).build();
        FeeComponents feeMatricesForTxNode = FeeComponents.newBuilder().setConstant(1L).setBpt(feeComponents.getBpt()).setVpt(payerVpt).setBpr(feeComponents.getBpr()).setSbpr(feeComponents.getSbpr()).build();
        FeeData feeDataMatrices = FeeData.newBuilder().setNetworkdata(feeMatricesForTxNetwork).setNodedata(feeMatricesForTxNode).setServicedata(feeMatricesForTxService).build();
        return feeDataMatrices;
    }

    public static FeeData getQueryFeeDataMatrices(FeeComponents feeComponents) {
        FeeComponents feeMatricesForTxService = FeeComponents.getDefaultInstance();
        FeeComponents feeMatricesForTxNetwork = FeeComponents.getDefaultInstance();
        FeeComponents feeMatricesForTxNode = FeeComponents.newBuilder().setConstant(1L).setBpt(feeComponents.getBpt()).setBpr(feeComponents.getBpr()).setSbpr(feeComponents.getSbpr()).build();
        FeeData feeDataMatrices = FeeData.newBuilder().setNetworkdata(feeMatricesForTxNetwork).setNodedata(feeMatricesForTxNode).setServicedata(feeMatricesForTxService).build();
        return feeDataMatrices;
    }

    public static long getDefaultRBHNetworkSize() {
        return 6480L;
    }

    public static int getBaseTransactionRecordSize(TransactionBody txBody) {
        int txRecordSize = 132;
        if (txBody.getMemo() != null) {
            txRecordSize += txBody.getMemoBytes().size();
        }
        if (txBody.hasCryptoTransfer()) {
            txRecordSize += txBody.getCryptoTransfer().getTransfers().getAccountAmountsCount() * 32;
        }
        return txRecordSize;
    }

    public static long getTxRecordUsageRBH(TransactionRecord txRecord, int timeInSeconds) {
        if (txRecord == null) {
            return 0L;
        }
        long txRecordSize = FeeBuilder.getTransactionRecordSize(txRecord);
        return txRecordSize * (long)FeeBuilder.getHoursFromSec(timeInSeconds);
    }

    public static int getHoursFromSec(int valueInSeconds) {
        return valueInSeconds == 0 ? 0 : Math.max(1, valueInSeconds / 3600);
    }

    public static int getTransactionRecordSize(TransactionRecord txRecord) {
        if (txRecord == null) {
            return 0;
        }
        int txRecordSize = 132;
        if (txRecord.hasContractCallResult()) {
            txRecordSize += FeeBuilder.getContractFunctionSize(txRecord.getContractCallResult());
        } else if (txRecord.hasContractCreateResult()) {
            txRecordSize += FeeBuilder.getContractFunctionSize(txRecord.getContractCreateResult());
        }
        if (txRecord.hasTransferList()) {
            txRecordSize += txRecord.getTransferList().getAccountAmountsCount() * 32;
        }
        int memoBytesSize = 0;
        if (txRecord.getMemo() != null) {
            memoBytesSize = txRecord.getMemoBytes().size();
        }
        return txRecordSize + memoBytesSize;
    }

    public static int getContractFunctionSize(ContractFunctionResult contFuncResult) {
        int contResult = 0;
        if (contFuncResult.getContractCallResult() != null) {
            contResult = contFuncResult.getContractCallResult().size();
        }
        if (contFuncResult.getErrorMessage() != null) {
            contResult += contFuncResult.getErrorMessageBytes().size();
        }
        if (contFuncResult.getBloom() != null) {
            contResult += contFuncResult.getBloom().size();
        }
        contResult = contResult + 8 + 16;
        return contResult;
    }

    public static long getTransactionRecordFeeInTinyCents(TransactionRecord txRecord, long feeCoeffRBH, int timeInSec) {
        if (txRecord == null) {
            return 0L;
        }
        long txRecordUsageRBH = FeeBuilder.getTxRecordUsageRBH(txRecord, timeInSec);
        long rawFee = txRecordUsageRBH * feeCoeffRBH;
        return Math.max(rawFee > 0L ? 1L : 0L, rawFee / 1000L);
    }

    public static int getQueryTransactionSize() {
        int commonTxBodyBytes = 76;
        return commonTxBodyBytes + 32 + 64 + 4;
    }

    public static int liveHashSize(List<LiveHash> liveHashes) {
        int liveHashsKeySize = 0;
        int liveHashDataSize = 0;
        int liveHashsAccountID = 0;
        if (liveHashes != null) {
            int liveHashsListSize = liveHashes.size();
            liveHashDataSize = 48 * liveHashsListSize;
            liveHashsAccountID = 24 * liveHashsListSize;
            for (LiveHash liveHashs : liveHashes) {
                List<Key> keyList = liveHashs.getKeys().getKeysList();
                for (Key key : keyList) {
                    liveHashsKeySize += FeeBuilder.getAccountKeyStorageSize(key);
                }
            }
        }
        return liveHashsKeySize + liveHashDataSize + liveHashsAccountID;
    }

    public static int getStateProofSize(ResponseType responseType) {
        return responseType == ResponseType.ANSWER_STATE_PROOF || responseType == ResponseType.COST_ANSWER_STATE_PROOF ? 2000 : 0;
    }
}

