/*
 * Decompiled with CFR 0.152.
 */
package com.hederahashgraph.fee;

import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.FileAppendTransactionBody;
import com.hederahashgraph.api.proto.java.FileCreateTransactionBody;
import com.hederahashgraph.api.proto.java.FileUpdateTransactionBody;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.KeyList;
import com.hederahashgraph.api.proto.java.ResponseType;
import com.hederahashgraph.api.proto.java.Timestamp;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.builder.RequestBuilder;
import com.hederahashgraph.exception.InvalidTxBodyException;
import com.hederahashgraph.fee.FeeBuilder;
import com.hederahashgraph.fee.SigValueObj;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class FileFeeBuilder
extends FeeBuilder {
    public FeeData getFileCreateTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasFileCreate()) {
            throw new InvalidTxBodyException("FileCreate Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = 0;
        txBodySize = FileFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + this.getFileCreateTxSize(txBody) + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        sbs = this.getFileCreateStorageBytesSec(txBody);
        bpr = 4L;
        rbs = (FileFeeBuilder.getBaseTransactionRecordSize(txBody) + 24) * 180;
        long rbsNetwork = FileFeeBuilder.getDefaultRBHNetworkSize() + 4320L;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getFileUpdateTxFeeMatrices(TransactionBody txBody, Timestamp expirationTimeStamp, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasFileUpdate()) {
            throw new InvalidTxBodyException("FileUpdate Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        FileUpdateTransactionBody fileUpdateTxBody = txBody.getFileUpdate();
        int txBodySize = 0;
        txBodySize = FileFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + FileFeeBuilder.getFileUpdateBodyTxSize(txBody) + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        int sbsStorageSize = 0;
        if (fileUpdateTxBody.hasKeys()) {
            List<Key> waclKeys = fileUpdateTxBody.getKeys().getKeysList();
            int keySize = 0;
            for (Key key : waclKeys) {
                keySize += FileFeeBuilder.getAccountKeyStorageSize(key);
            }
            sbsStorageSize += keySize;
        }
        if (fileUpdateTxBody.getContents() != null) {
            sbsStorageSize += fileUpdateTxBody.getContents().size();
        }
        if (sbsStorageSize != 0 && expirationTimeStamp != null && expirationTimeStamp.getSeconds() > 0L) {
            Instant expirationTime = RequestBuilder.convertProtoTimeStamp(expirationTimeStamp);
            Timestamp txValidStartTimestamp = txBody.getTransactionID().getTransactionValidStart();
            Instant txValidStartTime = RequestBuilder.convertProtoTimeStamp(txValidStartTimestamp);
            Duration duration = Duration.between(txValidStartTime, expirationTime);
            long seconds = duration.getSeconds();
            sbs = (long)sbsStorageSize * seconds;
        }
        rbs = FileFeeBuilder.getBaseTransactionRecordSize(txBody) * 180;
        long rbsNetwork = FileFeeBuilder.getDefaultRBHNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getFileAppendTxFeeMatrices(TransactionBody txBody, Timestamp expirationTimeStamp, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasFileAppend()) {
            throw new InvalidTxBodyException("FileAppend Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        FileAppendTransactionBody fileAppendTxBody = txBody.getFileAppend();
        int txBodySize = 0;
        txBodySize = FileFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + sigValObj.getSignatureSize();
        int fileContentSize = 0;
        if (fileAppendTxBody.getContents() != null) {
            fileContentSize = fileAppendTxBody.getContents().size();
        }
        bpt += (long)fileContentSize;
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        int sbsStorageSize = fileContentSize;
        if (sbsStorageSize != 0 && expirationTimeStamp != null && expirationTimeStamp.getSeconds() > 0L) {
            Instant expirationTime = RequestBuilder.convertProtoTimeStamp(expirationTimeStamp);
            Timestamp txValidStartTimestamp = txBody.getTransactionID().getTransactionValidStart();
            Instant txValidStartTime = RequestBuilder.convertProtoTimeStamp(txValidStartTimestamp);
            Duration duration = Duration.between(txValidStartTime, expirationTime);
            long seconds = duration.getSeconds();
            sbs = (long)sbsStorageSize * seconds;
        }
        rbs = FileFeeBuilder.getBaseTransactionRecordSize(txBody) * 180;
        long rbsNetwork = FileFeeBuilder.getDefaultRBHNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getFileInfoQueryFeeMatrices(KeyList keys, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 236L;
        int keySize = 0;
        if (keys != null) {
            List<Key> waclKeys = keys.getKeysList();
            for (Key key : waclKeys) {
                keySize += FileFeeBuilder.getAccountKeyStorageSize(key);
            }
        }
        bpr = 16 + FileFeeBuilder.getStateProofSize(responseType);
        sbpr = 44 + keySize;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getFileContentQueryFeeMatrices(int contentSize, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 236L;
        bpr = 16 + FileFeeBuilder.getStateProofSize(responseType);
        sbpr = 24 + contentSize;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    private int getFileCreateTxSize(TransactionBody txBody) {
        FileCreateTransactionBody fileCreateTxBody = txBody.getFileCreate();
        List<Key> waclKeys = fileCreateTxBody.getKeys().getKeysList();
        int keySize = 0;
        for (Key key : waclKeys) {
            keySize += FileFeeBuilder.getAccountKeyStorageSize(key);
        }
        int newRealmAdminKeySize = 0;
        if (fileCreateTxBody.hasNewRealmAdminKey()) {
            newRealmAdminKeySize = FileFeeBuilder.getAccountKeyStorageSize(fileCreateTxBody.getNewRealmAdminKey());
        }
        int fileContentsSize = 0;
        if (fileCreateTxBody.getContents() != null) {
            fileContentsSize = fileCreateTxBody.getContents().size();
        }
        int cryptoFileCreateSize = 8 + keySize + fileContentsSize + 24 + newRealmAdminKeySize;
        return cryptoFileCreateSize;
    }

    public static int getFileUpdateBodyTxSize(TransactionBody txBody) {
        int fileUpdateBodySize = 24;
        FileUpdateTransactionBody fileUpdateTxBody = txBody.getFileUpdate();
        if (fileUpdateTxBody.hasKeys()) {
            List<Key> waclKeys = fileUpdateTxBody.getKeys().getKeysList();
            int keySize = 0;
            for (Key key : waclKeys) {
                keySize += FileFeeBuilder.getAccountKeyStorageSize(key);
            }
            fileUpdateBodySize += keySize;
        }
        if (fileUpdateTxBody.hasExpirationTime()) {
            fileUpdateBodySize += 8;
        }
        if (fileUpdateTxBody.getContents() != null) {
            fileUpdateBodySize += fileUpdateTxBody.getContents().size();
        }
        return fileUpdateBodySize;
    }

    private long getFileCreateStorageBytesSec(TransactionBody txBody) {
        long storageSize = this.getFileCreateTxSize(txBody) + 8 + 4;
        Timestamp expirationTimeStamp = txBody.getFileCreate().getExpirationTime();
        if (expirationTimeStamp == null) {
            return 0L;
        }
        Instant expirationTime = RequestBuilder.convertProtoTimeStamp(expirationTimeStamp);
        Timestamp txValidStartTimestamp = txBody.getTransactionID().getTransactionValidStart();
        Instant txValidStartTime = RequestBuilder.convertProtoTimeStamp(txValidStartTimestamp);
        Duration duration = Duration.between(txValidStartTime, expirationTime);
        long seconds = duration.getSeconds();
        return storageSize *= seconds;
    }

    public FeeData getSystemDeleteFileTxFeeMatrices(TransactionBody txBody, SigValueObj numSignatures) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasSystemDelete()) {
            throw new InvalidTxBodyException("System Delete Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = FileFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = bpt + 24L + 8L;
        vpt = numSignatures.getTotalSigCount();
        rbs = FileFeeBuilder.getBaseTransactionRecordSize(txBody) * 180;
        long rbsNetwork = FileFeeBuilder.getDefaultRBHNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getFeeDataMatrices(feeMatricesForTx, numSignatures.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getSystemUnDeleteFileTxFeeMatrices(TransactionBody txBody, SigValueObj numSignatures) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasSystemUndelete()) {
            throw new InvalidTxBodyException("System UnDelete Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = FileFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = bpt + 24L + 8L;
        vpt = numSignatures.getTotalSigCount();
        rbs = FileFeeBuilder.getBaseTransactionRecordSize(txBody) * 180;
        long rbsNetwork = FileFeeBuilder.getDefaultRBHNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getFeeDataMatrices(feeMatricesForTx, numSignatures.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getFileDeleteTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasFileDelete()) {
            throw new InvalidTxBodyException("FileDelete Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = 0;
        txBodySize = FileFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + 24 + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        rbs = FileFeeBuilder.getBaseTransactionRecordSize(txBody) * 180;
        long rbsNetwork = FileFeeBuilder.getDefaultRBHNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FileFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }
}

