/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.services.legacy.proto.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.hedera.services.legacy.proto.utils.ProtoCommonUtils;
import com.hederahashgraph.api.proto.java.SignatureMap;
import com.hederahashgraph.api.proto.java.SignedTransaction;
import com.hederahashgraph.api.proto.java.Transaction;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.api.proto.java.TransactionOrBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class CommonUtils {
    public static void napMillis(long timeInMillis) throws InterruptedException {
        Thread.sleep(timeInMillis);
    }

    public static void nap(int timeInSec) throws InterruptedException {
        Thread.sleep(timeInSec * 1000);
    }

    public static void nap(double timeInSec) throws InterruptedException {
        Thread.sleep((long)timeInSec * 1000L);
    }

    public static void writeToFile(String path, byte[] data) throws IOException {
        CommonUtils.writeToFile(path, data, false);
    }

    public static void writeToFile(String path, byte[] data, boolean append) throws IOException {
        File f = new File(path);
        File parent = f.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(f, append);){
            fos.write(data);
            fos.flush();
        }
    }

    public static void writeToFileUTF8(String path, String data) throws IOException {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        CommonUtils.writeToFile(path, bytes);
    }

    public static void writeToFileUTF8(String path, String data, boolean append) throws IOException {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        CommonUtils.writeToFile(path, bytes, append);
    }

    public static String base64encode(byte[] bytes) {
        String rv = null;
        rv = Base64.getEncoder().encodeToString(bytes);
        return rv;
    }

    public static byte[] convertToBytes(Object object) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(object);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    public static byte[] copyBytes(int start, int length, byte[] bytes) {
        byte[] rv = new byte[length];
        for (int i = 0; i < length; ++i) {
            rv[i] = bytes[start + i];
        }
        return rv;
    }

    public static byte[] hexToBytes(String data) throws DecoderException {
        byte[] rv = new byte[]{};
        rv = Hex.decodeHex((String)data);
        return rv;
    }

    public static byte[] readBinaryFileAsResource(String filePath) throws IOException, URISyntaxException {
        if (ClassLoader.getSystemResource("") == null) {
            return Files.readAllBytes(Paths.get("", filePath));
        }
        URI uri = ClassLoader.getSystemResource("").toURI();
        String rootPath = Paths.get(uri).toString();
        Path path = Paths.get(rootPath, filePath);
        return Files.readAllBytes(path);
    }

    public static <T> byte[] readBinaryFileAsResource(String filePath, Class<T> myClass) throws IOException, URISyntaxException {
        Path path = Paths.get(myClass.getClassLoader().getResource(filePath).toURI());
        return Files.readAllBytes(path);
    }

    public static String[] splitLine(String line) {
        String[] elms = line.split(",");
        for (int i = 0; i < elms.length; ++i) {
            elms[i] = elms[i].trim();
        }
        return elms;
    }

    public static String toReadableString(Transaction grpcTransaction) throws InvalidProtocolBufferException {
        String rv = null;
        TransactionBody body = CommonUtils.extractTransactionBody(grpcTransaction);
        rv = "body=" + TextFormat.shortDebugString((MessageOrBuilder)body) + "; sigs=" + TextFormat.shortDebugString((MessageOrBuilder)CommonUtils.extractSignatureMap(grpcTransaction));
        return rv;
    }

    public static String toReadableTransactionID(Transaction grpcTransaction) throws InvalidProtocolBufferException {
        TransactionBody body = CommonUtils.extractTransactionBody(grpcTransaction);
        String rv = "txID=" + TextFormat.shortDebugString((MessageOrBuilder)body.getTransactionID());
        return rv;
    }

    public static ByteString extractTransactionBodyByteString(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        ByteString signedTransactionBytes = transaction.getSignedTransactionBytes();
        if (!signedTransactionBytes.isEmpty()) {
            return SignedTransaction.parseFrom(signedTransactionBytes).getBodyBytes();
        }
        return transaction.getBodyBytes();
    }

    public static byte[] extractTransactionBodyBytes(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        return CommonUtils.extractTransactionBodyByteString(transaction).toByteArray();
    }

    public static TransactionBody extractTransactionBody(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        return TransactionBody.parseFrom(CommonUtils.extractTransactionBodyByteString(transaction));
    }

    public static SignatureMap extractSignatureMap(TransactionOrBuilder transaction) throws InvalidProtocolBufferException {
        ByteString signedTransactionBytes = transaction.getSignedTransactionBytes();
        if (!signedTransactionBytes.isEmpty()) {
            return SignedTransaction.parseFrom(signedTransactionBytes).getSigMap();
        }
        return transaction.getSigMap();
    }

    public static SignatureMap extractSignatureMapOrUseDefault(TransactionOrBuilder transaction) {
        try {
            return CommonUtils.extractSignatureMap(transaction);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            return SignatureMap.getDefaultInstance();
        }
    }

    public static Transaction.Builder toTransactionBuilder(TransactionOrBuilder transactionOrBuilder) {
        if (transactionOrBuilder instanceof Transaction) {
            return ((Transaction)transactionOrBuilder).toBuilder();
        }
        return (Transaction.Builder)transactionOrBuilder;
    }

    public static MessageDigest getSha384Hash() throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-384");
    }

    public static byte[] noThrowSha384HashOf(byte[] byteArray) {
        try {
            return CommonUtils.getSha384Hash().digest(byteArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return new byte[0];
        }
    }

    public static ByteString sha384HashOf(byte[] byteArray) {
        return ByteString.copyFrom((byte[])CommonUtils.noThrowSha384HashOf(byteArray));
    }

    public static ByteString sha384HashOf(Transaction transaction) {
        if (transaction.getSignedTransactionBytes().isEmpty()) {
            return CommonUtils.sha384HashOf(transaction.toByteArray());
        }
        return CommonUtils.sha384HashOf(transaction.getSignedTransactionBytes().toByteArray());
    }

    public static void writeTxId2File(String txIdString) throws IOException {
        CommonUtils.writeToFileUTF8("output/txIds.txt", ProtoCommonUtils.getCurrentInstantUTC() + "-->" + txIdString + "\n", true);
    }
}

