/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.services.legacy.proto.utils;

import com.google.protobuf.ByteString;
import com.hedera.services.legacy.proto.utils.AtomicCounter;
import com.hedera.services.legacy.proto.utils.CommonUtils;
import com.hedera.services.legacy.proto.utils.SignatureGenerator;
import com.hedera.services.legacy.proto.utils.SignatureVerifier;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.KeyList;
import com.hederahashgraph.api.proto.java.Signature;
import com.hederahashgraph.api.proto.java.SignatureList;
import com.hederahashgraph.api.proto.java.SignaturePair;
import com.hederahashgraph.api.proto.java.ThresholdKey;
import com.hederahashgraph.api.proto.java.ThresholdSignature;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;

public class KeyExpansion {
    private static final Logger log = LogManager.getLogger(KeyExpansion.class);
    public static int KEY_EXPANSION_DEPTH = 15;
    public static boolean USE_HEX_ENCODED_KEY = false;

    public static void expandKey(Key key, int depth, List<Key> expandedKeys) {
        block4: {
            block5: {
                block3: {
                    if (key.hasThresholdKey() || key.hasKeyList()) break block3;
                    expandedKeys.add(key);
                    break block4;
                }
                if (!key.hasThresholdKey()) break block5;
                List<Key> tKeys = key.getThresholdKey().getKeys().getKeysList();
                if (depth > KEY_EXPANSION_DEPTH) break block4;
                ++depth;
                for (Key aKey : tKeys) {
                    KeyExpansion.expandKey(aKey, depth, expandedKeys);
                }
                break block4;
            }
            List<Key> tKeys = key.getKeyList().getKeysList();
            if (depth <= KEY_EXPANSION_DEPTH) {
                ++depth;
                for (Key aKey : tKeys) {
                    KeyExpansion.expandKey(aKey, depth, expandedKeys);
                }
            }
        }
    }

    public static Key genKeyList(List<Key> keys) {
        KeyList tkey = KeyList.newBuilder().addAllKeys(keys).build();
        Key rv = Key.newBuilder().setKeyList(tkey).build();
        return rv;
    }

    public static List<Key> genEd25519Keys(int numKeys, Map<String, PrivateKey> pubKey2privKeyMap) {
        ArrayList<Key> rv = new ArrayList<Key>();
        for (int i = 0; i < numKeys; ++i) {
            Key akey = KeyExpansion.genSingleEd25519Key(pubKey2privKeyMap);
            rv.add(akey);
        }
        return rv;
    }

    public static void expandSignature(Signature signature, int depth, List<Signature> expandedSignatures) {
        block4: {
            block5: {
                block3: {
                    if (signature.hasThresholdSignature() || signature.hasSignatureList()) break block3;
                    expandedSignatures.add(signature);
                    break block4;
                }
                if (!signature.hasThresholdSignature()) break block5;
                List<Signature> tSignatures = signature.getThresholdSignature().getSigs().getSigsList();
                if (depth > KEY_EXPANSION_DEPTH) break block4;
                ++depth;
                for (Signature aSignature : tSignatures) {
                    KeyExpansion.expandSignature(aSignature, depth, expandedSignatures);
                }
                break block4;
            }
            List<Signature> tSignatures = signature.getSignatureList().getSigsList();
            if (depth <= KEY_EXPANSION_DEPTH) {
                ++depth;
                for (Signature aSignature : tSignatures) {
                    KeyExpansion.expandSignature(aSignature, depth, expandedSignatures);
                }
            }
        }
    }

    public static List<Key> expandKeyList(KeyList keyList) {
        ArrayList<Key> expandedKeys = new ArrayList<Key>();
        List<Key> keys = keyList.getKeysList();
        for (Key aKey : keys) {
            KeyExpansion.expandKey(aKey, 1, expandedKeys);
        }
        return expandedKeys;
    }

    public static List<Boolean> verifySignatureList(SignatureList signatureList, KeyList keyList, byte[] message) throws Exception {
        List<Signature> signatures = signatureList.getSigsList();
        List<Key> keys = keyList.getKeysList();
        ArrayList<Boolean> resultList = new ArrayList<Boolean>();
        for (int i = 0; i < signatures.size(); ++i) {
            Signature signature = signatures.get(i);
            Key key = keys.get(i);
            boolean result = KeyExpansion.verifySignature(key, signature, message, 1);
            resultList.add(result);
        }
        return resultList;
    }

    public static List<Signature> expandSignatureList(SignatureList signatureList) {
        ArrayList<Signature> expandedSignatures = new ArrayList<Signature>();
        List<Signature> signatures = signatureList.getSigsList();
        for (Signature aSignature : signatures) {
            KeyExpansion.expandSignature(aSignature, 1, expandedSignatures);
        }
        return expandedSignatures;
    }

    public static Key genThresholdKey(List<Key> keys, int threshold) {
        ThresholdKey tkey = ThresholdKey.newBuilder().setKeys(KeyList.newBuilder().addAllKeys(keys).build()).setThreshold(threshold).build();
        Key rv = Key.newBuilder().setThresholdKey(tkey).build();
        return rv;
    }

    public static int computeNumOfExpandedKeys(Key key, int depth, AtomicCounter counter) {
        if (!key.hasThresholdKey() && !key.hasKeyList()) {
            counter.increment();
            return counter.value();
        }
        List<Key> tKeys = null;
        tKeys = key.hasThresholdKey() ? key.getThresholdKey().getKeys().getKeysList() : key.getKeyList().getKeysList();
        if (depth <= KEY_EXPANSION_DEPTH) {
            ++depth;
            for (Key aKey : tKeys) {
                KeyExpansion.computeNumOfExpandedKeys(aKey, depth, counter);
            }
        }
        return counter.value();
    }

    public static boolean verifySignature(Key key, Signature signature, byte[] message, int depth) throws Exception {
        if (depth > KEY_EXPANSION_DEPTH) {
            log.warn("Exceeding max expansion depth of " + KEY_EXPANSION_DEPTH);
        }
        if (!key.hasThresholdKey() && !key.hasKeyList()) {
            boolean result = KeyExpansion.verifyBasic(key, signature, message);
            log.debug("depth=" + depth + "; verifyBasic: result=" + result + "; key=" + key);
            return result;
        }
        if (key.hasThresholdKey()) {
            List<Key> tKeys = key.getThresholdKey().getKeys().getKeysList();
            List<Signature> tSignatures = signature.getThresholdSignature().getSigs().getSigsList();
            int i = 0;
            int cnt = 0;
            for (Key aKey : tKeys) {
                Signature sig;
                boolean res = KeyExpansion.verifySignature(aKey, sig = tSignatures.get(i++), message, depth + 1);
                if (!res) continue;
                ++cnt;
            }
            int thd = key.getThresholdKey().getThreshold();
            boolean result = cnt >= thd;
            log.debug("depth=" + depth + "; hasThresholdKey: result=" + result + "; threshold=" + thd + "; verified=" + cnt);
            return result;
        }
        List<Key> tKeys = key.getKeyList().getKeysList();
        List<Signature> tSignatures = signature.getSignatureList().getSigsList();
        int i = 0;
        int cnt = 0;
        for (Key aKey : tKeys) {
            Signature sig;
            boolean res = KeyExpansion.verifySignature(aKey, sig = tSignatures.get(i++), message, depth + 1);
            if (!res) continue;
            ++cnt;
        }
        int thd = tKeys.size();
        boolean result = cnt == thd;
        log.debug("depth=" + depth + "; hasKeyList: result=" + result + "; size=" + thd + "; verified=" + cnt);
        return result;
    }

    private static boolean verifyBasic(Key key, Signature signature, byte[] messageBytes) throws Exception {
        boolean rv = false;
        if (key.hasContractID()) {
            rv = true;
        } else if (!key.getEd25519().isEmpty()) {
            byte[] pubKeyBytes = null;
            if (USE_HEX_ENCODED_KEY) {
                String pubKeyHex = key.getEd25519().toStringUtf8();
                pubKeyBytes = Hex.decodeHex((String)pubKeyHex);
            } else {
                pubKeyBytes = key.getEd25519().toByteArray();
            }
            byte[] sigBytes = signature.getEd25519().toByteArray();
            rv = sigBytes.length == 0 ? false : SignatureVerifier.verifyED25519(pubKeyBytes, messageBytes, sigBytes);
        } else if (!key.getECDSA384().isEmpty()) {
            byte[] pubKeyBytes = null;
            if (USE_HEX_ENCODED_KEY) {
                String pubKeyHex = key.getECDSA384().toStringUtf8();
                pubKeyBytes = Hex.decodeHex((String)pubKeyHex);
            } else {
                pubKeyBytes = key.getECDSA384().toByteArray();
            }
            byte[] sigBytes = signature.getECDSA384().toByteArray();
            String pubKeyHex = Hex.encodeHexString((byte[])pubKeyBytes);
            String message = new String(messageBytes, "UTF-8");
            String sigHex = Hex.encodeHexString((byte[])sigBytes);
            rv = sigBytes.length == 0 ? false : SignatureVerifier.verifyECDSA(pubKeyHex, message, sigHex);
        } else {
            throw new Exception("Key type not implemented: key=" + key);
        }
        return rv;
    }

    public static Signature sign(Key key, byte[] message, Map<String, PrivateKey> pubKey2privKeyMap, int depth) throws Exception {
        if (depth > KEY_EXPANSION_DEPTH) {
            log.warn("Exceeding max expansion depth of " + KEY_EXPANSION_DEPTH);
        }
        if (!key.hasThresholdKey() && !key.hasKeyList()) {
            Signature result = KeyExpansion.signBasic(key, pubKey2privKeyMap, message);
            log.debug("depth=" + depth + "; signBasic: result=" + result + "; key=" + key);
            return result;
        }
        if (key.hasThresholdKey()) {
            List<Key> tKeys = key.getThresholdKey().getKeys().getKeysList();
            ArrayList<Signature> signatures = new ArrayList<Signature>();
            int cnt = 0;
            int thd = key.getThresholdKey().getThreshold();
            Signature signature = null;
            for (Key aKey : tKeys) {
                if (cnt < thd) {
                    signature = KeyExpansion.sign(aKey, message, pubKey2privKeyMap, depth + 1);
                    ++cnt;
                } else {
                    signature = KeyExpansion.genEmptySignature();
                }
                signatures.add(signature);
            }
            Signature result = Signature.newBuilder().setThresholdSignature(ThresholdSignature.newBuilder().setSigs(SignatureList.newBuilder().addAllSigs(signatures).build()).build()).build();
            log.debug("depth=" + depth + "; sign ThresholdKey: result=" + result + "; threshold=" + thd);
            return result;
        }
        List<Key> tKeys = key.getKeyList().getKeysList();
        ArrayList<Signature> signatures = new ArrayList<Signature>();
        Signature signature = null;
        for (Key aKey : tKeys) {
            signature = KeyExpansion.sign(aKey, message, pubKey2privKeyMap, depth + 1);
            signatures.add(signature);
        }
        Signature result = Signature.newBuilder().setSignatureList(SignatureList.newBuilder().addAllSigs(signatures).build()).build();
        log.debug("depth=" + depth + "; sign KeyList: result=" + result);
        return result;
    }

    private static Signature genEmptySignature() throws DecoderException {
        String EMPTY_STR = "";
        Signature rv = Signature.newBuilder().setEd25519(ByteString.copyFrom((byte[])Hex.decodeHex((String)EMPTY_STR))).build();
        return rv;
    }

    private static Signature signBasic(Key key, Map<String, PrivateKey> pubKey2privKeyMap, byte[] msgBytes) throws Exception {
        Signature rv;
        if (key.hasContractID()) {
            rv = KeyExpansion.genEmptySignature();
        } else if (!key.getEd25519().isEmpty()) {
            String pubKeyHex = null;
            if (USE_HEX_ENCODED_KEY) {
                pubKeyHex = key.getEd25519().toStringUtf8();
            } else {
                byte[] pubKeyBytes = key.getEd25519().toByteArray();
                pubKeyHex = Hex.encodeHexString((byte[])pubKeyBytes);
            }
            PrivateKey privKey = pubKey2privKeyMap.get(pubKeyHex);
            String sigHex = SignatureGenerator.signBytes(msgBytes, privKey);
            rv = Signature.newBuilder().setEd25519(ByteString.copyFrom((byte[])Hex.decodeHex((String)sigHex))).build();
        } else if (!key.getECDSA384().isEmpty()) {
            String pubKeyHex = null;
            if (USE_HEX_ENCODED_KEY) {
                pubKeyHex = key.getECDSA384().toStringUtf8();
            } else {
                byte[] pubKeyBytes = key.getECDSA384().toByteArray();
                pubKeyHex = Hex.encodeHexString((byte[])pubKeyBytes);
            }
            PrivateKey privKey = pubKey2privKeyMap.get(pubKeyHex);
            String sigHex = SignatureGenerator.signBytes(msgBytes, privKey);
            rv = Signature.newBuilder().setECDSA384(ByteString.copyFrom((byte[])Hex.decodeHex((String)sigHex))).build();
        } else {
            throw new Exception("Key type not implemented: key=" + key);
        }
        return rv;
    }

    public static Key genSingleEd25519Key(Map<String, PrivateKey> pubKey2privKeyMap) {
        KeyPair pair = new KeyPairGenerator().generateKeyPair();
        byte[] pubKey = ((EdDSAPublicKey)pair.getPublic()).getAbyte();
        String pubKeyHex = null;
        Key akey = null;
        if (USE_HEX_ENCODED_KEY) {
            pubKeyHex = Hex.encodeHexString((byte[])pubKey);
            akey = Key.newBuilder().setEd25519(ByteString.copyFromUtf8((String)pubKeyHex)).build();
        } else {
            pubKeyHex = Hex.encodeHexString((byte[])pubKey);
            akey = Key.newBuilder().setEd25519(ByteString.copyFrom((byte[])pubKey)).build();
        }
        pubKey2privKeyMap.put(pubKeyHex, pair.getPrivate());
        return akey;
    }

    public static Key genEd25519Key(PublicKey pubKey) {
        byte[] pubKeyBytes = ((EdDSAPublicKey)pubKey).getAbyte();
        Key akey = Key.newBuilder().setEd25519(ByteString.copyFrom((byte[])pubKeyBytes)).build();
        return akey;
    }

    public static Key genSampleComplexKey(int depth, Map<String, PrivateKey> pubKey2privKeyMap) throws Exception {
        Key rv = null;
        int numKeys = 3;
        int threshold = 2;
        if (depth == 1) {
            rv = KeyExpansion.genSingleEd25519Key(pubKey2privKeyMap);
            int size = KeyExpansion.computeNumOfExpandedKeys(rv, 1, new AtomicCounter());
            Assert.assertEquals((long)1L, (long)size);
        } else if (depth == 2) {
            ArrayList<Key> keys = new ArrayList<Key>();
            keys.add(KeyExpansion.genSingleEd25519Key(pubKey2privKeyMap));
            keys.add(KeyExpansion.genThresholdKeyInstance(numKeys, threshold, pubKey2privKeyMap));
            keys.add(KeyExpansion.genKeyListInstance(numKeys, pubKey2privKeyMap));
            rv = KeyExpansion.genKeyList(keys);
            int size = KeyExpansion.computeNumOfExpandedKeys(rv, 1, new AtomicCounter());
            Assert.assertEquals((long)(1 + numKeys * 2), (long)size);
        } else {
            throw new Exception("Not implemented yet.");
        }
        return rv;
    }

    public static Key genKeyListInstance(int numKeys, Map<String, PrivateKey> pubKey2privKeyMap) {
        List<Key> keys = KeyExpansion.genEd25519Keys(numKeys, pubKey2privKeyMap);
        Key rv = KeyExpansion.genKeyList(keys);
        return rv;
    }

    public static Key genThresholdKeyInstance(int numKeys, int threshold, Map<String, PrivateKey> pubKey2privKeyMap) {
        List<Key> keys = KeyExpansion.genEd25519Keys(numKeys, pubKey2privKeyMap);
        Key rv = KeyExpansion.genThresholdKey(keys, threshold);
        return rv;
    }

    public static Key genWacl(int numWaclKeys, int depth, Map<String, PrivateKey> pubKey2privKeyMap) throws Exception {
        ArrayList<Key> keys = new ArrayList<Key>();
        for (int i = 0; i < numWaclKeys; ++i) {
            Key key = KeyExpansion.genSampleComplexKey(depth, pubKey2privKeyMap);
            keys.add(key);
        }
        Key rv = KeyExpansion.genKeyList(keys);
        return rv;
    }

    public static Key genSingleEd25519KeyByteEncodePubKey(Map<String, PrivateKey> pubKey2privKeyMap) {
        KeyPair pair = new KeyPairGenerator().generateKeyPair();
        byte[] pubKey = ((EdDSAPublicKey)pair.getPublic()).getAbyte();
        String pubKeyHex = null;
        Key akey = null;
        pubKeyHex = Hex.encodeHexString((byte[])pubKey);
        akey = Key.newBuilder().setEd25519(ByteString.copyFrom((byte[])pubKey)).build();
        pubKey2privKeyMap.put(pubKeyHex, pair.getPrivate());
        return akey;
    }

    public static SignaturePair signBasicAsSignaturePair(Key key, Map<String, PrivateKey> pubKey2privKeyMap, byte[] msgBytes) throws Exception {
        SignaturePair rv;
        if (!key.getEd25519().isEmpty()) {
            String pubKeyHex = null;
            if (USE_HEX_ENCODED_KEY) {
                pubKeyHex = key.getEd25519().toStringUtf8();
            } else {
                byte[] pubKeyBytes = key.getEd25519().toByteArray();
                pubKeyHex = Hex.encodeHexString((byte[])pubKeyBytes);
            }
            PrivateKey privKey = pubKey2privKeyMap.get(pubKeyHex);
            String sigHex = SignatureGenerator.signBytes(msgBytes, privKey);
            rv = SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFrom((byte[])Hex.decodeHex((String)pubKeyHex))).setEd25519(ByteString.copyFrom((byte[])Hex.decodeHex((String)sigHex))).build();
        } else if (!key.getECDSA384().isEmpty()) {
            String pubKeyHex = null;
            if (USE_HEX_ENCODED_KEY) {
                pubKeyHex = key.getECDSA384().toStringUtf8();
            } else {
                byte[] pubKeyBytes = key.getECDSA384().toByteArray();
                pubKeyHex = Hex.encodeHexString((byte[])pubKeyBytes);
            }
            PrivateKey privKey = pubKey2privKeyMap.get(pubKeyHex);
            String sigHex = SignatureGenerator.signBytes(msgBytes, privKey);
            rv = SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFrom((byte[])Hex.decodeHex((String)pubKeyHex))).setECDSA384(ByteString.copyFrom((byte[])Hex.decodeHex((String)sigHex))).build();
        } else {
            throw new Exception("Key type not implemented: key=" + key);
        }
        return rv;
    }

    public static void expandKeyMinimum4Signing(Key key, int depth, List<Key> expandedKeys) {
        block4: {
            block6: {
                block5: {
                    if (key.hasThresholdKey() || key.hasKeyList()) break block5;
                    expandedKeys.add(key);
                    break block4;
                }
                if (!key.hasThresholdKey()) break block6;
                List<Key> tKeys = key.getThresholdKey().getKeys().getKeysList();
                int thd = key.getThresholdKey().getThreshold();
                if (depth > KEY_EXPANSION_DEPTH) break block4;
                ++depth;
                int i = 0;
                for (Key aKey : tKeys) {
                    if (i++ >= thd) {
                        log.debug("Threshold reached, stopping key expansion.");
                        break block4;
                    }
                    KeyExpansion.expandKeyMinimum4Signing(aKey, depth, expandedKeys);
                }
                break block4;
            }
            List<Key> tKeys = key.getKeyList().getKeysList();
            if (depth <= KEY_EXPANSION_DEPTH) {
                ++depth;
                for (Key aKey : tKeys) {
                    KeyExpansion.expandKeyMinimum4Signing(aKey, depth, expandedKeys);
                }
            }
        }
    }

    public static SignaturePair signBasicAsSignaturePair(Key key, int prefixLen, Map<String, PrivateKey> pubKey2privKeyMap, byte[] msgBytes) throws Exception {
        byte[] prefixBytes;
        String pubKeyHex;
        if (!key.getEd25519().isEmpty()) {
            byte[] pubKeyBytes = key.getEd25519().toByteArray();
            pubKeyHex = Hex.encodeHexString((byte[])pubKeyBytes);
            prefixBytes = pubKeyBytes;
            if (prefixLen != -1) {
                prefixBytes = CommonUtils.copyBytes(0, prefixLen, pubKeyBytes);
            }
        } else {
            throw new Exception("Key type not implemented: key=" + key);
        }
        PrivateKey privKey = pubKey2privKeyMap.get(pubKeyHex);
        String sigHex = SignatureGenerator.signBytes(msgBytes, privKey);
        SignaturePair rv = SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFrom((byte[])prefixBytes)).setEd25519(ByteString.copyFrom((byte[])Hex.decodeHex((String)sigHex))).build();
        return rv;
    }
}

