/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.services.legacy.proto.utils;

import com.hederahashgraph.api.proto.java.FileID;
import com.hederahashgraph.api.proto.java.Timestamp;
import com.hederahashgraph.builder.RequestBuilder;
import java.time.Clock;
import java.time.Instant;

public class ProtoCommonUtils {
    public static FileID createFileID(long fileNum, long realmNum, long shardNum) {
        FileID fid = FileID.newBuilder().setFileNum(fileNum).setRealmNum(realmNum).setShardNum(shardNum).build();
        return fid;
    }

    public static Timestamp getCurrentTimestampUTC(long sec_to_wind) {
        Timestamp timestamp = null;
        timestamp = RequestBuilder.getTimestamp(Instant.now(Clock.systemUTC()).plusSeconds(sec_to_wind));
        return timestamp;
    }

    public static Instant getCurrentInstantUTC() {
        return Instant.now(Clock.systemUTC());
    }

    public static Timestamp addSecondsToTimestamp(Timestamp timestamp, long seconds) {
        return Timestamp.newBuilder().setNanos(timestamp.getNanos()).setSeconds(timestamp.getSeconds() + seconds).build();
    }
}

