/*
 * Decompiled with CFR 0.152.
 */
package com.hederahashgraph.fee;

import com.hederahashgraph.api.proto.java.CryptoCreateTransactionBody;
import com.hederahashgraph.api.proto.java.CryptoUpdateTransactionBody;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.KeyList;
import com.hederahashgraph.api.proto.java.LiveHash;
import com.hederahashgraph.api.proto.java.ResponseType;
import com.hederahashgraph.api.proto.java.Timestamp;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.api.proto.java.TransactionRecord;
import com.hederahashgraph.builder.RequestBuilder;
import com.hederahashgraph.exception.InvalidTxBodyException;
import com.hederahashgraph.fee.FeeBuilder;
import com.hederahashgraph.fee.SigValueObj;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class CryptoFeeBuilder
extends FeeBuilder {
    public FeeData getCryptoCreateTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasCryptoCreateAccount()) {
            throw new InvalidTxBodyException("CryptoCreate Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = CryptoFeeBuilder.getCommonTransactionBodyBytes(txBody);
        int cryptoCreateSize = this.getCryptoCreateAccountBodyTxSize(txBody);
        bpt = txBodySize + cryptoCreateSize + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        rbs = this.getCryptoRBS(txBody, cryptoCreateSize) + (long)(CryptoFeeBuilder.getBaseTransactionRecordSize(txBody) * 180);
        long rbsNetwork = CryptoFeeBuilder.getDefaultRBHNetworkSize() + 4320L;
        bpr = 4L;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getCryptoDeleteTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasCryptoDelete()) {
            throw new InvalidTxBodyException("CryptoCreate Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = 0;
        bpr = 4L;
        txBodySize = CryptoFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + 48 + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        rbs = CryptoFeeBuilder.getBaseTransactionRecordSize(txBody) * 180;
        long rbsNetwork = CryptoFeeBuilder.getDefaultRBHNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getCryptoTransferTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasCryptoTransfer()) {
            throw new InvalidTxBodyException("CryptoTransfer Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = 0;
        txBodySize = CryptoFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + this.getCryptoTransferBodyTxSize(txBody) + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        rbs = CryptoFeeBuilder.getBaseTransactionRecordSize(txBody) * 180;
        long rbsNetwork = CryptoFeeBuilder.getDefaultRBHNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getCryptoUpdateTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj, Timestamp expirationTimeStamp, Key existingKey) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasCryptoUpdateAccount()) {
            throw new InvalidTxBodyException("CryptoUpdate Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        CryptoUpdateTransactionBody crUpdateTxBody = txBody.getCryptoUpdateAccount();
        int txBodySize = 0;
        txBodySize = CryptoFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + this.getCryptoUpdateBodyTxSize(txBody) + sigValObj.getSignatureSize();
        rbs = CryptoFeeBuilder.getBaseTransactionRecordSize(txBody) * 180;
        vpt = sigValObj.getTotalSigCount();
        long rbsNetwork = CryptoFeeBuilder.getDefaultRBHNetworkSize();
        if (expirationTimeStamp != null && expirationTimeStamp.getSeconds() > 0L && crUpdateTxBody.hasExpirationTime()) {
            int existingKeySize;
            int newKeySize;
            if (crUpdateTxBody.getExpirationTime().getSeconds() > expirationTimeStamp.getSeconds()) {
                rbs = crUpdateTxBody.hasKey() ? (rbs += (long)(68 + CryptoFeeBuilder.getAccountKeyStorageSize(crUpdateTxBody.getKey())) * (crUpdateTxBody.getExpirationTime().getSeconds() - expirationTimeStamp.getSeconds())) : (rbs += (long)(68 + CryptoFeeBuilder.getAccountKeyStorageSize(existingKey)) * (crUpdateTxBody.getExpirationTime().getSeconds() - expirationTimeStamp.getSeconds()));
            } else if (crUpdateTxBody.hasKey() && (newKeySize = CryptoFeeBuilder.getAccountKeyStorageSize(crUpdateTxBody.getKey())) > (existingKeySize = CryptoFeeBuilder.getAccountKeyStorageSize(existingKey))) {
                Instant expirationTime = RequestBuilder.convertProtoTimeStamp(expirationTimeStamp);
                Timestamp txValidStartTimestamp = txBody.getTransactionID().getTransactionValidStart();
                Instant txValidStartTime = RequestBuilder.convertProtoTimeStamp(txValidStartTimestamp);
                Duration duration = Duration.between(txValidStartTime, expirationTime);
                long seconds = duration.getSeconds();
                rbs += (long)newKeySize * seconds;
            }
        }
        bpr = 4L;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    private int getCryptoUpdateBodyTxSize(TransactionBody txBody) {
        int cryptoAcctUpdateBodySize = 24;
        CryptoUpdateTransactionBody crUpdateTxBody = txBody.getCryptoUpdateAccount();
        if (crUpdateTxBody.hasKey()) {
            cryptoAcctUpdateBodySize += CryptoFeeBuilder.getAccountKeyStorageSize(crUpdateTxBody.getKey());
        }
        if (crUpdateTxBody.hasProxyAccountID()) {
            cryptoAcctUpdateBodySize += 24;
        }
        if (crUpdateTxBody.getSendRecordThreshold() != 0L || crUpdateTxBody.hasSendRecordThresholdWrapper()) {
            cryptoAcctUpdateBodySize += 8;
        }
        if (crUpdateTxBody.getReceiveRecordThreshold() != 0L || crUpdateTxBody.hasReceiveRecordThresholdWrapper()) {
            cryptoAcctUpdateBodySize += 8;
        }
        if (crUpdateTxBody.hasAutoRenewPeriod()) {
            cryptoAcctUpdateBodySize += 8;
        }
        if (crUpdateTxBody.hasExpirationTime()) {
            cryptoAcctUpdateBodySize += 8;
        }
        if (crUpdateTxBody.hasReceiverSigRequiredWrapper() || crUpdateTxBody.getReceiverSigRequired()) {
            cryptoAcctUpdateBodySize += 4;
        }
        return cryptoAcctUpdateBodySize;
    }

    private long getCryptoRBS(TransactionBody txBody, int crCreateSize) {
        long rbsSize = 0L;
        long seconds = 0L;
        if (txBody.hasCryptoCreateAccount()) {
            CryptoCreateTransactionBody cryptoCreate = txBody.getCryptoCreateAccount();
            if (cryptoCreate.hasAutoRenewPeriod()) {
                seconds = cryptoCreate.getAutoRenewPeriod().getSeconds();
            }
            rbsSize = (long)crCreateSize * seconds;
        }
        return rbsSize;
    }

    private int getCryptoCreateAccountBodyTxSize(TransactionBody txBody) {
        int keySize = CryptoFeeBuilder.getAccountKeyStorageSize(txBody.getCryptoCreateAccount().getKey());
        int newRealmAdminKeySize = 0;
        if (txBody.getCryptoCreateAccount().hasNewRealmAdminKey()) {
            newRealmAdminKeySize = CryptoFeeBuilder.getAccountKeyStorageSize(txBody.getCryptoCreateAccount().getNewRealmAdminKey());
        }
        int cryptoAcctBodySize = keySize + 68 + newRealmAdminKeySize;
        return cryptoAcctBodySize;
    }

    private int getCryptoTransferBodyTxSize(TransactionBody txBody) {
        int accountAmountCount = txBody.getCryptoTransfer().getTransfers().getAccountAmountsCount();
        int cryptoTransfertBodySize = 32 * accountAmountCount;
        return cryptoTransfertBodySize;
    }

    public FeeData getBalanceQueryFeeMatrices(ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 28L;
        bpr = 48 + CryptoFeeBuilder.getStateProofSize(responseType);
        return FeeData.getDefaultInstance();
    }

    public FeeData getCostTransactionRecordQueryFeeMatrices() {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 36L;
        bpr = 16L;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return FeeData.getDefaultInstance();
    }

    public FeeData getTransactionRecordQueryFeeMatrices(TransactionRecord transRecord, ResponseType responseType) {
        if (transRecord == null) {
            return FeeData.getDefaultInstance();
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 244L;
        int txRecordSize = this.getAccountTransactionRecordSize(transRecord);
        bpr = 16 + txRecordSize + CryptoFeeBuilder.getStateProofSize(responseType);
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getAccountInfoQueryFeeMatrices(Key key, List<LiveHash> liveHashes, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 236L;
        int accountInfoSize = this.getAccountInfoSize(key, liveHashes);
        bpr = 16 + accountInfoSize + CryptoFeeBuilder.getStateProofSize(responseType);
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getCryptoAccountRecordsQueryFeeMatrices(List<TransactionRecord> transRecord, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 244L;
        int txRecordListsize = 0;
        if (transRecord != null) {
            for (TransactionRecord record : transRecord) {
                txRecordListsize += this.getAccountTransactionRecordSize(record);
            }
        }
        bpr = 16 + txRecordListsize + CryptoFeeBuilder.getStateProofSize(responseType);
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getCostCryptoAccountRecordsQueryFeeMatrices() {
        return CryptoFeeBuilder.getCostForQueryByIDOnly();
    }

    public FeeData getCostCryptoAccountInfoQueryFeeMatrices() {
        return CryptoFeeBuilder.getCostForQueryByIDOnly();
    }

    private int getAccountInfoSize(Key accountKey, List<LiveHash> liveHashes) {
        int keySize = CryptoFeeBuilder.getAccountKeyStorageSize(accountKey);
        int claimSize = CryptoFeeBuilder.liveHashSize(liveHashes);
        int accountInfoSize = 68 + keySize + claimSize;
        return accountInfoSize;
    }

    private int getAccountTransactionRecordSize(TransactionRecord transRecord) {
        int memoBytesSize = 0;
        if (transRecord.getMemo() != null) {
            memoBytesSize = transRecord.getMemoBytes().size();
        }
        int acountAmountSize = 0;
        if (transRecord.hasTransferList()) {
            int accountAmountCount = transRecord.getTransferList().getAccountAmountsCount();
            acountAmountSize = accountAmountCount * 32;
        }
        int txRecordSize = 132 + memoBytesSize + acountAmountSize;
        return txRecordSize;
    }

    public FeeData getCryptoAddLiveHashTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasCryptoAddLiveHash()) {
            throw new InvalidTxBodyException("CryptoAddLiveHash Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = 0;
        txBodySize = CryptoFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + this.getCryptoAddLiveHashBodyBodyTxSize(txBody) + 24 + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        long rbsNetwork = CryptoFeeBuilder.getDefaultRBHNetworkSize();
        rbs = this.getCryptoLiveHashStorageBytesSec(txBody) + (long)(CryptoFeeBuilder.getBaseTransactionRecordSize(txBody) * 180);
        bpr = 4L;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getFeeDataMatrices(feeMatrices, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getCryptoDeleteLiveHashTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasCryptoDeleteLiveHash()) {
            throw new InvalidTxBodyException("CryptoDeleteLiveHash Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = 0;
        txBodySize = CryptoFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + this.getCryptoDeleteLiveHashBodyBodyTxSize() + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        long rbsNetwork = CryptoFeeBuilder.getDefaultRBHNetworkSize();
        rbs = this.getCryptoLiveHashStorageBytesSec(txBody) + (long)(CryptoFeeBuilder.getBaseTransactionRecordSize(txBody) * 180);
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    private int getCryptoAddLiveHashBodyBodyTxSize(TransactionBody txBody) {
        int keySize = 0;
        int keyListSize = 0;
        KeyList liveHashKeys = txBody.getCryptoAddLiveHash().getLiveHash().getKeys();
        for (Key key : liveHashKeys.getKeysList()) {
            keySize = CryptoFeeBuilder.sizeOfLiveHashKeyStorage(key);
            keyListSize = keySize + 1;
        }
        int claimHashSize = this.getLiveHashHashSize();
        int cryptoAddLiveHashBodySize = keyListSize + 24 + claimHashSize;
        return cryptoAddLiveHashBodySize;
    }

    private int getCryptoDeleteLiveHashBodyBodyTxSize() {
        int claimHashSize = this.getLiveHashHashSize();
        int cryptoDeleteLiveHashBodySize = 24 + claimHashSize;
        return cryptoDeleteLiveHashBodySize;
    }

    private int getCryptoGetLiveHashBodyTxSize() {
        int claimHashSize = this.getLiveHashHashSize();
        int cryptoGetLiveHashBodySize = 24 + claimHashSize;
        return cryptoGetLiveHashBodySize;
    }

    private int getLiveHashHashSize() {
        return 48;
    }

    private long getCryptoLiveHashStorageBytesSec(TransactionBody txBody) {
        long storageSize = 72 + txBody.getCryptoAddLiveHash().getLiveHash().getKeys().getSerializedSize();
        long seconds = txBody.getCryptoAddLiveHash().getLiveHash().getDuration().getSeconds();
        return storageSize *= seconds;
    }

    public FeeData getLiveHashFeeQueryFeeMatrices() {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 8 + this.getCryptoGetLiveHashBodyTxSize();
        sbpr = this.getCryptoGetLiveHashBodyTxSize();
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getFeeDataMatrices(feeMatrices, 0, 0L);
    }

    public FeeData getCryptoAccountRenewalFeeMatrices(Key key, long autoRenewal) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        rbs = (long)(68 + CryptoFeeBuilder.getAccountKeyStorageSize(key)) * autoRenewal;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return CryptoFeeBuilder.getFeeDataMatrices(feeMatricesForTx, 0, 0L);
    }
}

