/*
 * Decompiled with CFR 0.152.
 */
package com.hederahashgraph.fee;

import com.hederahashgraph.api.proto.java.ContractCallTransactionBody;
import com.hederahashgraph.api.proto.java.ContractCreateTransactionBody;
import com.hederahashgraph.api.proto.java.ContractFunctionResult;
import com.hederahashgraph.api.proto.java.ContractUpdateTransactionBody;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.ResponseType;
import com.hederahashgraph.api.proto.java.Timestamp;
import com.hederahashgraph.api.proto.java.TransactionBody;
import com.hederahashgraph.api.proto.java.TransactionRecord;
import com.hederahashgraph.builder.RequestBuilder;
import com.hederahashgraph.exception.InvalidTxBodyException;
import com.hederahashgraph.fee.FeeBuilder;
import com.hederahashgraph.fee.SigValueObj;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class SmartContractFeeBuilder
extends FeeBuilder {
    public FeeData getContractCreateTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasContractCreateInstance()) {
            throw new InvalidTxBodyException("ContractCreateInstance Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = 0;
        txBodySize = SmartContractFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + this.getContractCreateTransactionBodySize(txBody) + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        rbs = SmartContractFeeBuilder.getBaseTransactionRecordSize(txBody) * 90180;
        long rbsNetwork = SmartContractFeeBuilder.getDefaultRBHNetworkSize() + 4320L;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    private long getContractCreateStorageBytesSec(TransactionBody txBody) {
        long storageSize = this.getContractCreateTransactionBodySize(txBody);
        long seconds = txBody.getCryptoCreateAccount().getAutoRenewPeriod().getSeconds();
        return storageSize *= seconds;
    }

    private int getContractCreateTransactionBodySize(TransactionBody txBody) {
        ContractCreateTransactionBody contractCreate = txBody.getContractCreateInstance();
        int adminKeySize = 0;
        int proxyAcctID = 0;
        if (contractCreate.hasAdminKey()) {
            adminKeySize = SmartContractFeeBuilder.getAccountKeyStorageSize(contractCreate.getAdminKey());
        }
        int newRealmAdminKeySize = 0;
        if (contractCreate.hasNewRealmAdminKey()) {
            newRealmAdminKeySize = SmartContractFeeBuilder.getAccountKeyStorageSize(contractCreate.getNewRealmAdminKey());
        }
        int constructParamSize = 0;
        if (contractCreate.getConstructorParameters() != null) {
            constructParamSize = contractCreate.getConstructorParameters().size();
        }
        if (contractCreate.hasProxyAccountID()) {
            proxyAcctID = 24;
        }
        int memoSize = 0;
        if (contractCreate.getMemo() != null) {
            memoSize = contractCreate.getMemoBytes().size();
        }
        int contractCreateBodySize = 72 + adminKeySize + proxyAcctID + constructParamSize + newRealmAdminKeySize + memoSize;
        return contractCreateBodySize;
    }

    public FeeData getContractUpdateTxFeeMatrices(TransactionBody txBody, Timestamp contractExpiryTime, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasContractUpdateInstance()) {
            throw new InvalidTxBodyException("ContractUpdateInstance Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = 0;
        txBodySize = SmartContractFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + this.getContractUpdateBodyTxSize(txBody) + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        if (contractExpiryTime != null && contractExpiryTime.getSeconds() > 0L) {
            sbs = this.getContractUpdateStorageBytesSec(txBody, contractExpiryTime);
        }
        long rbsNetwork = SmartContractFeeBuilder.getDefaultRBHNetworkSize();
        rbs = SmartContractFeeBuilder.getBaseTransactionRecordSize(txBody) * 90180;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getContractCallTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasContractCall()) {
            throw new InvalidTxBodyException("ContractCreateInstance Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = 0;
        txBodySize = SmartContractFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + this.getContractCallBodyTxSize(txBody) + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        rbs = SmartContractFeeBuilder.getBaseTransactionRecordSize(txBody) * 90180;
        long rbsNetwork = SmartContractFeeBuilder.getDefaultRBHNetworkSize();
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }

    public FeeData getContractCallLocalFeeMatrices(int funcParamSize, ContractFunctionResult contractFuncResult, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 244 + funcParamSize + 8;
        int errorMessageSize = 0;
        int contractFuncResultSize = 0;
        if (contractFuncResult != null) {
            if (contractFuncResult.getContractCallResult() != null) {
                contractFuncResultSize = contractFuncResult.getContractCallResult().size();
            }
            if (contractFuncResult.getErrorMessage() != null) {
                errorMessageSize = contractFuncResult.getErrorMessage().length();
            }
        }
        bpr = 16 + SmartContractFeeBuilder.getStateProofSize(responseType);
        sbpr = 24 + errorMessageSize + 8 + contractFuncResultSize;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getCostContractCallLocalFeeMatrices(int funcParamSize) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 36 + funcParamSize + 8;
        bpr = 16L;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    private int getContractUpdateBodyTxSize(TransactionBody txBody) {
        int contractUpdateBodySize = 24;
        ContractUpdateTransactionBody contractUpdateTxBody = txBody.getContractUpdateInstance();
        if (contractUpdateTxBody.hasProxyAccountID()) {
            contractUpdateBodySize += 24;
        }
        if (contractUpdateTxBody.hasFileID()) {
            contractUpdateBodySize += 24;
        }
        if (contractUpdateTxBody.hasExpirationTime()) {
            contractUpdateBodySize += 8;
        }
        if (contractUpdateTxBody.hasAutoRenewPeriod()) {
            contractUpdateBodySize += 8;
        }
        if (contractUpdateTxBody.hasAdminKey()) {
            contractUpdateBodySize += SmartContractFeeBuilder.getAccountKeyStorageSize(contractUpdateTxBody.getAdminKey());
        }
        if (contractUpdateTxBody.getMemo() != null) {
            contractUpdateBodySize += contractUpdateTxBody.getMemoBytes().size();
        }
        return contractUpdateBodySize;
    }

    private int getContractCallBodyTxSize(TransactionBody txBody) {
        int contractCallBodySize = 76;
        ContractCallTransactionBody contractCallTxBody = txBody.getContractCall();
        if (contractCallTxBody.getFunctionParameters() != null) {
            contractCallBodySize += contractCallTxBody.getFunctionParameters().size();
        }
        if (contractCallTxBody.getAmount() != 0L) {
            contractCallBodySize += 8;
        }
        return contractCallBodySize;
    }

    public FeeData getContractInfoQueryFeeMatrices(Key key, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 236L;
        int keySize = 0;
        if (key != null) {
            keySize = SmartContractFeeBuilder.getAccountKeyStorageSize(key);
        }
        bpr = 16 + SmartContractFeeBuilder.getStateProofSize(responseType);
        sbpr = 100 + keySize;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getContractByteCodeQueryFeeMatrices(int byteCodeSize, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 236L;
        bpr = 16 + SmartContractFeeBuilder.getStateProofSize(responseType);
        sbpr = byteCodeSize;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getContractSolidityIDQueryFeeMatrices(ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 232L;
        bpr = 16 + SmartContractFeeBuilder.getStateProofSize(responseType) + 24;
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getContractRecordsQueryFeeMatrices(List<TransactionRecord> transRecord, ResponseType responseType) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        bpt = 236L;
        int txRecordListsize = 0;
        if (transRecord != null) {
            for (TransactionRecord record : transRecord) {
                txRecordListsize += SmartContractFeeBuilder.getTransactionRecordSize(record);
            }
        }
        bpr = 16 + txRecordListsize + SmartContractFeeBuilder.getStateProofSize(responseType);
        FeeComponents feeMatrices = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getQueryFeeDataMatrices(feeMatrices);
    }

    public FeeData getSmartContractRenewalFeeMatrices(long autoRenewal, long storageBytes) {
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        rbs = 88L * autoRenewal;
        sbs = storageBytes * autoRenewal;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getFeeDataMatrices(feeMatricesForTx, 0, 0L);
    }

    private long getContractUpdateStorageBytesSec(TransactionBody txBody, Timestamp contractExpiryTime) {
        long storageSize = 0L;
        ContractUpdateTransactionBody contractUpdateTxBody = txBody.getContractUpdateInstance();
        if (contractUpdateTxBody.hasAdminKey()) {
            storageSize += (long)SmartContractFeeBuilder.getAccountKeyStorageSize(contractUpdateTxBody.getAdminKey());
        }
        if (contractUpdateTxBody.getMemo() != null) {
            storageSize += (long)contractUpdateTxBody.getMemoBytes().size();
        }
        Instant expirationTime = RequestBuilder.convertProtoTimeStamp(contractExpiryTime);
        Timestamp txValidStartTimestamp = txBody.getTransactionID().getTransactionValidStart();
        Instant txValidStartTime = RequestBuilder.convertProtoTimeStamp(txValidStartTimestamp);
        Duration duration = Duration.between(txValidStartTime, expirationTime);
        long seconds = duration.getSeconds();
        return storageSize *= seconds;
    }

    public FeeData getContractDeleteTxFeeMatrices(TransactionBody txBody, SigValueObj sigValObj) throws InvalidTxBodyException {
        if (txBody == null || !txBody.hasContractDeleteInstance()) {
            throw new InvalidTxBodyException("ContractDelete Tx Body not available for Fee Calculation");
        }
        long bpt = 0L;
        long vpt = 0L;
        long rbs = 0L;
        long sbs = 0L;
        long gas = 0L;
        long tv = 0L;
        long bpr = 0L;
        long sbpr = 0L;
        int txBodySize = 0;
        txBodySize = SmartContractFeeBuilder.getCommonTransactionBodyBytes(txBody);
        bpt = txBodySize + 24 + 24 + sigValObj.getSignatureSize();
        vpt = sigValObj.getTotalSigCount();
        bpr = 4L;
        rbs = SmartContractFeeBuilder.getBaseTransactionRecordSize(txBody) * 180;
        long rbsNetwork = SmartContractFeeBuilder.getDefaultRBHNetworkSize() + 4320L;
        FeeComponents feeMatricesForTx = FeeComponents.newBuilder().setBpt(bpt).setVpt(vpt).setRbh(rbs).setSbh(sbs).setGas(gas).setTv(tv).setBpr(bpr).setSbpr(sbpr).build();
        return SmartContractFeeBuilder.getFeeDataMatrices(feeMatricesForTx, sigValObj.getPayerAcctSigCount(), rbsNetwork);
    }
}

