/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.FreezeServiceGrpc;
import com.hedera.hashgraph.proto.FreezeTransactionBody;
import com.hedera.hashgraph.proto.Transaction;
import com.hedera.hashgraph.proto.TransactionResponse;
import com.hedera.hashgraph.sdk.TransactionBuilder;
import io.grpc.MethodDescriptor;
import java.time.OffsetTime;
import java.time.ZoneOffset;

public class FreezeTransaction
extends TransactionBuilder<FreezeTransaction> {
    private FreezeTransactionBody.Builder builder = FreezeTransactionBody.newBuilder();

    public FreezeTransaction() {
        this.bodyBuilder.setFreeze(this.builder);
    }

    @Override
    protected void doValidate() {
        this.require(FreezeTransaction.checkHour(this.builder.getStartHour()), "startHour not in range");
        this.require(FreezeTransaction.checkMinute(this.builder.getStartMin()), "startMin not in range");
        this.require(FreezeTransaction.checkHour(this.builder.getEndHour()), "endHour not in range");
        this.require(FreezeTransaction.checkMinute(this.builder.getEndMin()), "endMin not in range");
    }

    private static boolean checkHour(int hour) {
        return hour >= 0 && hour < 24;
    }

    private static boolean checkMinute(int minute) {
        return minute >= 0 && minute < 60;
    }

    public FreezeTransaction setStartTime(OffsetTime startTime) {
        OffsetTime actual = startTime.withOffsetSameInstant(ZoneOffset.UTC);
        this.builder.setStartHour(actual.getHour());
        this.builder.setStartMin(actual.getMinute());
        return this;
    }

    public FreezeTransaction setEndTime(OffsetTime endTime) {
        OffsetTime actual = endTime.withOffsetSameInstant(ZoneOffset.UTC);
        this.builder.setEndHour(actual.getHour());
        this.builder.setEndMin(actual.getMinute());
        return this;
    }

    @Override
    protected MethodDescriptor<Transaction, TransactionResponse> getMethod() {
        return FreezeServiceGrpc.getFreezeMethod();
    }
}

