/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.proto.ResponseCodeEnum;
import com.hedera.hashgraph.proto.TransactionGetRecordResponse;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionRecord;

public class HederaRecordStatusException
extends HederaStatusException {
    public final TransactionId transactionId;
    public final TransactionRecord record;

    HederaRecordStatusException(ResponseCodeEnum responseCode, TransactionRecord record) {
        super(responseCode);
        this.record = record;
        this.transactionId = record.transactionId;
    }

    static void throwIfExceptional(TransactionGetRecordResponse recordResponse) throws HederaRecordStatusException {
        ResponseCodeEnum status = recordResponse.getTransactionRecord().getReceipt().getStatus();
        if (HederaRecordStatusException.isCodeExceptional(status)) {
            throw new HederaRecordStatusException(status, new TransactionRecord(recordResponse.getTransactionRecord()));
        }
    }

    @Override
    public String getMessage() {
        return "record for transaction " + this.transactionId + " contained error status " + (Object)((Object)this.status) + "\nthis Exception instance contains the record that was fetched";
    }
}

