/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.proto.AccountAmount;
import com.hedera.hashgraph.proto.Query;
import com.hedera.hashgraph.proto.QueryHeader;
import com.hedera.hashgraph.proto.Response;
import com.hedera.hashgraph.proto.ResponseCodeEnum;
import com.hedera.hashgraph.proto.ResponseHeader;
import com.hedera.hashgraph.proto.ResponseType;
import com.hedera.hashgraph.proto.TransactionBody;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.HederaCall;
import com.hedera.hashgraph.sdk.HederaNetworkException;
import com.hedera.hashgraph.sdk.HederaPrecheckStatusException;
import com.hedera.hashgraph.sdk.HederaReceiptStatusException;
import com.hedera.hashgraph.sdk.HederaRecordStatusException;
import com.hedera.hashgraph.sdk.HederaStatusException;
import com.hedera.hashgraph.sdk.HederaThrowable;
import com.hedera.hashgraph.sdk.LocalValidationException;
import com.hedera.hashgraph.sdk.MaxQueryPaymentExceededException;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.account.CryptoTransferTransaction;
import com.hedera.hashgraph.sdk.crypto.PublicKey;
import com.hedera.hashgraph.sdk.crypto.TransactionSigner;
import io.grpc.Channel;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public abstract class QueryBuilder<Resp, T extends QueryBuilder<Resp, T>>
extends HederaCall<Query, Response, Resp, T> {
    protected final Query.Builder inner = Query.newBuilder();
    @Nullable
    private AccountId nodeId;
    @Nullable
    private TransactionId paymentTransactionId;
    private long paymentAmount;
    private long maxPayment = 0L;

    protected QueryBuilder() {
    }

    protected abstract QueryHeader.Builder getHeaderBuilder();

    @Override
    protected Channel getChannel(Client client) {
        return this.getNode(client).getChannel();
    }

    private Node getNode(Client client) {
        if (this.nodeId == null && this.getHeaderBuilder().hasPayment()) {
            TransactionBody paymentBody;
            try {
                paymentBody = TransactionBody.parseFrom(this.getHeaderBuilder().getPayment().getBodyBytes());
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException("payment transaction was not properly encoded", e);
            }
            List<AccountAmount> transfers = paymentBody.getCryptoTransfer().getTransfers().getAccountAmountsList();
            for (AccountAmount transfer : transfers) {
                if (transfer.getAmount() <= 0L) continue;
                this.nodeId = new AccountId(transfer.getAccountID());
                break;
            }
        }
        if (this.nodeId != null) {
            return client.getNodeForId(this.nodeId);
        }
        Node node = client.pickNode();
        this.nodeId = node.accountId;
        return node;
    }

    private long getMaxPayment(Client client) {
        if (this.maxPayment > 0L) {
            return this.maxPayment;
        }
        return client.getMaxQueryPayment();
    }

    @Override
    public final Query toProto() {
        this.localValidate();
        return this.inner.build();
    }

    public T setMaxQueryPayment(Hbar maxPayment) {
        this.maxPayment = maxPayment.asTinybar();
        return (T)this;
    }

    public T setMaxQueryPayment(long maxPayment) {
        this.maxPayment = maxPayment;
        return (T)this;
    }

    public T setQueryPayment(Hbar paymentAmount) {
        return this.setQueryPayment(paymentAmount.asTinybar());
    }

    public T setQueryPayment(long paymentAmount) {
        this.paymentAmount = paymentAmount;
        return (T)this;
    }

    public T setPaymentTransaction(Transaction transaction) {
        this.getHeaderBuilder().setPayment(transaction.toProto());
        this.paymentTransactionId = transaction.id;
        return (T)this;
    }

    public long getCost(Client client) throws HederaStatusException, HederaNetworkException {
        return (Long)new CostQuery(client).execute(client);
    }

    public void getCostAsync(Client client, Consumer<Long> withCost, Consumer<HederaThrowable> onError) {
        new CostQuery(client).executeAsync(client, withCost, onError);
    }

    private void generatePayment(Client client) {
        if (this.isPaymentRequired() && !this.getHeaderBuilder().hasPayment() && client.getOperatorId() != null && client.getOperatorSigner() != null && client.getOperatorPublicKey() != null) {
            AccountId operatorId = client.getOperatorId();
            AccountId nodeId = this.getNode((Client)client).accountId;
            Transaction txPayment = ((CryptoTransferTransaction)((CryptoTransferTransaction)new CryptoTransferTransaction().setNodeAccountId(nodeId)).setTransactionId(new TransactionId(operatorId))).addSender(operatorId, this.paymentAmount).addRecipient(nodeId, this.paymentAmount).build(client).signWith(client.getOperatorPublicKey(), client.getOperatorSigner());
            this.setPaymentTransaction(txPayment);
        }
    }

    @Override
    public final Resp execute(Client client, Duration timeout) throws HederaStatusException, HederaNetworkException, LocalValidationException {
        long maxQueryPayment = client.getMaxQueryPayment();
        if (!this.getHeaderBuilder().hasPayment() && this.isPaymentRequired() && maxQueryPayment > 0L) {
            if (this.paymentAmount == 0L) {
                long cost = this.getCost(client);
                if (cost > maxQueryPayment) {
                    throw new MaxQueryPaymentExceededException(this, cost, maxQueryPayment);
                }
                this.paymentAmount = cost;
            }
            this.generatePayment(client);
        }
        return super.execute(client, timeout);
    }

    @Override
    public final void executeAsync(Client client, Duration timeout, Consumer<Resp> onSuccess, Consumer<HederaThrowable> onError) throws LocalValidationException {
        long maxQueryPayment = client.getMaxQueryPayment();
        if (!this.getHeaderBuilder().hasPayment() && this.isPaymentRequired() && maxQueryPayment > 0L) {
            this.getCostAsync(client, cost -> {
                if (cost > maxQueryPayment) {
                    onError.accept(new MaxQueryPaymentExceededException(this, (long)cost, maxQueryPayment));
                    return;
                }
                this.paymentAmount = cost;
                super.executeAsync(client, timeout, onSuccess, onError);
            }, onError);
        } else {
            super.executeAsync(client, timeout, onSuccess, onError);
        }
    }

    protected abstract void doValidate();

    protected boolean isPaymentRequired() {
        return true;
    }

    @Override
    protected final void localValidate() {
        if (this.isPaymentRequired()) {
            this.require(this.getHeaderBuilder().hasPayment(), ".setPayment() required");
        }
        this.doValidate();
        this.checkValidationErrors("query builder failed local validation");
    }

    private static ResponseHeader getResponseHeader(Response raw) {
        switch (raw.getResponseCase()) {
            case GETBYKEY: {
                return raw.getGetByKey().getHeader();
            }
            case GETBYSOLIDITYID: {
                return raw.getGetBySolidityID().getHeader();
            }
            case CONTRACTCALLLOCAL: {
                return raw.getContractCallLocal().getHeader();
            }
            case CONTRACTGETBYTECODERESPONSE: {
                return raw.getContractGetBytecodeResponse().getHeader();
            }
            case CONTRACTGETINFO: {
                return raw.getContractGetInfo().getHeader();
            }
            case CONTRACTGETRECORDSRESPONSE: {
                return raw.getContractGetRecordsResponse().getHeader();
            }
            case CRYPTOGETACCOUNTBALANCE: {
                return raw.getCryptogetAccountBalance().getHeader();
            }
            case CRYPTOGETACCOUNTRECORDS: {
                return raw.getCryptoGetAccountRecords().getHeader();
            }
            case CRYPTOGETINFO: {
                return raw.getCryptoGetInfo().getHeader();
            }
            case CRYPTOGETCLAIM: {
                return raw.getCryptoGetClaim().getHeader();
            }
            case CRYPTOGETPROXYSTAKERS: {
                return raw.getCryptoGetProxyStakers().getHeader();
            }
            case FILEGETCONTENTS: {
                return raw.getFileGetContents().getHeader();
            }
            case FILEGETINFO: {
                return raw.getFileGetInfo().getHeader();
            }
            case TRANSACTIONGETRECEIPT: {
                return raw.getTransactionGetReceipt().getHeader();
            }
            case TRANSACTIONGETRECORD: {
                return raw.getTransactionGetRecord().getHeader();
            }
            case RESPONSE_NOT_SET: {
                throw new IllegalStateException("Response not set");
            }
            case CONSENSUSGETTOPICINFO: {
                return raw.getConsensusGetTopicInfo().getHeader();
            }
        }
        throw new RuntimeException("Unhandled response case");
    }

    @Override
    protected final Resp mapResponse(Response raw) throws HederaStatusException {
        if (this.paymentTransactionId != null) {
            ResponseCodeEnum precheckCode = QueryBuilder.getResponseHeader(raw).getNodeTransactionPrecheckCode();
            HederaPrecheckStatusException.throwIfExceptional(precheckCode, this.paymentTransactionId);
        }
        switch (raw.getResponseCase()) {
            case TRANSACTIONGETRECEIPT: {
                HederaReceiptStatusException.throwIfExceptional(this.inner.getTransactionGetReceipt(), raw.getTransactionGetReceipt());
                break;
            }
            case TRANSACTIONGETRECORD: {
                HederaRecordStatusException.throwIfExceptional(raw.getTransactionGetRecord());
                break;
            }
        }
        return this.extractResponse(raw);
    }

    protected abstract Resp extractResponse(Response var1);

    private final class CostQuery
    extends HederaCall<Query, Response, Long, CostQuery> {
        private final Client client;

        CostQuery(Client client) {
            this.client = client;
        }

        @Override
        protected MethodDescriptor<Query, Response> getMethod() {
            return QueryBuilder.this.getMethod();
        }

        @Override
        public Query toProto() {
            QueryHeader.Builder header = QueryBuilder.this.getHeaderBuilder();
            com.hedera.hashgraph.proto.Transaction origPayment = header.hasPayment() ? header.getPayment() : null;
            ResponseType origResponseType = header.getResponseType();
            AccountId operatorId = Objects.requireNonNull(this.client.getOperatorId(), "COST_ANSWER requires an operator ID to be set");
            PublicKey operatorPublicKey = Objects.requireNonNull(this.client.getOperatorPublicKey());
            TransactionSigner operatorSigner = Objects.requireNonNull(this.client.getOperatorSigner());
            com.hedera.hashgraph.proto.Transaction fakePayment = new CryptoTransferTransaction().addRecipient(Objects.requireNonNull(QueryBuilder.this.nodeId), 0L).addSender(operatorId, 0L).build(this.client).signWith(operatorPublicKey, operatorSigner).toProto();
            header.setPayment(fakePayment);
            header.setResponseType(ResponseType.COST_ANSWER);
            Query built = QueryBuilder.this.inner.build();
            if (origPayment != null) {
                header.setPayment(origPayment);
            } else {
                header.clearPayment();
            }
            header.setResponseType(origResponseType);
            return built;
        }

        @Override
        protected Channel getChannel(Client client) {
            return QueryBuilder.this.getChannel(client);
        }

        @Override
        protected Duration getDefaultTimeout() {
            return QueryBuilder.this.getDefaultTimeout();
        }

        @Override
        protected Long mapResponse(Response raw) throws HederaStatusException {
            return QueryBuilder.getResponseHeader(raw).getCost();
        }

        @Override
        public void localValidate() {
        }
    }
}

