/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Internal;
import com.hedera.hashgraph.sdk.account.AccountId;
import com.hedera.hashgraph.sdk.contract.ContractId;
import com.hedera.hashgraph.sdk.file.FileId;
import java.nio.ByteBuffer;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;

@Internal
public final class SolidityUtil {
    public static final int ADDRESS_LEN = 20;
    public static final int ADDRESS_LEN_HEX = 40;

    private SolidityUtil() {
    }

    public static String addressForEntity(long shardNum, long realmNum, long entityNum) {
        if (Long.highestOneBit(shardNum) > 32L) {
            throw new IllegalArgumentException("shardNum out of 32-bit range " + shardNum);
        }
        return Hex.toHexString((byte[])ByteBuffer.allocate(20).putInt((int)shardNum).putLong(realmNum).putLong(entityNum).array());
    }

    public static String addressFor(AccountId accountId) {
        return SolidityUtil.addressForEntity(accountId.shard, accountId.realm, accountId.account);
    }

    public static String addressFor(ContractId contractId) {
        return SolidityUtil.addressForEntity(contractId.shard, contractId.realm, contractId.contract);
    }

    public static String addressFor(FileId fileId) {
        return SolidityUtil.addressForEntity(fileId.shard, fileId.realm, fileId.file);
    }

    public static <T> T parseAddress(String address, WithAddress<T> withAddress) {
        return SolidityUtil.decodeAddress(SolidityUtil.decodeAddress(address), withAddress);
    }

    public static <T> T decodeAddress(byte[] address, WithAddress<T> withAddress) {
        SolidityUtil.checkAddressLen(address);
        ByteBuffer buf = ByteBuffer.wrap(address);
        return withAddress.apply(buf.getInt(), buf.getLong(), buf.getLong());
    }

    static void checkAddressLen(byte[] address) {
        if (address.length != 20) {
            throw new IllegalArgumentException("Solidity addresses must be 20 bytes or 40 hex chars");
        }
    }

    static byte[] decodeAddress(String address) {
        if (address.length() != 40) {
            throw new IllegalArgumentException("Solidity addresses must be 20 bytes or 40 hex chars");
        }
        try {
            return Hex.decode((String)address);
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("failed to decode Solidity address as hex", e);
        }
    }

    @FunctionalInterface
    public static interface WithAddress<T> {
        public T apply(long var1, long var3, long var5);
    }
}

